(ns <<project-ns>>.layout.layout-main
  (:require
   [re-frame.core :as rf]
   [<<project-ns>>.router :refer [routes]]
   [<<project-ns>>.common.route-mapping :refer [main-switch-route]]
   [<<project-ns>>.layout.side-menu :refer [create-side-menus-by-data]]
   [<<project-ns>>.layout.layout-events :as layout-events]
   [<<project-ns>>.layout.layout-views :refer [basic-layout]]))

(def breadcrumbs (rf/subscribe [:layout/breadcrumbs]))
(def menus (rf/subscribe [:base/current-menus]))


(defn layout-page []
  (fn []
    (let [side-menus (create-side-menus-by-data @menus)
          switch-route (main-switch-route @routes)]
      [:div
       [basic-layout side-menus @breadcrumbs switch-route]])))
