(ns leiningen.new.hc-template
  (:require [leiningen.new.templates :refer [multi-segment sanitize-ns renderer
                                             name-to-path ->files project-name year sanitize]]
            [leiningen.core.main :as main]
            [selmer.parser :as selmer]
            [clojure.string :as string]
            [leiningen.new.generation :refer :all]
            [clojure.java.io :as io]))

(defn timestamp [n]
  (.format
      (java.text.SimpleDateFormat. "yyyyMMddHHmm")
      (java.util.Date.)))

(def project-assets
  [["dev-config.edn" "dev-config.edn"]
   [".gitignore" "gitignore"]
   [".projectile" "projectile"]
   ["Procfile" "Procfile"]
   ["project.clj" "project.clj"]
   ["Dockerfile" "Dockerfile"]
   ["Capstanfile" "Capstanfile"]
   ["README.md" "README.md"]
   ["shadow-cljs.edn" "shadow-cljs.edn"]
   ["package.json" "package.json"]])

(def clj-core-aeests
  [["{{backend-path}}/{{sanitized}}/core.clj" "src/clj/core.clj"]
   ["{{backend-path}}/{{sanitized}}/nrepl.clj" "src/clj/nrepl.clj"]
   ["{{backend-path}}/{{sanitized}}/config.clj" "src/clj/config.clj"]
   ["{{backend-path}}/{{sanitized}}/handler.clj" "src/clj/handler.clj"]
   ["{{backend-path}}/{{sanitized}}/middleware.clj" "src/clj/middleware.clj"]
   ["{{backend-path}}/{{sanitized}}/middleware/authentication.clj" "src/clj/middleware/authentication.clj"]
   ["{{backend-path}}/{{sanitized}}/middleware/log_interceptor.clj" "src/clj/middleware/log_interceptor.clj"]
   ["{{backend-path}}/{{sanitized}}/middleware/formats.clj" "src/clj/middleware/formats.clj"]
   ["{{backend-path}}/{{sanitized}}/middleware/exception.clj" "src/clj/middleware/exception.clj"]
   ["{{backend-path}}/{{sanitized}}/db/core.clj" "src/clj/db/core.clj"]
   ["{{backend-path}}/{{sanitized}}/db/db_sys_dict.clj" "src/clj/db/db_sys_dict.clj"]
   ["{{backend-path}}/{{sanitized}}/routes/base.clj" "src/clj/routes/base.clj"]
   ["{{backend-path}}/{{sanitized}}/routes/demo.clj" "src/clj/routes/demo.clj"]
   ;;db.modules
   ;;base
   ["{{backend-path}}/{{sanitized}}/modules/base/base_amdin_routes.clj" "src/clj/modules/base/base_amdin_routes.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/base/base_db.clj" "src/clj/modules/base/base_db.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/base/base_specs.clj" "src/clj/modules/base/base_specs.clj"]
   ;;file
   ["{{backend-path}}/{{sanitized}}/modules/file/file_admin_routes.clj" "src/clj/modules/file/file_admin_routes.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/file/file_specs.clj" "src/clj/modules/file/file_specs.clj"]
   ;;sys
   ["{{backend-path}}/{{sanitized}}/modules/sys/auth_routes.clj" "src/clj/modules/sys/auth_routes.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/sys/auth_service.clj" "src/clj/modules/sys/auth_service.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/sys/auth_specs.clj" "src/clj/modules/sys/auth_specs.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/sys/sys_dict_routes.clj" "src/clj/modules/sys/sys_dict_routes.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/sys/sys_menu_service.clj" "src/clj/modules/sys/sys_menu_service.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/sys/sys_role_service.clj" "src/clj/modules/sys/sys_role_service.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/sys/sys_routes.clj" "src/clj/modules/sys/sys_routes.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/sys/sys_specs.clj" "src/clj/modules/sys/sys_specs.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/sys/sys_user_db.clj" "src/clj/modules/sys/sys_user_db.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/sys/sys_user_service.clj" "src/clj/modules/sys/sys_user_service.clj"]

   ;;wx
   ["{{backend-path}}/{{sanitized}}/modules/wx/wx_routes.clj" "src/clj/modules/wx/wx_routes.clj"]
   ["{{backend-path}}/{{sanitized}}/modules/wx/wx_specs.clj" "src/clj/modules/wx/wx_specs.clj"]
   ;;app
   ["{{backend-path}}/{{sanitized}}/modules/app/app_db.clj" "src/clj/modules/app/app_db.clj"]
   ;;user
   ["{{backend-path}}/{{sanitized}}/modules/user/user_db.clj" "src/clj/modules/user/user_db.clj"] 
   ;;queries
   ["{{backend-path}}/{{sanitized}}/modules/queries/queries_db.clj" "src/clj/modules/queries/queries_db.clj"]
   ;;test
   ["{{backend-test-path}}/{{sanitized}}/test/handler.clj" "test/clj/handler.clj"]
   ["{{backend-test-path}}/{{sanitized}}/test/db/core.clj" "test/clj/db/core.clj"]
   ["{{backend-test-path}}/{{sanitized}}/utils.clj" "test/clj/utils.clj"]
   ["{{backend-test-path}}/{{sanitized}}/modules/sys/auth_routes_test.clj" "test/clj/modules/sys/auth_routes_test.clj"]
   ["{{backend-test-path}}/{{sanitized}}/modules/sys/sys_dict_routes_test.clj" "test/clj/modules/sys/sys_dict_routes_test.clj"]
   ["{{backend-test-path}}/{{sanitized}}/modules/sys/sys_user_menu_service_test.clj" "test/clj/modules/sys/sys_user_menu_service_test.clj"]
   ["{{backend-test-path}}/{{sanitized}}/modules/sys/sys_user_role_service_test.clj" "test/clj/modules/sys/sys_user_role_service_test.clj"]
   ["{{backend-test-path}}/{{sanitized}}/modules/sys/sys_user_service_test.clj" "test/clj/modules/sys/sys_user_service_test.clj"]
   ["{{backend-test-path}}/{{sanitized}}/modules/base/base_admin_routes_test.clj" "test/clj/modules/base/base_admin_routes_test.clj"]
   ["{{backend-test-path}}/{{sanitized}}/modules/wx/wx_routes_test.clj" "test/clj/modules/wx/wx_routes_test.clj"]
   ["{{backend-test}}/11.jpg" "test/11.jpg"]
   ["{{backend-test-path}}/{{sanitized}}/common/biz_error_test.clj" "test/clj/common/biz_error_test.clj"]
   ["{{backend-test-path}}/{{sanitized}}/common/encrypt_test.clj" "test/clj/common/encrypt_test.clj"]
   ["{{backend-test-path}}/{{sanitized}}/common/file_util_tset.clj" "test/clj/common/file_util_tset.clj"]
   ["{{backend-test-path}}/{{sanitized}}/common/result_test.clj" "test/clj/common/result_test.clj"]
   ["{{backend-test-path}}/{{sanitized}}/common/utils_format_test.clj" "test/clj/common/utils_format_test.clj"]
   ["{{backend-test-path}}/{{sanitized}}/common/utils_test.clj" "test/clj/common/utils_test.clj"]
   ["{{backend-test-path}}/{{sanitized}}/db/common_service_test.clj" "test/clj/db/common_service_test.clj"]
   ;; hc clj
   ["{{backend-path}}/{{sanitized}}/db/redis.clj"           "src/clj/db/redis.clj"]
   ["{{backend-path}}/{{sanitized}}/db/common_db.clj"       "src/clj/db/common_db.clj"]
   ["{{backend-path}}/{{sanitized}}/db/common_service.clj"  "src/clj/db/common_service.clj"]
   ["{{backend-path}}/{{sanitized}}/common/result.clj"      "src/clj/common/result.clj"]
   ["{{backend-path}}/{{sanitized}}/common/utils.clj"       "src/clj/common/utils.clj"]
   ["{{backend-path}}/{{sanitized}}/common/file_util.clj"   "src/clj/common/file_util.clj"]
   ["{{backend-path}}/{{sanitized}}/common/encrypt.clj"     "src/clj/common/encrypt.clj"]
   ["{{backend-path}}/{{sanitized}}/common/biz_error.clj"   "src/clj/common/biz_error.clj"]
   ["{{backend-path}}/{{sanitized}}/common/token.clj"       "src/clj/common/token.clj"]
   ["{{backend-path}}/{{sanitized}}/common/aes_utils.clj"       "src/clj/common/aes_utils.clj"]
   ["{{backend-path}}/{{sanitized}}/common/utils_format.clj"  "src/clj/common/utils_format.clj"]])

(def environment-assets
  [["env/dev/clj/user.clj"            "env/dev/clj/user.clj"]
   ["env/dev/resources/config.edn"    "env/dev/resources/config.edn"]
   ["env/dev/resources/logback.xml"   "env/dev/resources/logback.xml"]
   ["env/dev/clj/{{sanitized}}/env.clj" "env/dev/clj/env.clj"]
   ["env/test/resources/config.edn"   "env/test/resources/config.edn"]
   ["env/test/resources/logback.xml"  "env/test/resources/logback.xml"]
   ["env/prod/resources/config.edn"   "env/prod/resources/config.edn"]
   ["env/prod/resources/logback.xml"  "env/prod/resources/logback.xml"]

   ["resources/doc/CLJ.README.md"   "resources/doc/CLJ.README.md"]
   ["resources/doc/CLJS.README.md"  "resources/doc/CLJS.README.md"]

   ["env/dev/clj/{{sanitized}}/env.clj"             "env/dev/clj/env.clj"]
   ["env/dev/clj/{{sanitized}}/dev_middleware.clj"  "env/dev/clj/dev_middleware.clj"]
   ["env/prod/clj/{{sanitized}}/env.clj"             "env/prod/clj/env.clj"]])

(def db-assets
  [[(str "{{resource-path}}/migrations/" (timestamp 1) "01" "-sys-table.down.sql") "resources/migrations/20190917075936-sys-table.down.sql"]
   [(str "{{resource-path}}/migrations/" (timestamp 2) "01" "-sys-table.up.sql") "resources/migrations/20190917075936-sys-table.up.sql"]
   [(str "{{resource-path}}/migrations/" (timestamp 3) "03" "-sys-data.down.sql") "resources/migrations/20191118221500-sys-data.down.sql"]
   [(str "{{resource-path}}/migrations/" (timestamp 4) "03" "-sys-data.up.sql") "resources/migrations/20191118221500-sys-data.up.sql"]
   [(str "{{resource-path}}/migrations/" (timestamp 5) "04" "-add-users-table.down.sql") "resources/migrations/20190831145908-add-users-table.down.sql"]
   [(str "{{resource-path}}/migrations/" (timestamp 6) "04" "-add-users-table.up.sql") "resources/migrations/20190831145908-add-users-table.up.sql"]
   [(str "{{resource-path}}/migrations/" (timestamp 7) "05" "-app-xw-table.down.sql") "resources/migrations/20210113035557-app-xw-table.down.sql"]
   [(str "{{resource-path}}/migrations/" (timestamp 8) "05" "-app-xw-table.up.sql") "resources/migrations/20210113035557-app-xw-table.up.sql"]

   ["{{resource-path}}/sql/common_utils.sql" "resources/sql/common_utils.sql"]
   ["{{resource-path}}/sql/queries.sql" "resources/sql/queries.sql"]
   ["{{resource-path}}/sql/sys_dict.sql" "resources/sql/sys_dict.sql"]
   ["{{resource-path}}/sql/sys_menu.sql" "resources/sql/sys_menu.sql"]
   ["{{resource-path}}/sql/sys_role.sql" "resources/sql/sys_role.sql"]
   ["{{resource-path}}/sql/sys_user.sql" "resources/sql/sys_user.sql"]
   ["{{resource-path}}/sql/company.sql" "resources/sql/company.sql"]
   ["{{resource-path}}/sql/app.sql" "resources/sql/app.sql"]
   ["{{resource-path}}/sql/user.sql" "resources/sql/user.sql"]])

(def cljs-core-assets
  [["env/dev/cljs/{{sanitized}}/app.cljs" "env/dev/cljs/app.cljs"]
   ["env/prod/clj/{{sanitized}}/app.cljs" "env/prod/cljs/app.cljs"]
   ["{{client-path}}/{{sanitized}}/config.cljs" "src/cljs/config.cljs"]
   ["{{client-path}}/{{sanitized}}/core.cljs" "src/cljs/core.cljs"]
   ["{{client-path}}/{{sanitized}}/index.cljs" "src/cljs/index.cljs"]
   ["{{client-path}}/{{sanitized}}/router.cljs" "src/cljs/router.cljs"]
   ["{{client-path}}/{{sanitized}}/url.cljs" "src/cljs/url.cljs"]
   ;; css
   ["{{resource-path}}/public/css/layout.css" "resources/public/css/layout.css"]
   ["{{resource-path}}/public/css/login.css" "resources/public/css/login.css"]
   ["{{resource-path}}/public/css/product.css" "resources/public/css/product.css"]
   ["{{resource-path}}/public/css/footer_toolbar.css" "resources/public/css/footer_toolbar.css"]
   ["{{resource-path}}/public/css/custom.css" "resources/public/css/custom.css"]
   ["{{resource-path}}/public/css/upload.css" "resources/public/css/upload.css"]
   ;; login
   ["{{client-path}}/{{sanitized}}/login/login_views.cljs" "src/cljs/login/login_views.cljs"]
   ["{{client-path}}/{{sanitized}}/login/login_events.cljs" "src/cljs/login/login_events.cljs"]
   ;;layout-5
   ["{{client-path}}/{{sanitized}}/layout/layout_views.cljs" "src/cljs/layout/layout_views.cljs"]
   ["{{client-path}}/{{sanitized}}/layout/layout_events.cljs" "src/cljs/layout/layout_events.cljs"]
   ["{{client-path}}/{{sanitized}}/layout/layout_main.cljs" "src/cljs/layout/layout_main.cljs"]
   ["{{client-path}}/{{sanitized}}/layout/global_footer.cljs" "src/cljs/layout/global_footer.cljs"]
   ["{{client-path}}/{{sanitized}}/layout/side_menu.cljs" "src/cljs/layout/side_menu.cljs"]
   ;;common-4
   ["{{client-path}}/{{sanitized}}/common/utils.cljs" "src/cljs/common/utils.cljs"]
   ["{{client-path}}/{{sanitized}}/common/reitit_router.cljs" "src/cljs/common/reitit_router.cljs"]
   ["{{client-path}}/{{sanitized}}/common/route_mapping.cljs" "src/cljs/common/route_mapping.cljs"]
   ["{{client-path}}/{{sanitized}}/common/storage.cljs" "src/cljs/common/storage.cljs"]
   ["{{client-path}}/{{sanitized}}/common/request.cljs" "src/cljs/common/request.cljs"]
   ["{{client-path}}/{{sanitized}}/common/enums.cljs"   "src/cljs/common/enums.cljs"]
   ["{{client-path}}/{{sanitized}}/common/msg_fx.cljs" "src/cljs/common/msg_fx.cljs"]
   ["{{client-path}}/{{sanitized}}/common/utils_auth.cljs" "src/cljs/common/utils_auth.cljs"]

   ;;components-3
   ["{{client-path}}/{{sanitized}}/components/city.cljs" "src/cljs/components/city.cljs"]
   ["{{client-path}}/{{sanitized}}/components/common_page.cljs" "src/cljs/components/common_page.cljs"]
   ["{{client-path}}/{{sanitized}}/components/hc_img.cljs" "src/cljs/components/hc_img.cljs"]
   ["{{client-path}}/{{sanitized}}/components/hc_upload.cljs" "src/cljs/components/hc_upload.cljs"]
   ["{{client-path}}/{{sanitized}}/components/upload.cljs" "src/cljs/components/upload.cljs"]])

(def system-assets
  [;;system-user demo
   ["{{client-path}}/{{sanitized}}/system/user/sys_user_views.cljs" "src/cljs/system/user/sys_user_views.cljs"]
   ["{{client-path}}/{{sanitized}}/system/user/sys_user_events.cljs" "src/cljs/system/user/sys_user_events.cljs"]
   ["{{client-path}}/{{sanitized}}/system/user/sys_user_sub.cljs" "src/cljs/system/user/sys_user_sub.cljs"]
   ["{{client-path}}/{{sanitized}}/system/user/sys_user_main.cljs" "src/cljs/system/user/sys_user_main.cljs"]
   ;;system-role demo
   ["{{client-path}}/{{sanitized}}/system/role/sys_role_views.cljs" "src/cljs/system/role/sys_role_views.cljs"]
   ["{{client-path}}/{{sanitized}}/system/role/sys_role_events.cljs" "src/cljs/system/role/sys_role_events.cljs"]
   ["{{client-path}}/{{sanitized}}/system/role/sys_role_main.cljs" "src/cljs/system/role/sys_role_main.cljs"]
   ;;system-menu demo
   ["{{client-path}}/{{sanitized}}/system/menu/sys_menu_views.cljs" "src/cljs/system/menu/sys_menu_views.cljs"]
   ["{{client-path}}/{{sanitized}}/system/menu/sys_menu_events.cljs" "src/cljs/system/menu/sys_menu_events.cljs"]
   ["{{client-path}}/{{sanitized}}/system/menu/sys_menu_main.cljs" "src/cljs/system/menu/sys_menu_main.cljs"]
   ;;system-dict demo
   ["{{client-path}}/{{sanitized}}/system/dict/sys_dict_views.cljs" "src/cljs/system/dict/sys_dict_views.cljs"]
   ["{{client-path}}/{{sanitized}}/system/dict/sys_dict_events.cljs" "src/cljs/system/dict/sys_dict_events.cljs"]
   ["{{client-path}}/{{sanitized}}/system/dict/sys_dict_main.cljs" "src/cljs/system/dict/sys_dict_main.cljs"]
   ["{{client-path}}/{{sanitized}}/system/dict/sys_dict_sub.cljs" "src/cljs/system/dict/sys_dict_sub.cljs"]])

(def binary-assets
  [["{{resource-path}}/public/favicon.ico" "resources/public/favicon.ico"]
   ["{{resource-path}}/public/index.html" "resources/public/index.html"]
   ["{{resource-path}}/public/img/warning_clojure.png" "resources/public/img/warning_clojure.png"]
   ["{{resource-path}}/public/img/img_index.png" "resources/public/img/img_index.png"]
   ["{{resource-path}}/public/img/img_index_icon.png" "resources/public/img/img_index_icon.png"]])

(def core-assets
  (vec (concat project-assets
               clj-core-aeests
               environment-assets
               db-assets
               cljs-core-assets
               system-assets)))

(def project-relative-paths
  {:backend-path      "src/clj"
   :backend-test-path "test/clj"
   :backend-test      "test"
   :client-path       "src/cljs"
   :client-test-path  "test/cljs"
   :resource-path     "resources"
   :cljc-path         "src/cljc"
   :db-path           "src/clj"
   :source-paths      ["src/clj"]
   :resource-paths    ["resources"]
   :now               (java.util.Date.)})

(def render (renderer "hc-template" render-template))

(defn generate-project
  "Create a new Luminus project"
  [options]
  (main/info "Generating a hc-template project. Please read README.md firstly !")
  (render-assets core-assets binary-assets options))

(defn hc-template
  "init function"
  [name & feature-params]
  (let [supported-features #{"+clj"
                             "+cljs"}
        options (merge
                  project-relative-paths
                  {:name             (project-name name)
                   :selmer-renderer  render-template
                   :min-lein-version "2.0.0"
                   :project-ns       (sanitize-ns name)
                   :sanitized        (name-to-path name)
                   :year             (year)})
        unsupported (-> (set feature-params)
                        (clojure.set/difference supported-features)
                        (not-empty))]
(cond
  (re-matches #"\A\+.+" name)
  (main/info "Project name is missing.\nTry: lein new luminus PROJECT_NAME"
             name (clojure.string/join " " (:features options)))

  (.exists (io/file name))
  (main/info "Could not create project because a directory named" name "already exists!")

  :else
  (-> options generate-project))))

