(ns powderkeg.examples
  (:require [powderkeg.core :as keg]
    [clojure.string :as str]
    [net.cgrand.xforms :as x]))

(defn wordcount [lines]
  (-> lines
    (keg/rdd (x/for [line %, word (str/split % #" ")] [word 1]))
    (keg/key-by (x/reduce +))))

(defn wordcount [lines]
  (keg/rdd lines 
    (x/for [line %, word (str/split % #" ")] [word 1])
    (keg/key-by (x/reduce +))))

(defn avgs [input]
  (keg/by-key input ; assume input is already a pair rdd
    :pre (map (fn [v] [v 1]))
    (x/reduce (partial mapv +) [0.0 0])
    :post (map (fn [[sum n]] (/ sum n)))))

(join links ranks
  (x/for [[page [links rank]] %
          :let [w (/ rank (count links))]
          dest links]
    [dest w]))

(defn pagerank [links]
  (letfn [(pagerank1 [ranks]
            (keg/join links ranks
              (x/for [[page [links rank]] %
                      :let [w (/ rank (count links))]
                      dest links]
                [dest w])
              (keg/by-key (x/reduce +)
                :post (map #(+ 0.15 (* 0.85 %))))))]
    (nth (iterate pagerank1 (keg/by-key links (map (constantly 1.0)) :shuffle false)) 10)))


;; by-key as a super transducer
;; a transducer is rf -> rf
;; a XXX could be make-rdd -> make-rdd

(defn xform-type [x]
  (cond
    (rdd-transformer)
    :else ::transducer))

(partition-by xform-type xforms)

