(ns gram-api.ll
  (:require [clj-http.lite.client :as client]))

(def server "https://api.telegram.org/")

(defn call-api- [url query-params]
  (client/get (str server "bot" url)
              {:query-params         query-params
               :throw-exceptions     false
               :ignore-unknown-host? true}))

(defn send-message [api-key query-params]
  (call-api- (str api-key "/sendMessage") query-params))

(defn get-updates [api-key query-params]
  (call-api- (str api-key "/getUpdates") query-params))

(defn get-file [api-key query-params]
  (call-api- (str api-key "/getFile") query-params))
