/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRStreamProducerEGLSurface {
    public static final int EGL_STREAM_BIT_KHR = 2048;

    protected KHRStreamProducerEGLSurface() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateStreamProducerSurfaceKHR);
    }

    public static long neglCreateStreamProducerSurfaceKHR(long dpy, long config, long stream, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateStreamProducerSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(stream);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, stream, attrib_list);
    }

    public static long eglCreateStreamProducerSurfaceKHR(long dpy, long config, long stream, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return KHRStreamProducerEGLSurface.neglCreateStreamProducerSurfaceKHR(dpy, config, stream, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreateStreamProducerSurfaceKHR(long dpy, long config, long stream, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateStreamProducerSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(stream);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, stream, attrib_list);
    }
}

