/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NVGColor
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RGBA;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    NVGColor(long address, ByteBuffer container) {
        super(address, container);
    }

    public NVGColor(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NVGColor.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FloatBuffer rgba() {
        return NVGColor.nrgba(this.address());
    }

    public float rgba(int index) {
        return NVGColor.nrgba(this.address(), index);
    }

    public float r() {
        return NVGColor.nr(this.address());
    }

    public float g() {
        return NVGColor.ng(this.address());
    }

    public float b() {
        return NVGColor.nb(this.address());
    }

    public float a() {
        return NVGColor.na(this.address());
    }

    public NVGColor rgba(FloatBuffer value) {
        NVGColor.nrgba(this.address(), value);
        return this;
    }

    public NVGColor rgba(int index, float value) {
        NVGColor.nrgba(this.address(), index, value);
        return this;
    }

    public NVGColor r(float value) {
        NVGColor.nr(this.address(), value);
        return this;
    }

    public NVGColor g(float value) {
        NVGColor.ng(this.address(), value);
        return this;
    }

    public NVGColor b(float value) {
        NVGColor.nb(this.address(), value);
        return this;
    }

    public NVGColor a(float value) {
        NVGColor.na(this.address(), value);
        return this;
    }

    public NVGColor nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public NVGColor set(NVGColor src) {
        return this.nset(src.address());
    }

    public static NVGColor malloc() {
        return NVGColor.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NVGColor calloc() {
        return NVGColor.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NVGColor create() {
        return new NVGColor(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NVGColor create(long address) {
        return address == 0L ? null : new NVGColor(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NVGColor.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NVGColor.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NVGColor mallocStack() {
        return NVGColor.mallocStack(MemoryStack.stackGet());
    }

    public static NVGColor callocStack() {
        return NVGColor.callocStack(MemoryStack.stackGet());
    }

    public static NVGColor mallocStack(MemoryStack stack) {
        return NVGColor.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NVGColor callocStack(MemoryStack stack) {
        return NVGColor.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NVGColor.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NVGColor.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NVGColor.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NVGColor.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nrgba(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)RGBA, 4);
    }

    public static float nrgba(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)RGBA + (long)(index * 4));
    }

    public static float nr(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)R);
    }

    public static float ng(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)G);
    }

    public static float nb(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)B);
    }

    public static float na(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)A);
    }

    public static void nrgba(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RGBA, value.remaining() * 4);
    }

    public static void nrgba(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)RGBA + (long)(index * 4), value);
    }

    public static void nr(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)R, value);
    }

    public static void ng(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)G, value);
    }

    public static void nb(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)B, value);
    }

    public static void na(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)A, value);
    }

    static {
        Struct.Layout layout = NVGColor.__struct(NVGColor.__union(NVGColor.__array(4, 4), NVGColor.__struct(NVGColor.__member(4), NVGColor.__member(4), NVGColor.__member(4), NVGColor.__member(4))));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RGBA = layout.offsetof(1);
        R = layout.offsetof(3);
        G = layout.offsetof(4);
        B = layout.offsetof(5);
        A = layout.offsetof(6);
    }

    public static final class Buffer
    extends StructBuffer<NVGColor, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NVGColor newInstance(long address) {
            return new NVGColor(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FloatBuffer rgba() {
            return NVGColor.nrgba(this.address());
        }

        public float rgba(int index) {
            return NVGColor.nrgba(this.address(), index);
        }

        public float r() {
            return NVGColor.nr(this.address());
        }

        public float g() {
            return NVGColor.ng(this.address());
        }

        public float b() {
            return NVGColor.nb(this.address());
        }

        public float a() {
            return NVGColor.na(this.address());
        }

        public Buffer rgba(FloatBuffer value) {
            NVGColor.nrgba(this.address(), value);
            return this;
        }

        public Buffer rgba(int index, float value) {
            NVGColor.nrgba(this.address(), index, value);
            return this;
        }

        public Buffer r(float value) {
            NVGColor.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            NVGColor.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            NVGColor.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            NVGColor.na(this.address(), value);
            return this;
        }
    }
}

