/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTBlendFuncExtended {
    public static final int GL_SRC1_COLOR_EXT = 35065;
    public static final int GL_SRC1_ALPHA_EXT = 34185;
    public static final int GL_ONE_MINUS_SRC1_COLOR_EXT = 35066;
    public static final int GL_ONE_MINUS_SRC1_ALPHA_EXT = 35067;
    public static final int GL_SRC_ALPHA_SATURATE_EXT = 776;
    public static final int GL_LOCATION_INDEX_EXT = 37647;
    public static final int GL_MAX_DUAL_SOURCE_DRAW_BUFFERS_EXT = 35068;

    protected EXTBlendFuncExtended() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glBindFragDataLocationIndexedEXT, caps.glGetFragDataIndexEXT, caps.glBindFragDataLocationEXT, caps.glGetProgramResourceLocationIndexEXT);
    }

    public static void nglBindFragDataLocationIndexedEXT(int program, int colorNumber, int index, long name) {
        long __functionAddress = GLES.getCapabilities().glBindFragDataLocationIndexedEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, colorNumber, index, name);
    }

    public static void glBindFragDataLocationIndexedEXT(int program, int colorNumber, int index, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        EXTBlendFuncExtended.nglBindFragDataLocationIndexedEXT(program, colorNumber, index, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glBindFragDataLocationIndexedEXT(int program, int colorNumber, int index, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            EXTBlendFuncExtended.nglBindFragDataLocationIndexedEXT(program, colorNumber, index, MemoryUtil.memAddress(nameEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nglGetFragDataIndexEXT(int program, long name) {
        long __functionAddress = GLES.getCapabilities().glGetFragDataIndexEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, program, name);
    }

    public static int glGetFragDataIndexEXT(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return EXTBlendFuncExtended.nglGetFragDataIndexEXT(program, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFragDataIndexEXT(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = EXTBlendFuncExtended.nglGetFragDataIndexEXT(program, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglBindFragDataLocationEXT(int program, int colorNumber, long name) {
        long __functionAddress = GLES.getCapabilities().glBindFragDataLocationEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, colorNumber, name);
    }

    public static void glBindFragDataLocationEXT(int program, int colorNumber, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        EXTBlendFuncExtended.nglBindFragDataLocationEXT(program, colorNumber, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glBindFragDataLocationEXT(int program, int colorNumber, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            EXTBlendFuncExtended.nglBindFragDataLocationEXT(program, colorNumber, MemoryUtil.memAddress(nameEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nglGetProgramResourceLocationIndexEXT(int program, int programInterface, long name) {
        long __functionAddress = GLES.getCapabilities().glGetProgramResourceLocationIndexEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, program, programInterface, name);
    }

    public static int glGetProgramResourceLocationIndexEXT(int program, int programInterface, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return EXTBlendFuncExtended.nglGetProgramResourceLocationIndexEXT(program, programInterface, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgramResourceLocationIndexEXT(int program, int programInterface, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = EXTBlendFuncExtended.nglGetProgramResourceLocationIndexEXT(program, programInterface, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

