/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class OESGetProgramBinary {
    public static final int GL_PROGRAM_BINARY_LENGTH_OES = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS_OES = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS_OES = 34815;

    protected OESGetProgramBinary() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glGetProgramBinaryOES, caps.glProgramBinaryOES);
    }

    public static void nglGetProgramBinaryOES(int program, int bufSize, long length, long binaryFormat, long binary) {
        long __functionAddress = GLES.getCapabilities().glGetProgramBinaryOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, program, bufSize, length, binaryFormat, binary);
    }

    public static void glGetProgramBinaryOES(int program, IntBuffer length, IntBuffer binaryFormat, ByteBuffer binary) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        OESGetProgramBinary.nglGetProgramBinaryOES(program, binary.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static void nglProgramBinaryOES(int program, int binaryFormat, long binary, int length) {
        long __functionAddress = GLES.getCapabilities().glProgramBinaryOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, binaryFormat, binary, length);
    }

    public static void glProgramBinaryOES(int program, int binaryFormat, ByteBuffer binary) {
        OESGetProgramBinary.nglProgramBinaryOES(program, binaryFormat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void glGetProgramBinaryOES(int program, int[] length, int[] binaryFormat, ByteBuffer binary) {
        long __functionAddress = GLES.getCapabilities().glGetProgramBinaryOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
            Checks.checkBuffer(binaryFormat, 1);
        }
        JNI.callPPPV(__functionAddress, program, binary.remaining(), length, binaryFormat, MemoryUtil.memAddress(binary));
    }
}

