/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRTrackerPose
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRACKERFLAGS;
    public static final int POSE;
    public static final int LEVELEDPOSE;

    OVRTrackerPose(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRTrackerPose(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRTrackerPose.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int TrackerFlags() {
        return OVRTrackerPose.nTrackerFlags(this.address());
    }

    public OVRPosef Pose() {
        return OVRTrackerPose.nPose(this.address());
    }

    public OVRPosef LeveledPose() {
        return OVRTrackerPose.nLeveledPose(this.address());
    }

    public OVRTrackerPose TrackerFlags(int value) {
        OVRTrackerPose.nTrackerFlags(this.address(), value);
        return this;
    }

    public OVRTrackerPose Pose(OVRPosef value) {
        OVRTrackerPose.nPose(this.address(), value);
        return this;
    }

    public OVRTrackerPose LeveledPose(OVRPosef value) {
        OVRTrackerPose.nLeveledPose(this.address(), value);
        return this;
    }

    public OVRTrackerPose set(int TrackerFlags, OVRPosef Pose, OVRPosef LeveledPose) {
        this.TrackerFlags(TrackerFlags);
        this.Pose(Pose);
        this.LeveledPose(LeveledPose);
        return this;
    }

    public OVRTrackerPose nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRTrackerPose set(OVRTrackerPose src) {
        return this.nset(src.address());
    }

    public static OVRTrackerPose malloc() {
        return OVRTrackerPose.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRTrackerPose calloc() {
        return OVRTrackerPose.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRTrackerPose create() {
        return new OVRTrackerPose(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRTrackerPose create(long address) {
        return address == 0L ? null : new OVRTrackerPose(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRTrackerPose.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRTrackerPose.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRTrackerPose mallocStack() {
        return OVRTrackerPose.mallocStack(MemoryStack.stackGet());
    }

    public static OVRTrackerPose callocStack() {
        return OVRTrackerPose.callocStack(MemoryStack.stackGet());
    }

    public static OVRTrackerPose mallocStack(MemoryStack stack) {
        return OVRTrackerPose.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRTrackerPose callocStack(MemoryStack stack) {
        return OVRTrackerPose.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRTrackerPose.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRTrackerPose.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTrackerPose.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTrackerPose.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nTrackerFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TRACKERFLAGS);
    }

    public static OVRPosef nPose(long struct) {
        return OVRPosef.create(struct + (long)POSE);
    }

    public static OVRPosef nLeveledPose(long struct) {
        return OVRPosef.create(struct + (long)LEVELEDPOSE);
    }

    public static void nTrackerFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TRACKERFLAGS, value);
    }

    public static void nPose(long struct, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, OVRPosef.SIZEOF);
    }

    public static void nLeveledPose(long struct, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LEVELEDPOSE, OVRPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRTrackerPose.__struct(OVRTrackerPose.__member(4), OVRTrackerPose.__member(OVRPosef.SIZEOF, OVRPosef.ALIGNOF), OVRTrackerPose.__member(OVRPosef.SIZEOF, OVRPosef.ALIGNOF), OVRTrackerPose.__padding(4, true));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRACKERFLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
        LEVELEDPOSE = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<OVRTrackerPose, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRTrackerPose newInstance(long address) {
            return new OVRTrackerPose(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int TrackerFlags() {
            return OVRTrackerPose.nTrackerFlags(this.address());
        }

        public OVRPosef Pose() {
            return OVRTrackerPose.nPose(this.address());
        }

        public OVRPosef LeveledPose() {
            return OVRTrackerPose.nLeveledPose(this.address());
        }

        public Buffer TrackerFlags(int value) {
            OVRTrackerPose.nTrackerFlags(this.address(), value);
            return this;
        }

        public Buffer Pose(OVRPosef value) {
            OVRTrackerPose.nPose(this.address(), value);
            return this;
        }

        public Buffer LeveledPose(OVRPosef value) {
            OVRTrackerPose.nLeveledPose(this.address(), value);
            return this;
        }
    }
}

