/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRVector2f
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    OVRVector2f(long address, ByteBuffer container) {
        super(address, container);
    }

    public OVRVector2f(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), OVRVector2f.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return OVRVector2f.nx(this.address());
    }

    public float y() {
        return OVRVector2f.ny(this.address());
    }

    public OVRVector2f x(float value) {
        OVRVector2f.nx(this.address(), value);
        return this;
    }

    public OVRVector2f y(float value) {
        OVRVector2f.ny(this.address(), value);
        return this;
    }

    public OVRVector2f set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public OVRVector2f nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRVector2f set(OVRVector2f src) {
        return this.nset(src.address());
    }

    public static OVRVector2f malloc() {
        return OVRVector2f.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRVector2f calloc() {
        return OVRVector2f.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRVector2f create() {
        return new OVRVector2f(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static OVRVector2f create(long address) {
        return address == 0L ? null : new OVRVector2f(address, null);
    }

    public static Buffer malloc(int capacity) {
        return OVRVector2f.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OVRVector2f.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static OVRVector2f mallocStack() {
        return OVRVector2f.mallocStack(MemoryStack.stackGet());
    }

    public static OVRVector2f callocStack() {
        return OVRVector2f.callocStack(MemoryStack.stackGet());
    }

    public static OVRVector2f mallocStack(MemoryStack stack) {
        return OVRVector2f.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRVector2f callocStack(MemoryStack stack) {
        return OVRVector2f.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRVector2f.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRVector2f.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRVector2f.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRVector2f.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = OVRVector2f.__struct(OVRVector2f.__member(4), OVRVector2f.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRVector2f, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected OVRVector2f newInstance(long address) {
            return new OVRVector2f(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return OVRVector2f.nx(this.address());
        }

        public float y() {
            return OVRVector2f.ny(this.address());
        }

        public Buffer x(float value) {
            OVRVector2f.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            OVRVector2f.ny(this.address(), value);
            return this;
        }
    }
}

