/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAttachmentDescription
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int FORMAT;
    public static final int SAMPLES;
    public static final int LOADOP;
    public static final int STOREOP;
    public static final int STENCILLOADOP;
    public static final int STENCILSTOREOP;
    public static final int INITIALLAYOUT;
    public static final int FINALLAYOUT;

    VkAttachmentDescription(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkAttachmentDescription(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkAttachmentDescription.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int flags() {
        return VkAttachmentDescription.nflags(this.address());
    }

    public int format() {
        return VkAttachmentDescription.nformat(this.address());
    }

    public int samples() {
        return VkAttachmentDescription.nsamples(this.address());
    }

    public int loadOp() {
        return VkAttachmentDescription.nloadOp(this.address());
    }

    public int storeOp() {
        return VkAttachmentDescription.nstoreOp(this.address());
    }

    public int stencilLoadOp() {
        return VkAttachmentDescription.nstencilLoadOp(this.address());
    }

    public int stencilStoreOp() {
        return VkAttachmentDescription.nstencilStoreOp(this.address());
    }

    public int initialLayout() {
        return VkAttachmentDescription.ninitialLayout(this.address());
    }

    public int finalLayout() {
        return VkAttachmentDescription.nfinalLayout(this.address());
    }

    public VkAttachmentDescription flags(int value) {
        VkAttachmentDescription.nflags(this.address(), value);
        return this;
    }

    public VkAttachmentDescription format(int value) {
        VkAttachmentDescription.nformat(this.address(), value);
        return this;
    }

    public VkAttachmentDescription samples(int value) {
        VkAttachmentDescription.nsamples(this.address(), value);
        return this;
    }

    public VkAttachmentDescription loadOp(int value) {
        VkAttachmentDescription.nloadOp(this.address(), value);
        return this;
    }

    public VkAttachmentDescription storeOp(int value) {
        VkAttachmentDescription.nstoreOp(this.address(), value);
        return this;
    }

    public VkAttachmentDescription stencilLoadOp(int value) {
        VkAttachmentDescription.nstencilLoadOp(this.address(), value);
        return this;
    }

    public VkAttachmentDescription stencilStoreOp(int value) {
        VkAttachmentDescription.nstencilStoreOp(this.address(), value);
        return this;
    }

    public VkAttachmentDescription initialLayout(int value) {
        VkAttachmentDescription.ninitialLayout(this.address(), value);
        return this;
    }

    public VkAttachmentDescription finalLayout(int value) {
        VkAttachmentDescription.nfinalLayout(this.address(), value);
        return this;
    }

    public VkAttachmentDescription set(int flags, int format, int samples, int loadOp, int storeOp, int stencilLoadOp, int stencilStoreOp, int initialLayout, int finalLayout) {
        this.flags(flags);
        this.format(format);
        this.samples(samples);
        this.loadOp(loadOp);
        this.storeOp(storeOp);
        this.stencilLoadOp(stencilLoadOp);
        this.stencilStoreOp(stencilStoreOp);
        this.initialLayout(initialLayout);
        this.finalLayout(finalLayout);
        return this;
    }

    public VkAttachmentDescription nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkAttachmentDescription set(VkAttachmentDescription src) {
        return this.nset(src.address());
    }

    public static VkAttachmentDescription malloc() {
        return VkAttachmentDescription.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkAttachmentDescription calloc() {
        return VkAttachmentDescription.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkAttachmentDescription create() {
        return new VkAttachmentDescription(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkAttachmentDescription create(long address) {
        return address == 0L ? null : new VkAttachmentDescription(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkAttachmentDescription.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAttachmentDescription.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkAttachmentDescription mallocStack() {
        return VkAttachmentDescription.mallocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentDescription callocStack() {
        return VkAttachmentDescription.callocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentDescription mallocStack(MemoryStack stack) {
        return VkAttachmentDescription.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAttachmentDescription callocStack(MemoryStack stack) {
        return VkAttachmentDescription.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAttachmentDescription.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAttachmentDescription.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAttachmentDescription.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAttachmentDescription.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static int nsamples(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SAMPLES);
    }

    public static int nloadOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOADOP);
    }

    public static int nstoreOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STOREOP);
    }

    public static int nstencilLoadOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STENCILLOADOP);
    }

    public static int nstencilStoreOp(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STENCILSTOREOP);
    }

    public static int ninitialLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INITIALLAYOUT);
    }

    public static int nfinalLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FINALLAYOUT);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void nsamples(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SAMPLES, value);
    }

    public static void nloadOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOADOP, value);
    }

    public static void nstoreOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STOREOP, value);
    }

    public static void nstencilLoadOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STENCILLOADOP, value);
    }

    public static void nstencilStoreOp(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STENCILSTOREOP, value);
    }

    public static void ninitialLayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INITIALLAYOUT, value);
    }

    public static void nfinalLayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FINALLAYOUT, value);
    }

    static {
        Struct.Layout layout = VkAttachmentDescription.__struct(VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4), VkAttachmentDescription.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        FORMAT = layout.offsetof(1);
        SAMPLES = layout.offsetof(2);
        LOADOP = layout.offsetof(3);
        STOREOP = layout.offsetof(4);
        STENCILLOADOP = layout.offsetof(5);
        STENCILSTOREOP = layout.offsetof(6);
        INITIALLAYOUT = layout.offsetof(7);
        FINALLAYOUT = layout.offsetof(8);
    }

    public static final class Buffer
    extends StructBuffer<VkAttachmentDescription, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkAttachmentDescription newInstance(long address) {
            return new VkAttachmentDescription(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int flags() {
            return VkAttachmentDescription.nflags(this.address());
        }

        public int format() {
            return VkAttachmentDescription.nformat(this.address());
        }

        public int samples() {
            return VkAttachmentDescription.nsamples(this.address());
        }

        public int loadOp() {
            return VkAttachmentDescription.nloadOp(this.address());
        }

        public int storeOp() {
            return VkAttachmentDescription.nstoreOp(this.address());
        }

        public int stencilLoadOp() {
            return VkAttachmentDescription.nstencilLoadOp(this.address());
        }

        public int stencilStoreOp() {
            return VkAttachmentDescription.nstencilStoreOp(this.address());
        }

        public int initialLayout() {
            return VkAttachmentDescription.ninitialLayout(this.address());
        }

        public int finalLayout() {
            return VkAttachmentDescription.nfinalLayout(this.address());
        }

        public Buffer flags(int value) {
            VkAttachmentDescription.nflags(this.address(), value);
            return this;
        }

        public Buffer format(int value) {
            VkAttachmentDescription.nformat(this.address(), value);
            return this;
        }

        public Buffer samples(int value) {
            VkAttachmentDescription.nsamples(this.address(), value);
            return this;
        }

        public Buffer loadOp(int value) {
            VkAttachmentDescription.nloadOp(this.address(), value);
            return this;
        }

        public Buffer storeOp(int value) {
            VkAttachmentDescription.nstoreOp(this.address(), value);
            return this;
        }

        public Buffer stencilLoadOp(int value) {
            VkAttachmentDescription.nstencilLoadOp(this.address(), value);
            return this;
        }

        public Buffer stencilStoreOp(int value) {
            VkAttachmentDescription.nstencilStoreOp(this.address(), value);
            return this;
        }

        public Buffer initialLayout(int value) {
            VkAttachmentDescription.ninitialLayout(this.address(), value);
            return this;
        }

        public Buffer finalLayout(int value) {
            VkAttachmentDescription.nfinalLayout(this.address(), value);
            return this;
        }
    }
}

