/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCopyDescriptorSet
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCSET;
    public static final int SRCBINDING;
    public static final int SRCARRAYELEMENT;
    public static final int DSTSET;
    public static final int DSTBINDING;
    public static final int DSTARRAYELEMENT;
    public static final int DESCRIPTORCOUNT;

    VkCopyDescriptorSet(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkCopyDescriptorSet(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkCopyDescriptorSet.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkCopyDescriptorSet.nsType(this.address());
    }

    public long pNext() {
        return VkCopyDescriptorSet.npNext(this.address());
    }

    public long srcSet() {
        return VkCopyDescriptorSet.nsrcSet(this.address());
    }

    public int srcBinding() {
        return VkCopyDescriptorSet.nsrcBinding(this.address());
    }

    public int srcArrayElement() {
        return VkCopyDescriptorSet.nsrcArrayElement(this.address());
    }

    public long dstSet() {
        return VkCopyDescriptorSet.ndstSet(this.address());
    }

    public int dstBinding() {
        return VkCopyDescriptorSet.ndstBinding(this.address());
    }

    public int dstArrayElement() {
        return VkCopyDescriptorSet.ndstArrayElement(this.address());
    }

    public int descriptorCount() {
        return VkCopyDescriptorSet.ndescriptorCount(this.address());
    }

    public VkCopyDescriptorSet sType(int value) {
        VkCopyDescriptorSet.nsType(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet pNext(long value) {
        VkCopyDescriptorSet.npNext(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet srcSet(long value) {
        VkCopyDescriptorSet.nsrcSet(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet srcBinding(int value) {
        VkCopyDescriptorSet.nsrcBinding(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet srcArrayElement(int value) {
        VkCopyDescriptorSet.nsrcArrayElement(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet dstSet(long value) {
        VkCopyDescriptorSet.ndstSet(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet dstBinding(int value) {
        VkCopyDescriptorSet.ndstBinding(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet dstArrayElement(int value) {
        VkCopyDescriptorSet.ndstArrayElement(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet descriptorCount(int value) {
        VkCopyDescriptorSet.ndescriptorCount(this.address(), value);
        return this;
    }

    public VkCopyDescriptorSet set(int sType, long pNext, long srcSet, int srcBinding, int srcArrayElement, long dstSet, int dstBinding, int dstArrayElement, int descriptorCount) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcSet(srcSet);
        this.srcBinding(srcBinding);
        this.srcArrayElement(srcArrayElement);
        this.dstSet(dstSet);
        this.dstBinding(dstBinding);
        this.dstArrayElement(dstArrayElement);
        this.descriptorCount(descriptorCount);
        return this;
    }

    public VkCopyDescriptorSet nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkCopyDescriptorSet set(VkCopyDescriptorSet src) {
        return this.nset(src.address());
    }

    public static VkCopyDescriptorSet malloc() {
        return VkCopyDescriptorSet.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkCopyDescriptorSet calloc() {
        return VkCopyDescriptorSet.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkCopyDescriptorSet create() {
        return new VkCopyDescriptorSet(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkCopyDescriptorSet create(long address) {
        return address == 0L ? null : new VkCopyDescriptorSet(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkCopyDescriptorSet.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkCopyDescriptorSet.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkCopyDescriptorSet mallocStack() {
        return VkCopyDescriptorSet.mallocStack(MemoryStack.stackGet());
    }

    public static VkCopyDescriptorSet callocStack() {
        return VkCopyDescriptorSet.callocStack(MemoryStack.stackGet());
    }

    public static VkCopyDescriptorSet mallocStack(MemoryStack stack) {
        return VkCopyDescriptorSet.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCopyDescriptorSet callocStack(MemoryStack stack) {
        return VkCopyDescriptorSet.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkCopyDescriptorSet.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkCopyDescriptorSet.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkCopyDescriptorSet.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkCopyDescriptorSet.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nsrcSet(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SRCSET);
    }

    public static int nsrcBinding(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCBINDING);
    }

    public static int nsrcArrayElement(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SRCARRAYELEMENT);
    }

    public static long ndstSet(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DSTSET);
    }

    public static int ndstBinding(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTBINDING);
    }

    public static int ndstArrayElement(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTARRAYELEMENT);
    }

    public static int ndescriptorCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORCOUNT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrcSet(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SRCSET, value);
    }

    public static void nsrcBinding(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCBINDING, value);
    }

    public static void nsrcArrayElement(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SRCARRAYELEMENT, value);
    }

    public static void ndstSet(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DSTSET, value);
    }

    public static void ndstBinding(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTBINDING, value);
    }

    public static void ndstArrayElement(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTARRAYELEMENT, value);
    }

    public static void ndescriptorCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORCOUNT, value);
    }

    static {
        Struct.Layout layout = VkCopyDescriptorSet.__struct(VkCopyDescriptorSet.__member(4), VkCopyDescriptorSet.__member(POINTER_SIZE), VkCopyDescriptorSet.__member(8), VkCopyDescriptorSet.__member(4), VkCopyDescriptorSet.__member(4), VkCopyDescriptorSet.__member(8), VkCopyDescriptorSet.__member(4), VkCopyDescriptorSet.__member(4), VkCopyDescriptorSet.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCSET = layout.offsetof(2);
        SRCBINDING = layout.offsetof(3);
        SRCARRAYELEMENT = layout.offsetof(4);
        DSTSET = layout.offsetof(5);
        DSTBINDING = layout.offsetof(6);
        DSTARRAYELEMENT = layout.offsetof(7);
        DESCRIPTORCOUNT = layout.offsetof(8);
    }

    public static final class Buffer
    extends StructBuffer<VkCopyDescriptorSet, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkCopyDescriptorSet newInstance(long address) {
            return new VkCopyDescriptorSet(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkCopyDescriptorSet.nsType(this.address());
        }

        public long pNext() {
            return VkCopyDescriptorSet.npNext(this.address());
        }

        public long srcSet() {
            return VkCopyDescriptorSet.nsrcSet(this.address());
        }

        public int srcBinding() {
            return VkCopyDescriptorSet.nsrcBinding(this.address());
        }

        public int srcArrayElement() {
            return VkCopyDescriptorSet.nsrcArrayElement(this.address());
        }

        public long dstSet() {
            return VkCopyDescriptorSet.ndstSet(this.address());
        }

        public int dstBinding() {
            return VkCopyDescriptorSet.ndstBinding(this.address());
        }

        public int dstArrayElement() {
            return VkCopyDescriptorSet.ndstArrayElement(this.address());
        }

        public int descriptorCount() {
            return VkCopyDescriptorSet.ndescriptorCount(this.address());
        }

        public Buffer sType(int value) {
            VkCopyDescriptorSet.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkCopyDescriptorSet.npNext(this.address(), value);
            return this;
        }

        public Buffer srcSet(long value) {
            VkCopyDescriptorSet.nsrcSet(this.address(), value);
            return this;
        }

        public Buffer srcBinding(int value) {
            VkCopyDescriptorSet.nsrcBinding(this.address(), value);
            return this;
        }

        public Buffer srcArrayElement(int value) {
            VkCopyDescriptorSet.nsrcArrayElement(this.address(), value);
            return this;
        }

        public Buffer dstSet(long value) {
            VkCopyDescriptorSet.ndstSet(this.address(), value);
            return this;
        }

        public Buffer dstBinding(int value) {
            VkCopyDescriptorSet.ndstBinding(this.address(), value);
            return this;
        }

        public Buffer dstArrayElement(int value) {
            VkCopyDescriptorSet.ndstArrayElement(this.address(), value);
            return this;
        }

        public Buffer descriptorCount(int value) {
            VkCopyDescriptorSet.ndescriptorCount(this.address(), value);
            return this;
        }
    }
}

