/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRect2D;

public class VkDisplayPresentInfoKHR
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCRECT;
    public static final int DSTRECT;
    public static final int PERSISTENT;

    VkDisplayPresentInfoKHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDisplayPresentInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDisplayPresentInfoKHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkDisplayPresentInfoKHR.nsType(this.address());
    }

    public long pNext() {
        return VkDisplayPresentInfoKHR.npNext(this.address());
    }

    public VkRect2D srcRect() {
        return VkDisplayPresentInfoKHR.nsrcRect(this.address());
    }

    public VkRect2D dstRect() {
        return VkDisplayPresentInfoKHR.ndstRect(this.address());
    }

    public int persistent() {
        return VkDisplayPresentInfoKHR.npersistent(this.address());
    }

    public VkDisplayPresentInfoKHR sType(int value) {
        VkDisplayPresentInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR pNext(long value) {
        VkDisplayPresentInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR srcRect(VkRect2D value) {
        VkDisplayPresentInfoKHR.nsrcRect(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR dstRect(VkRect2D value) {
        VkDisplayPresentInfoKHR.ndstRect(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR persistent(int value) {
        VkDisplayPresentInfoKHR.npersistent(this.address(), value);
        return this;
    }

    public VkDisplayPresentInfoKHR set(int sType, long pNext, VkRect2D srcRect, VkRect2D dstRect, int persistent) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcRect(srcRect);
        this.dstRect(dstRect);
        this.persistent(persistent);
        return this;
    }

    public VkDisplayPresentInfoKHR nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkDisplayPresentInfoKHR set(VkDisplayPresentInfoKHR src) {
        return this.nset(src.address());
    }

    public static VkDisplayPresentInfoKHR malloc() {
        return VkDisplayPresentInfoKHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDisplayPresentInfoKHR calloc() {
        return VkDisplayPresentInfoKHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDisplayPresentInfoKHR create() {
        return new VkDisplayPresentInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDisplayPresentInfoKHR create(long address) {
        return address == 0L ? null : new VkDisplayPresentInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDisplayPresentInfoKHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDisplayPresentInfoKHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDisplayPresentInfoKHR mallocStack() {
        return VkDisplayPresentInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDisplayPresentInfoKHR callocStack() {
        return VkDisplayPresentInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDisplayPresentInfoKHR mallocStack(MemoryStack stack) {
        return VkDisplayPresentInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayPresentInfoKHR callocStack(MemoryStack stack) {
        return VkDisplayPresentInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDisplayPresentInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDisplayPresentInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayPresentInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayPresentInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkRect2D nsrcRect(long struct) {
        return VkRect2D.create(struct + (long)SRCRECT);
    }

    public static VkRect2D ndstRect(long struct) {
        return VkRect2D.create(struct + (long)DSTRECT);
    }

    public static int npersistent(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PERSISTENT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrcRect(long struct, VkRect2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCRECT, VkRect2D.SIZEOF);
    }

    public static void ndstRect(long struct, VkRect2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTRECT, VkRect2D.SIZEOF);
    }

    public static void npersistent(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PERSISTENT, value);
    }

    static {
        Struct.Layout layout = VkDisplayPresentInfoKHR.__struct(VkDisplayPresentInfoKHR.__member(4), VkDisplayPresentInfoKHR.__member(POINTER_SIZE), VkDisplayPresentInfoKHR.__member(VkRect2D.SIZEOF, VkRect2D.ALIGNOF), VkDisplayPresentInfoKHR.__member(VkRect2D.SIZEOF, VkRect2D.ALIGNOF), VkDisplayPresentInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCRECT = layout.offsetof(2);
        DSTRECT = layout.offsetof(3);
        PERSISTENT = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<VkDisplayPresentInfoKHR, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDisplayPresentInfoKHR newInstance(long address) {
            return new VkDisplayPresentInfoKHR(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkDisplayPresentInfoKHR.nsType(this.address());
        }

        public long pNext() {
            return VkDisplayPresentInfoKHR.npNext(this.address());
        }

        public VkRect2D srcRect() {
            return VkDisplayPresentInfoKHR.nsrcRect(this.address());
        }

        public VkRect2D dstRect() {
            return VkDisplayPresentInfoKHR.ndstRect(this.address());
        }

        public int persistent() {
            return VkDisplayPresentInfoKHR.npersistent(this.address());
        }

        public Buffer sType(int value) {
            VkDisplayPresentInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkDisplayPresentInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer srcRect(VkRect2D value) {
            VkDisplayPresentInfoKHR.nsrcRect(this.address(), value);
            return this;
        }

        public Buffer dstRect(VkRect2D value) {
            VkDisplayPresentInfoKHR.ndstRect(this.address(), value);
            return this;
        }

        public Buffer persistent(int value) {
            VkDisplayPresentInfoKHR.npersistent(this.address(), value);
            return this;
        }
    }
}

