/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryHeap
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int FLAGS;

    VkMemoryHeap(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkMemoryHeap(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkMemoryHeap.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long size() {
        return VkMemoryHeap.nsize(this.address());
    }

    public int flags() {
        return VkMemoryHeap.nflags(this.address());
    }

    public static VkMemoryHeap malloc() {
        return VkMemoryHeap.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkMemoryHeap calloc() {
        return VkMemoryHeap.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkMemoryHeap create() {
        return new VkMemoryHeap(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkMemoryHeap create(long address) {
        return address == 0L ? null : new VkMemoryHeap(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryHeap.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryHeap.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkMemoryHeap mallocStack() {
        return VkMemoryHeap.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryHeap callocStack() {
        return VkMemoryHeap.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryHeap mallocStack(MemoryStack stack) {
        return VkMemoryHeap.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryHeap callocStack(MemoryStack stack) {
        return VkMemoryHeap.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryHeap.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryHeap.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryHeap.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryHeap.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    static {
        Struct.Layout layout = VkMemoryHeap.__struct(VkMemoryHeap.__member(8), VkMemoryHeap.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<VkMemoryHeap, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkMemoryHeap newInstance(long address) {
            return new VkMemoryHeap(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long size() {
            return VkMemoryHeap.nsize(this.address());
        }

        public int flags() {
            return VkMemoryHeap.nflags(this.address());
        }
    }
}

