/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseMemoryBind;

public class VkSparseBufferMemoryBindInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int BINDCOUNT;
    public static final int PBINDS;

    VkSparseBufferMemoryBindInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSparseBufferMemoryBindInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSparseBufferMemoryBindInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long buffer() {
        return VkSparseBufferMemoryBindInfo.nbuffer(this.address());
    }

    public int bindCount() {
        return VkSparseBufferMemoryBindInfo.nbindCount(this.address());
    }

    public VkSparseMemoryBind.Buffer pBinds() {
        return VkSparseBufferMemoryBindInfo.npBinds(this.address());
    }

    public VkSparseBufferMemoryBindInfo buffer(long value) {
        VkSparseBufferMemoryBindInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkSparseBufferMemoryBindInfo pBinds(VkSparseMemoryBind.Buffer value) {
        VkSparseBufferMemoryBindInfo.npBinds(this.address(), value);
        return this;
    }

    public VkSparseBufferMemoryBindInfo set(long buffer, VkSparseMemoryBind.Buffer pBinds) {
        this.buffer(buffer);
        this.pBinds(pBinds);
        return this;
    }

    public VkSparseBufferMemoryBindInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkSparseBufferMemoryBindInfo set(VkSparseBufferMemoryBindInfo src) {
        return this.nset(src.address());
    }

    public static VkSparseBufferMemoryBindInfo malloc() {
        return VkSparseBufferMemoryBindInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSparseBufferMemoryBindInfo calloc() {
        return VkSparseBufferMemoryBindInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSparseBufferMemoryBindInfo create() {
        return new VkSparseBufferMemoryBindInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSparseBufferMemoryBindInfo create(long address) {
        return address == 0L ? null : new VkSparseBufferMemoryBindInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSparseBufferMemoryBindInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSparseBufferMemoryBindInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSparseBufferMemoryBindInfo mallocStack() {
        return VkSparseBufferMemoryBindInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkSparseBufferMemoryBindInfo callocStack() {
        return VkSparseBufferMemoryBindInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkSparseBufferMemoryBindInfo mallocStack(MemoryStack stack) {
        return VkSparseBufferMemoryBindInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseBufferMemoryBindInfo callocStack(MemoryStack stack) {
        return VkSparseBufferMemoryBindInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSparseBufferMemoryBindInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSparseBufferMemoryBindInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseBufferMemoryBindInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseBufferMemoryBindInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static int nbindCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDCOUNT);
    }

    public static VkSparseMemoryBind.Buffer npBinds(long struct) {
        return VkSparseMemoryBind.create(MemoryUtil.memGetAddress(struct + (long)PBINDS), VkSparseBufferMemoryBindInfo.nbindCount(struct));
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void nbindCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDCOUNT, value);
    }

    public static void npBinds(long struct, VkSparseMemoryBind.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBINDS, value.address());
        VkSparseBufferMemoryBindInfo.nbindCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PBINDS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSparseBufferMemoryBindInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkSparseBufferMemoryBindInfo.__struct(VkSparseBufferMemoryBindInfo.__member(8), VkSparseBufferMemoryBindInfo.__member(4), VkSparseBufferMemoryBindInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        BINDCOUNT = layout.offsetof(1);
        PBINDS = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<VkSparseBufferMemoryBindInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSparseBufferMemoryBindInfo newInstance(long address) {
            return new VkSparseBufferMemoryBindInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long buffer() {
            return VkSparseBufferMemoryBindInfo.nbuffer(this.address());
        }

        public int bindCount() {
            return VkSparseBufferMemoryBindInfo.nbindCount(this.address());
        }

        public VkSparseMemoryBind.Buffer pBinds() {
            return VkSparseBufferMemoryBindInfo.npBinds(this.address());
        }

        public Buffer buffer(long value) {
            VkSparseBufferMemoryBindInfo.nbuffer(this.address(), value);
            return this;
        }

        public Buffer pBinds(VkSparseMemoryBind.Buffer value) {
            VkSparseBufferMemoryBindInfo.npBinds(this.address(), value);
            return this;
        }
    }
}

