/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class ANGLEQuerySurfacePointer {
    public final long QuerySurfacePointerANGLE;

    protected ANGLEQuerySurfacePointer() {
        throw new UnsupportedOperationException();
    }

    public ANGLEQuerySurfacePointer(FunctionProvider provider) {
        this.QuerySurfacePointerANGLE = provider.getFunctionAddress("eglQuerySurfacePointerANGLE");
    }

    public static ANGLEQuerySurfacePointer getInstance() {
        return ANGLEQuerySurfacePointer.getInstance(EGL.getCapabilities());
    }

    public static ANGLEQuerySurfacePointer getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ANGLEQuerySurfacePointer);
    }

    public static boolean neglQuerySurfacePointerANGLE(long dpy, long surface, int attribute, long value) {
        long __functionAddress = ANGLEQuerySurfacePointer.getInstance().QuerySurfacePointerANGLE;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, surface, attribute, value);
    }

    public static boolean eglQuerySurfacePointerANGLE(long dpy, long surface, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1 << Pointer.POINTER_SHIFT);
        }
        return ANGLEQuerySurfacePointer.neglQuerySurfacePointerANGLE(dpy, surface, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglQuerySurfacePointerANGLE(long dpy, long surface, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return ANGLEQuerySurfacePointer.neglQuerySurfacePointerANGLE(dpy, surface, attribute, MemoryUtil.memAddress(value));
    }
}

