/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.lwjgl.egl.EGL10;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public final class EGL {
    private static FunctionProvider functionProvider;
    private static EGLCapabilities caps;

    private EGL() {
    }

    public static void create() {
        SharedLibrary EGL2;
        switch (Platform.get()) {
            case LINUX: {
                EGL2 = Library.loadNative(Configuration.LIBRARY_NAME_EGL, "libEGL.so.1");
                break;
            }
            case MACOSX: {
                EGL2 = Library.loadNative(Configuration.LIBRARY_NAME_EGL, "EGL");
                break;
            }
            case WINDOWS: {
                EGL2 = Library.loadNative(Configuration.LIBRARY_NAME_EGL, "libEGL", "EGL");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        EGL.create(EGL2);
    }

    public static void create(String libName) {
        EGL.create(Library.loadNative(libName));
    }

    private static void create(final SharedLibrary EGL2) {
        try {
            FunctionProvider.Default functionProvider = new FunctionProvider.Default(){
                private final long eglGetProcAddress;
                {
                    this.eglGetProcAddress = EGL2.getFunctionAddress("eglGetProcAddress");
                }

                @Override
                public long getFunctionAddress(CharSequence functionName) {
                    APIBuffer __buffer = APIUtil.apiBuffer();
                    __buffer.stringParamASCII(functionName, true);
                    long address = JNI.invokePP(this.eglGetProcAddress, __buffer.address());
                    if (address == 0L) {
                        address = EGL2.getFunctionAddress(functionName);
                    }
                    return address;
                }

                @Override
                protected void destroy() {
                    EGL2.release();
                }
            };
            EGL.create(functionProvider);
        }
        catch (RuntimeException e) {
            EGL2.release();
            throw e;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (EGL.functionProvider != null) {
            throw new IllegalStateException("EGL has already been created.");
        }
        EGL.functionProvider = functionProvider;
        caps = EGL.createClientCapabilities();
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        caps = null;
        functionProvider.release();
        functionProvider = null;
    }

    public static FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    public static EGLCapabilities getCapabilities() {
        return caps;
    }

    private static EGLCapabilities createClientCapabilities() {
        APIUtil.APIVersion version;
        long QueryString = functionProvider.getFunctionAddress("eglQueryString");
        long versionString = JNI.invokePIP(QueryString, 0L, 12372);
        HashSet<String> ext = new HashSet<String>(32);
        if (versionString == 0L) {
            version = new APIUtil.APIVersion(0, 0, null, null);
            long GetError = functionProvider.getFunctionAddress("eglGetError");
            JNI.invokeI(GetError);
        } else {
            version = APIUtil.apiParseVersion(MemoryUtil.memDecodeASCII(versionString), "EGL");
            EGL.addExtensions(MemoryUtil.memDecodeASCII(JNI.invokePIP(QueryString, 0L, 12373)), ext);
        }
        return new EGLCapabilities(version.major, version.minor, ext, functionProvider);
    }

    public static EGLCapabilities createDisplayCapabilities(long dpy, int majorVersion, int minorVersion) {
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        EGL.addEGLVersions(majorVersion, minorVersion, supportedExtensions);
        EGL.addExtensions(EGL10.eglQueryString(dpy, 12373), supportedExtensions);
        return new EGLCapabilities(majorVersion, minorVersion, supportedExtensions, functionProvider);
    }

    private static void addEGLVersions(int MAJOR, int MINOR, Set<String> supportedExtensions) {
        int[][] versions = new int[][]{{0, 1, 2, 3, 4, 5}};
        block0: for (int major = 1; major <= Math.min(MAJOR, versions.length); ++major) {
            for (int minor : versions[major - 1]) {
                if (major == MAJOR && MINOR < minor) continue block0;
                supportedExtensions.add(String.format("EGL%d%d%s", major, minor, ""));
            }
        }
    }

    private static void addExtensions(String extensionsString, Set<String> supportedExtensions) {
        StringTokenizer tokenizer = new StringTokenizer(extensionsString);
        while (tokenizer.hasMoreTokens()) {
            supportedExtensions.add(tokenizer.nextToken());
        }
    }

    static <T> T checkCapability(Set<String> ext, String capability, T functions) {
        if (!ext.contains(capability)) {
            return null;
        }
        boolean missingFunction = false;
        try {
            for (Field f : functions.getClass().getFields()) {
                if (Modifier.isStatic(f.getModifiers()) || f.getLong(functions) != 0L) continue;
                APIUtil.apiLog("Failed to locate address for EGL function egl" + f.getName());
                missingFunction = true;
                break;
            }
        }
        catch (IllegalAccessException e) {
            APIUtil.apiLog("[EGL] Failed to retrieve " + capability + " function pointer fields.");
            return null;
        }
        if (missingFunction) {
            APIUtil.apiLog("[EGL] " + capability + " was reported as available but an entry point is missing.");
            return null;
        }
        return functions;
    }

    static {
        if (!((Boolean)Configuration.EXPLICIT_INIT_EGL.get()).booleanValue()) {
            EGL.create();
        }
    }
}

