/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class EGLClientPixmapHI
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int PDATA;
    public static final int IWIDTH;
    public static final int IHEIGHT;
    public static final int ISTRIDE;

    EGLClientPixmapHI(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public EGLClientPixmapHI(long struct) {
        this(struct, null);
    }

    public EGLClientPixmapHI(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer pData(int capacity) {
        return EGLClientPixmapHI.npData(this.address(), capacity);
    }

    public int iWidth() {
        return EGLClientPixmapHI.niWidth(this.address());
    }

    public int iHeight() {
        return EGLClientPixmapHI.niHeight(this.address());
    }

    public int iStride() {
        return EGLClientPixmapHI.niStride(this.address());
    }

    public EGLClientPixmapHI pData(ByteBuffer value) {
        EGLClientPixmapHI.npData(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI iWidth(int value) {
        EGLClientPixmapHI.niWidth(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI iHeight(int value) {
        EGLClientPixmapHI.niHeight(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI iStride(int value) {
        EGLClientPixmapHI.niStride(this.address(), value);
        return this;
    }

    public EGLClientPixmapHI set(ByteBuffer pData, int iWidth, int iHeight, int iStride) {
        this.pData(pData);
        this.iWidth(iWidth);
        this.iHeight(iHeight);
        this.iStride(iStride);
        return this;
    }

    public EGLClientPixmapHI nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public EGLClientPixmapHI set(EGLClientPixmapHI src) {
        return this.nset(src.address());
    }

    public EGLClientPixmapHI set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static EGLClientPixmapHI malloc() {
        return new EGLClientPixmapHI(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static EGLClientPixmapHI calloc() {
        return new EGLClientPixmapHI(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static EGLClientPixmapHI create() {
        return new EGLClientPixmapHI(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static ByteBuffer npData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PDATA), capacity);
    }

    public static int niWidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IWIDTH);
    }

    public static int niHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IHEIGHT);
    }

    public static int niStride(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISTRIDE);
    }

    public static void npData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDATA, MemoryUtil.memAddressSafe(value));
    }

    public static void niWidth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IWIDTH, value);
    }

    public static void niHeight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IHEIGHT, value);
    }

    public static void niStride(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ISTRIDE, value);
    }

    static {
        Struct.Layout layout = EGLClientPixmapHI.__struct(EGLClientPixmapHI.__member(Pointer.POINTER_SIZE), EGLClientPixmapHI.__member(4), EGLClientPixmapHI.__member(4), EGLClientPixmapHI.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        PDATA = layout.offsetof(0);
        IWIDTH = layout.offsetof(1);
        IHEIGHT = layout.offsetof(2);
        ISTRIDE = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<EGLClientPixmapHI, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected EGLClientPixmapHI newInstance(long address) {
            return new EGLClientPixmapHI(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer pData(int capacity) {
            return EGLClientPixmapHI.npData(this.address(), capacity);
        }

        public int iWidth() {
            return EGLClientPixmapHI.niWidth(this.address());
        }

        public int iHeight() {
            return EGLClientPixmapHI.niHeight(this.address());
        }

        public int iStride() {
            return EGLClientPixmapHI.niStride(this.address());
        }

        public Buffer pData(ByteBuffer value) {
            EGLClientPixmapHI.npData(this.address(), value);
            return this;
        }

        public Buffer iWidth(int value) {
            EGLClientPixmapHI.niWidth(this.address(), value);
            return this;
        }

        public Buffer iHeight(int value) {
            EGLClientPixmapHI.niHeight(this.address(), value);
            return this;
        }

        public Buffer iStride(int value) {
            EGLClientPixmapHI.niStride(this.address(), value);
            return this;
        }
    }
}

