/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTPlatformBase {
    public final long GetPlatformDisplayEXT;
    public final long CreatePlatformWindowSurfaceEXT;
    public final long CreatePlatformPixmapSurfaceEXT;

    protected EXTPlatformBase() {
        throw new UnsupportedOperationException();
    }

    public EXTPlatformBase(FunctionProvider provider) {
        this.GetPlatformDisplayEXT = provider.getFunctionAddress("eglGetPlatformDisplayEXT");
        this.CreatePlatformWindowSurfaceEXT = provider.getFunctionAddress("eglCreatePlatformWindowSurfaceEXT");
        this.CreatePlatformPixmapSurfaceEXT = provider.getFunctionAddress("eglCreatePlatformPixmapSurfaceEXT");
    }

    public static EXTPlatformBase getInstance() {
        return EXTPlatformBase.getInstance(EGL.getCapabilities());
    }

    public static EXTPlatformBase getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTPlatformBase);
    }

    public static long neglGetPlatformDisplayEXT(int platform, long native_display, long attrib_list) {
        long __functionAddress = EXTPlatformBase.getInstance().GetPlatformDisplayEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(native_display);
        }
        return JNI.callIPPP(__functionAddress, platform, native_display, attrib_list);
    }

    public static long eglGetPlatformDisplayEXT(int platform, long native_display, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return EXTPlatformBase.neglGetPlatformDisplayEXT(platform, native_display, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglGetPlatformDisplayEXT(int platform, long native_display, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EXTPlatformBase.neglGetPlatformDisplayEXT(platform, native_display, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePlatformWindowSurfaceEXT(long dpy, long config, long native_window, long attrib_list) {
        long __functionAddress = EXTPlatformBase.getInstance().CreatePlatformWindowSurfaceEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(native_window);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, native_window, attrib_list);
    }

    public static long eglCreatePlatformWindowSurfaceEXT(long dpy, long config, long native_window, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return EXTPlatformBase.neglCreatePlatformWindowSurfaceEXT(dpy, config, native_window, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreatePlatformWindowSurfaceEXT(long dpy, long config, long native_window, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EXTPlatformBase.neglCreatePlatformWindowSurfaceEXT(dpy, config, native_window, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long neglCreatePlatformPixmapSurfaceEXT(long dpy, long config, long native_pixmap, long attrib_list) {
        long __functionAddress = EXTPlatformBase.getInstance().CreatePlatformPixmapSurfaceEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(config);
            Checks.checkPointer(native_pixmap);
        }
        return JNI.callPPPPP(__functionAddress, dpy, config, native_pixmap, attrib_list);
    }

    public static long eglCreatePlatformPixmapSurfaceEXT(long dpy, long config, long native_pixmap, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return EXTPlatformBase.neglCreatePlatformPixmapSurfaceEXT(dpy, config, native_pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreatePlatformPixmapSurfaceEXT(long dpy, long config, long native_pixmap, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EXTPlatformBase.neglCreatePlatformPixmapSurfaceEXT(dpy, config, native_pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }
}

