/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class KHRLockSurface3 {
    public static final int EGL_READ_SURFACE_BIT_KHR = 1;
    public static final int EGL_WRITE_SURFACE_BIT_KHR = 2;
    public static final int EGL_LOCK_SURFACE_BIT_KHR = 128;
    public static final int EGL_OPTIMAL_FORMAT_BIT_KHR = 256;
    public static final int EGL_MATCH_FORMAT_KHR = 12355;
    public static final int EGL_FORMAT_RGB_565_EXACT_KHR = 12480;
    public static final int EGL_FORMAT_RGB_565_KHR = 12481;
    public static final int EGL_FORMAT_RGBA_8888_EXACT_KHR = 12482;
    public static final int EGL_FORMAT_RGBA_8888_KHR = 12483;
    public static final int EGL_MAP_PRESERVE_PIXELS_KHR = 12484;
    public static final int EGL_LOCK_USAGE_HINT_KHR = 12485;
    public static final int EGL_BITMAP_PITCH_KHR = 12487;
    public static final int EGL_BITMAP_ORIGIN_KHR = 12488;
    public static final int EGL_BITMAP_PIXEL_RED_OFFSET_KHR = 12489;
    public static final int EGL_BITMAP_PIXEL_GREEN_OFFSET_KHR = 12490;
    public static final int EGL_BITMAP_PIXEL_BLUE_OFFSET_KHR = 12491;
    public static final int EGL_BITMAP_PIXEL_ALPHA_OFFSET_KHR = 12492;
    public static final int EGL_BITMAP_PIXEL_LUMINANCE_OFFSET_KHR = 12493;
    public static final int EGL_BITMAP_PIXEL_SIZE_KHR = 12560;
    public static final int EGL_BITMAP_POINTER_KHR = 12486;
    public static final int EGL_LOWER_LEFT_KHR = 12494;
    public static final int EGL_UPPER_LEFT_KHR = 12495;
    public final long LockSurfaceKHR;
    public final long UnlockSurfaceKHR;
    public final long QuerySurface64KHR;

    protected KHRLockSurface3() {
        throw new UnsupportedOperationException();
    }

    public KHRLockSurface3(FunctionProvider provider) {
        this.LockSurfaceKHR = provider.getFunctionAddress("eglLockSurfaceKHR");
        this.UnlockSurfaceKHR = provider.getFunctionAddress("eglUnlockSurfaceKHR");
        this.QuerySurface64KHR = provider.getFunctionAddress("eglQuerySurface64KHR");
    }

    public static KHRLockSurface3 getInstance() {
        return KHRLockSurface3.getInstance(EGL.getCapabilities());
    }

    public static KHRLockSurface3 getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRLockSurface3);
    }

    public static boolean neglLockSurfaceKHR(long dpy, long surface, long attrib_list) {
        long __functionAddress = KHRLockSurface3.getInstance().LockSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPPZ(__functionAddress, dpy, surface, attrib_list);
    }

    public static boolean eglLockSurfaceKHR(long dpy, long surface, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return KHRLockSurface3.neglLockSurfaceKHR(dpy, surface, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static boolean eglLockSurfaceKHR(long dpy, long surface, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return KHRLockSurface3.neglLockSurfaceKHR(dpy, surface, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static boolean eglUnlockSurfaceKHR(long dpy, long surface) {
        long __functionAddress = KHRLockSurface3.getInstance().UnlockSurfaceKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPZ(__functionAddress, dpy, surface);
    }

    public static boolean neglQuerySurface64KHR(long dpy, long surface, int attribute, long value) {
        long __functionAddress = KHRLockSurface3.getInstance().QuerySurface64KHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, surface, attribute, value);
    }

    public static boolean eglQuerySurface64KHR(long dpy, long surface, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1 << Pointer.POINTER_SHIFT);
        }
        return KHRLockSurface3.neglQuerySurface64KHR(dpy, surface, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglQuerySurface64KHR(long dpy, long surface, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return KHRLockSurface3.neglQuerySurface64KHR(dpy, surface, attribute, MemoryUtil.memAddress(value));
    }
}

