/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class KHRStreamConsumerGLTexture {
    public static final int EGL_CONSUMER_ACQUIRE_TIMEOUT_USEC_KHR = 12830;
    public final long StreamConsumerGLTextureExternalKHR;
    public final long StreamConsumerAcquireKHR;
    public final long StreamConsumerReleaseKHR;

    protected KHRStreamConsumerGLTexture() {
        throw new UnsupportedOperationException();
    }

    public KHRStreamConsumerGLTexture(FunctionProvider provider) {
        this.StreamConsumerGLTextureExternalKHR = provider.getFunctionAddress("eglStreamConsumerGLTextureExternalKHR");
        this.StreamConsumerAcquireKHR = provider.getFunctionAddress("eglStreamConsumerAcquireKHR");
        this.StreamConsumerReleaseKHR = provider.getFunctionAddress("eglStreamConsumerReleaseKHR");
    }

    public static KHRStreamConsumerGLTexture getInstance() {
        return KHRStreamConsumerGLTexture.getInstance(EGL.getCapabilities());
    }

    public static KHRStreamConsumerGLTexture getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRStreamConsumerGLTexture);
    }

    public static boolean eglStreamConsumerGLTextureExternalKHR(long dpy, long stream) {
        long __functionAddress = KHRStreamConsumerGLTexture.getInstance().StreamConsumerGLTextureExternalKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(stream);
        }
        return JNI.callPPZ(__functionAddress, dpy, stream);
    }

    public static boolean eglStreamConsumerAcquireKHR(long dpy, long stream) {
        long __functionAddress = KHRStreamConsumerGLTexture.getInstance().StreamConsumerAcquireKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(stream);
        }
        return JNI.callPPZ(__functionAddress, dpy, stream);
    }

    public static boolean eglStreamConsumerReleaseKHR(long dpy, long stream) {
        long __functionAddress = KHRStreamConsumerGLTexture.getInstance().StreamConsumerReleaseKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(stream);
        }
        return JNI.callPPZ(__functionAddress, dpy, stream);
    }
}

