/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class KHRStreamCrossProcessFD {
    public static final int EGL_NO_FILE_DESCRIPTOR_KHR = -1;
    public final long GetStreamFileDescriptorKHR;
    public final long CreateStreamFromFileDescriptorKHR;

    protected KHRStreamCrossProcessFD() {
        throw new UnsupportedOperationException();
    }

    public KHRStreamCrossProcessFD(FunctionProvider provider) {
        this.GetStreamFileDescriptorKHR = provider.getFunctionAddress("eglGetStreamFileDescriptorKHR");
        this.CreateStreamFromFileDescriptorKHR = provider.getFunctionAddress("eglCreateStreamFromFileDescriptorKHR");
    }

    public static KHRStreamCrossProcessFD getInstance() {
        return KHRStreamCrossProcessFD.getInstance(EGL.getCapabilities());
    }

    public static KHRStreamCrossProcessFD getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRStreamCrossProcessFD);
    }

    public static int eglGetStreamFileDescriptorKHR(long dpy, long stream) {
        long __functionAddress = KHRStreamCrossProcessFD.getInstance().GetStreamFileDescriptorKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(stream);
        }
        return JNI.callPPI(__functionAddress, dpy, stream);
    }

    public static long eglCreateStreamFromFileDescriptorKHR(long dpy, int file_descriptor) {
        long __functionAddress = KHRStreamCrossProcessFD.getInstance().CreateStreamFromFileDescriptorKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPIP(__functionAddress, dpy, file_descriptor);
    }
}

