/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRStreamFIFO {
    public static final int EGL_STREAM_FIFO_LENGTH_KHR = 12796;
    public static final int EGL_STREAM_TIME_NOW_KHR = 12797;
    public static final int EGL_STREAM_TIME_CONSUMER_KHR = 12798;
    public static final int EGL_STREAM_TIME_PRODUCER_KHR = 12799;
    public final long QueryStreamTimeKHR;

    protected KHRStreamFIFO() {
        throw new UnsupportedOperationException();
    }

    public KHRStreamFIFO(FunctionProvider provider) {
        this.QueryStreamTimeKHR = provider.getFunctionAddress("eglQueryStreamTimeKHR");
    }

    public static KHRStreamFIFO getInstance() {
        return KHRStreamFIFO.getInstance(EGL.getCapabilities());
    }

    public static KHRStreamFIFO getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRStreamFIFO);
    }

    public static boolean neglQueryStreamTimeKHR(long dpy, long stream, int attribute, long value) {
        long __functionAddress = KHRStreamFIFO.getInstance().QueryStreamTimeKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(stream);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, stream, attribute, value);
    }

    public static boolean eglQueryStreamTimeKHR(long dpy, long stream, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 8);
        }
        return KHRStreamFIFO.neglQueryStreamTimeKHR(dpy, stream, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglQueryStreamTimeKHR(long dpy, long stream, int attribute, LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return KHRStreamFIFO.neglQueryStreamTimeKHR(dpy, stream, attribute, MemoryUtil.memAddress(value));
    }
}

