/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class MESAImageDMABufExport {
    public final long ExportDMABUFImageQueryMESA;
    public final long ExportDMABUFImageMESA;

    protected MESAImageDMABufExport() {
        throw new UnsupportedOperationException();
    }

    public MESAImageDMABufExport(FunctionProvider provider) {
        this.ExportDMABUFImageQueryMESA = provider.getFunctionAddress("eglExportDMABUFImageQueryMESA");
        this.ExportDMABUFImageMESA = provider.getFunctionAddress("eglExportDMABUFImageMESA");
    }

    public static MESAImageDMABufExport getInstance() {
        return MESAImageDMABufExport.getInstance(EGL.getCapabilities());
    }

    public static MESAImageDMABufExport getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__MESAImageDMABufExport);
    }

    public static boolean neglExportDMABUFImageQueryMESA(long dpy, long image, long fourcc, long num_planes, long modifiers) {
        long __functionAddress = MESAImageDMABufExport.getInstance().ExportDMABUFImageQueryMESA;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(image);
        }
        return JNI.callPPPPPZ(__functionAddress, dpy, image, fourcc, num_planes, modifiers);
    }

    public static boolean eglExportDMABUFImageQueryMESA(long dpy, long image, ByteBuffer fourcc, ByteBuffer num_planes, ByteBuffer modifiers) {
        if (Checks.CHECKS) {
            if (fourcc != null) {
                Checks.checkBuffer((Buffer)fourcc, 4);
            }
            if (num_planes != null) {
                Checks.checkBuffer((Buffer)num_planes, 4);
            }
            if (modifiers != null) {
                Checks.checkBuffer((Buffer)modifiers, 8);
            }
        }
        return MESAImageDMABufExport.neglExportDMABUFImageQueryMESA(dpy, image, MemoryUtil.memAddressSafe(fourcc), MemoryUtil.memAddressSafe(num_planes), MemoryUtil.memAddressSafe(modifiers));
    }

    public static boolean eglExportDMABUFImageQueryMESA(long dpy, long image, IntBuffer fourcc, IntBuffer num_planes, LongBuffer modifiers) {
        if (Checks.CHECKS) {
            if (fourcc != null) {
                Checks.checkBuffer((Buffer)fourcc, 1);
            }
            if (num_planes != null) {
                Checks.checkBuffer((Buffer)num_planes, 1);
            }
            if (modifiers != null) {
                Checks.checkBuffer((Buffer)modifiers, 1);
            }
        }
        return MESAImageDMABufExport.neglExportDMABUFImageQueryMESA(dpy, image, MemoryUtil.memAddressSafe(fourcc), MemoryUtil.memAddressSafe(num_planes), MemoryUtil.memAddressSafe(modifiers));
    }

    public static boolean neglExportDMABUFImageMESA(long dpy, long image, long fds, long strides, long offsets) {
        long __functionAddress = MESAImageDMABufExport.getInstance().ExportDMABUFImageMESA;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(image);
        }
        return JNI.callPPPPPZ(__functionAddress, dpy, image, fds, strides, offsets);
    }

    public static boolean eglExportDMABUFImageMESA(long dpy, long image, ByteBuffer fds, ByteBuffer strides, ByteBuffer offsets) {
        if (Checks.CHECKS) {
            if (fds != null) {
                Checks.checkBuffer((Buffer)fds, 4);
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, 4);
            }
            if (offsets != null) {
                Checks.checkBuffer((Buffer)offsets, 4);
            }
        }
        return MESAImageDMABufExport.neglExportDMABUFImageMESA(dpy, image, MemoryUtil.memAddressSafe(fds), MemoryUtil.memAddressSafe(strides), MemoryUtil.memAddressSafe(offsets));
    }

    public static boolean eglExportDMABUFImageMESA(long dpy, long image, IntBuffer fds, IntBuffer strides, IntBuffer offsets) {
        if (Checks.CHECKS) {
            if (fds != null) {
                Checks.checkBuffer((Buffer)fds, 1);
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, 1);
            }
            if (offsets != null) {
                Checks.checkBuffer((Buffer)offsets, 1);
            }
        }
        return MESAImageDMABufExport.neglExportDMABUFImageMESA(dpy, image, MemoryUtil.memAddressSafe(fds), MemoryUtil.memAddressSafe(strides), MemoryUtil.memAddressSafe(offsets));
    }
}

