/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVSync {
    public static final int EGL_SYNC_PRIOR_COMMANDS_COMPLETE_NV = 12518;
    public static final int EGL_SYNC_STATUS_NV = 12519;
    public static final int EGL_SIGNALED_NV = 12520;
    public static final int EGL_UNSIGNALED_NV = 12521;
    public static final int EGL_SYNC_FLUSH_COMMANDS_BIT_NV = 1;
    public static final int EGL_ALREADY_SIGNALED_NV = 12522;
    public static final int EGL_TIMEOUT_EXPIRED_NV = 12523;
    public static final int EGL_CONDITION_SATISFIED_NV = 12524;
    public static final int EGL_SYNC_TYPE_NV = 12525;
    public static final int EGL_SYNC_CONDITION_NV = 12526;
    public static final int EGL_SYNC_FENCE_NV = 12527;
    public static final long EGL_FOREVER_NV = -1L;
    public static final long EGL_NO_SYNC_NV = 0L;
    public final long CreateFenceSyncNV;
    public final long DestroySyncNV;
    public final long FenceNV;
    public final long ClientWaitSyncNV;
    public final long SignalSyncNV;
    public final long GetSyncAttribNV;

    protected NVSync() {
        throw new UnsupportedOperationException();
    }

    public NVSync(FunctionProvider provider) {
        this.CreateFenceSyncNV = provider.getFunctionAddress("eglCreateFenceSyncNV");
        this.DestroySyncNV = provider.getFunctionAddress("eglDestroySyncNV");
        this.FenceNV = provider.getFunctionAddress("eglFenceNV");
        this.ClientWaitSyncNV = provider.getFunctionAddress("eglClientWaitSyncNV");
        this.SignalSyncNV = provider.getFunctionAddress("eglSignalSyncNV");
        this.GetSyncAttribNV = provider.getFunctionAddress("eglGetSyncAttribNV");
    }

    public static NVSync getInstance() {
        return NVSync.getInstance(EGL.getCapabilities());
    }

    public static NVSync getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVSync);
    }

    public static long neglCreateFenceSyncNV(long dpy, int condition, long attrib_list) {
        long __functionAddress = NVSync.getInstance().CreateFenceSyncNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPIPP(__functionAddress, dpy, condition, attrib_list);
    }

    public static long eglCreateFenceSyncNV(long dpy, int condition, ByteBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return NVSync.neglCreateFenceSyncNV(dpy, condition, MemoryUtil.memAddress(attrib_list));
    }

    public static long eglCreateFenceSyncNV(long dpy, int condition, IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNT(attrib_list, 12344);
        }
        return NVSync.neglCreateFenceSyncNV(dpy, condition, MemoryUtil.memAddress(attrib_list));
    }

    public static boolean eglDestroySyncNV(long sync) {
        long __functionAddress = NVSync.getInstance().DestroySyncNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        return JNI.callPZ(__functionAddress, sync);
    }

    public static boolean eglFenceNV(long sync) {
        long __functionAddress = NVSync.getInstance().FenceNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        return JNI.callPZ(__functionAddress, sync);
    }

    public static int eglClientWaitSyncNV(long sync, int flags, long timeout) {
        long __functionAddress = NVSync.getInstance().ClientWaitSyncNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        return JNI.callPIJI(__functionAddress, sync, flags, timeout);
    }

    public static boolean eglSignalSyncNV(long sync, int mode) {
        long __functionAddress = NVSync.getInstance().SignalSyncNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        return JNI.callPIZ(__functionAddress, sync, mode);
    }

    public static boolean neglGetSyncAttribNV(long sync, int attribute, long value) {
        long __functionAddress = NVSync.getInstance().GetSyncAttribNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(sync);
        }
        return JNI.callPIPZ(__functionAddress, sync, attribute, value);
    }

    public static boolean eglGetSyncAttribNV(long sync, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return NVSync.neglGetSyncAttribNV(sync, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglGetSyncAttribNV(long sync, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return NVSync.neglGetSyncAttribNV(sync, attribute, MemoryUtil.memAddress(value));
    }
}

