/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.EventLoop;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharModsCallback;
import org.lwjgl.glfw.GLFWCursorEnterCallback;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWDropCallback;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWGammaRamp;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWMonitorCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowCloseCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowIconifyCallback;
import org.lwjgl.glfw.GLFWWindowPosCallback;
import org.lwjgl.glfw.GLFWWindowRefreshCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;

public class GLFW {
    public static final int GLFW_VERSION_MAJOR = 3;
    public static final int GLFW_VERSION_MINOR = 2;
    public static final int GLFW_VERSION_REVISION = 0;
    public static final int GLFW_TRUE = 1;
    public static final int GLFW_FALSE = 0;
    public static final int GLFW_RELEASE = 0;
    public static final int GLFW_PRESS = 1;
    public static final int GLFW_REPEAT = 2;
    public static final int GLFW_KEY_UNKNOWN = -1;
    public static final int GLFW_KEY_SPACE = 32;
    public static final int GLFW_KEY_APOSTROPHE = 39;
    public static final int GLFW_KEY_COMMA = 44;
    public static final int GLFW_KEY_MINUS = 45;
    public static final int GLFW_KEY_PERIOD = 46;
    public static final int GLFW_KEY_SLASH = 47;
    public static final int GLFW_KEY_0 = 48;
    public static final int GLFW_KEY_1 = 49;
    public static final int GLFW_KEY_2 = 50;
    public static final int GLFW_KEY_3 = 51;
    public static final int GLFW_KEY_4 = 52;
    public static final int GLFW_KEY_5 = 53;
    public static final int GLFW_KEY_6 = 54;
    public static final int GLFW_KEY_7 = 55;
    public static final int GLFW_KEY_8 = 56;
    public static final int GLFW_KEY_9 = 57;
    public static final int GLFW_KEY_SEMICOLON = 59;
    public static final int GLFW_KEY_EQUAL = 61;
    public static final int GLFW_KEY_A = 65;
    public static final int GLFW_KEY_B = 66;
    public static final int GLFW_KEY_C = 67;
    public static final int GLFW_KEY_D = 68;
    public static final int GLFW_KEY_E = 69;
    public static final int GLFW_KEY_F = 70;
    public static final int GLFW_KEY_G = 71;
    public static final int GLFW_KEY_H = 72;
    public static final int GLFW_KEY_I = 73;
    public static final int GLFW_KEY_J = 74;
    public static final int GLFW_KEY_K = 75;
    public static final int GLFW_KEY_L = 76;
    public static final int GLFW_KEY_M = 77;
    public static final int GLFW_KEY_N = 78;
    public static final int GLFW_KEY_O = 79;
    public static final int GLFW_KEY_P = 80;
    public static final int GLFW_KEY_Q = 81;
    public static final int GLFW_KEY_R = 82;
    public static final int GLFW_KEY_S = 83;
    public static final int GLFW_KEY_T = 84;
    public static final int GLFW_KEY_U = 85;
    public static final int GLFW_KEY_V = 86;
    public static final int GLFW_KEY_W = 87;
    public static final int GLFW_KEY_X = 88;
    public static final int GLFW_KEY_Y = 89;
    public static final int GLFW_KEY_Z = 90;
    public static final int GLFW_KEY_LEFT_BRACKET = 91;
    public static final int GLFW_KEY_BACKSLASH = 92;
    public static final int GLFW_KEY_RIGHT_BRACKET = 93;
    public static final int GLFW_KEY_GRAVE_ACCENT = 96;
    public static final int GLFW_KEY_WORLD_1 = 161;
    public static final int GLFW_KEY_WORLD_2 = 162;
    public static final int GLFW_KEY_ESCAPE = 256;
    public static final int GLFW_KEY_ENTER = 257;
    public static final int GLFW_KEY_TAB = 258;
    public static final int GLFW_KEY_BACKSPACE = 259;
    public static final int GLFW_KEY_INSERT = 260;
    public static final int GLFW_KEY_DELETE = 261;
    public static final int GLFW_KEY_RIGHT = 262;
    public static final int GLFW_KEY_LEFT = 263;
    public static final int GLFW_KEY_DOWN = 264;
    public static final int GLFW_KEY_UP = 265;
    public static final int GLFW_KEY_PAGE_UP = 266;
    public static final int GLFW_KEY_PAGE_DOWN = 267;
    public static final int GLFW_KEY_HOME = 268;
    public static final int GLFW_KEY_END = 269;
    public static final int GLFW_KEY_CAPS_LOCK = 280;
    public static final int GLFW_KEY_SCROLL_LOCK = 281;
    public static final int GLFW_KEY_NUM_LOCK = 282;
    public static final int GLFW_KEY_PRINT_SCREEN = 283;
    public static final int GLFW_KEY_PAUSE = 284;
    public static final int GLFW_KEY_F1 = 290;
    public static final int GLFW_KEY_F2 = 291;
    public static final int GLFW_KEY_F3 = 292;
    public static final int GLFW_KEY_F4 = 293;
    public static final int GLFW_KEY_F5 = 294;
    public static final int GLFW_KEY_F6 = 295;
    public static final int GLFW_KEY_F7 = 296;
    public static final int GLFW_KEY_F8 = 297;
    public static final int GLFW_KEY_F9 = 298;
    public static final int GLFW_KEY_F10 = 299;
    public static final int GLFW_KEY_F11 = 300;
    public static final int GLFW_KEY_F12 = 301;
    public static final int GLFW_KEY_F13 = 302;
    public static final int GLFW_KEY_F14 = 303;
    public static final int GLFW_KEY_F15 = 304;
    public static final int GLFW_KEY_F16 = 305;
    public static final int GLFW_KEY_F17 = 306;
    public static final int GLFW_KEY_F18 = 307;
    public static final int GLFW_KEY_F19 = 308;
    public static final int GLFW_KEY_F20 = 309;
    public static final int GLFW_KEY_F21 = 310;
    public static final int GLFW_KEY_F22 = 311;
    public static final int GLFW_KEY_F23 = 312;
    public static final int GLFW_KEY_F24 = 313;
    public static final int GLFW_KEY_F25 = 314;
    public static final int GLFW_KEY_KP_0 = 320;
    public static final int GLFW_KEY_KP_1 = 321;
    public static final int GLFW_KEY_KP_2 = 322;
    public static final int GLFW_KEY_KP_3 = 323;
    public static final int GLFW_KEY_KP_4 = 324;
    public static final int GLFW_KEY_KP_5 = 325;
    public static final int GLFW_KEY_KP_6 = 326;
    public static final int GLFW_KEY_KP_7 = 327;
    public static final int GLFW_KEY_KP_8 = 328;
    public static final int GLFW_KEY_KP_9 = 329;
    public static final int GLFW_KEY_KP_DECIMAL = 330;
    public static final int GLFW_KEY_KP_DIVIDE = 331;
    public static final int GLFW_KEY_KP_MULTIPLY = 332;
    public static final int GLFW_KEY_KP_SUBTRACT = 333;
    public static final int GLFW_KEY_KP_ADD = 334;
    public static final int GLFW_KEY_KP_ENTER = 335;
    public static final int GLFW_KEY_KP_EQUAL = 336;
    public static final int GLFW_KEY_LEFT_SHIFT = 340;
    public static final int GLFW_KEY_LEFT_CONTROL = 341;
    public static final int GLFW_KEY_LEFT_ALT = 342;
    public static final int GLFW_KEY_LEFT_SUPER = 343;
    public static final int GLFW_KEY_RIGHT_SHIFT = 344;
    public static final int GLFW_KEY_RIGHT_CONTROL = 345;
    public static final int GLFW_KEY_RIGHT_ALT = 346;
    public static final int GLFW_KEY_RIGHT_SUPER = 347;
    public static final int GLFW_KEY_MENU = 348;
    public static final int GLFW_KEY_LAST = 348;
    public static final int GLFW_MOD_SHIFT = 1;
    public static final int GLFW_MOD_CONTROL = 2;
    public static final int GLFW_MOD_ALT = 4;
    public static final int GLFW_MOD_SUPER = 8;
    public static final int GLFW_MOUSE_BUTTON_1 = 0;
    public static final int GLFW_MOUSE_BUTTON_2 = 1;
    public static final int GLFW_MOUSE_BUTTON_3 = 2;
    public static final int GLFW_MOUSE_BUTTON_4 = 3;
    public static final int GLFW_MOUSE_BUTTON_5 = 4;
    public static final int GLFW_MOUSE_BUTTON_6 = 5;
    public static final int GLFW_MOUSE_BUTTON_7 = 6;
    public static final int GLFW_MOUSE_BUTTON_8 = 7;
    public static final int GLFW_MOUSE_BUTTON_LAST = 7;
    public static final int GLFW_MOUSE_BUTTON_LEFT = 0;
    public static final int GLFW_MOUSE_BUTTON_RIGHT = 1;
    public static final int GLFW_MOUSE_BUTTON_MIDDLE = 2;
    public static final int GLFW_JOYSTICK_1 = 0;
    public static final int GLFW_JOYSTICK_2 = 1;
    public static final int GLFW_JOYSTICK_3 = 2;
    public static final int GLFW_JOYSTICK_4 = 3;
    public static final int GLFW_JOYSTICK_5 = 4;
    public static final int GLFW_JOYSTICK_6 = 5;
    public static final int GLFW_JOYSTICK_7 = 6;
    public static final int GLFW_JOYSTICK_8 = 7;
    public static final int GLFW_JOYSTICK_9 = 8;
    public static final int GLFW_JOYSTICK_10 = 9;
    public static final int GLFW_JOYSTICK_11 = 10;
    public static final int GLFW_JOYSTICK_12 = 11;
    public static final int GLFW_JOYSTICK_13 = 12;
    public static final int GLFW_JOYSTICK_14 = 13;
    public static final int GLFW_JOYSTICK_15 = 14;
    public static final int GLFW_JOYSTICK_16 = 15;
    public static final int GLFW_JOYSTICK_LAST = 15;
    public static final int GLFW_NOT_INITIALIZED = 65537;
    public static final int GLFW_NO_CURRENT_CONTEXT = 65538;
    public static final int GLFW_INVALID_ENUM = 65539;
    public static final int GLFW_INVALID_VALUE = 65540;
    public static final int GLFW_OUT_OF_MEMORY = 65541;
    public static final int GLFW_API_UNAVAILABLE = 65542;
    public static final int GLFW_VERSION_UNAVAILABLE = 65543;
    public static final int GLFW_PLATFORM_ERROR = 65544;
    public static final int GLFW_FORMAT_UNAVAILABLE = 65545;
    public static final int GLFW_NO_WINDOW_CONTEXT = 65546;
    public static final int GLFW_FOCUSED = 131073;
    public static final int GLFW_ICONIFIED = 131074;
    public static final int GLFW_RESIZABLE = 131075;
    public static final int GLFW_VISIBLE = 131076;
    public static final int GLFW_DECORATED = 131077;
    public static final int GLFW_AUTO_ICONIFY = 131078;
    public static final int GLFW_FLOATING = 131079;
    public static final int GLFW_CURSOR = 208897;
    public static final int GLFW_STICKY_KEYS = 208898;
    public static final int GLFW_STICKY_MOUSE_BUTTONS = 208899;
    public static final int GLFW_CURSOR_NORMAL = 212993;
    public static final int GLFW_CURSOR_HIDDEN = 212994;
    public static final int GLFW_CURSOR_DISABLED = 212995;
    public static final int GLFW_ARROW_CURSOR = 221185;
    public static final int GLFW_IBEAM_CURSOR = 221186;
    public static final int GLFW_CROSSHAIR_CURSOR = 221187;
    public static final int GLFW_HAND_CURSOR = 221188;
    public static final int GLFW_HRESIZE_CURSOR = 221189;
    public static final int GLFW_VRESIZE_CURSOR = 221190;
    public static final int GLFW_CONNECTED = 262145;
    public static final int GLFW_DISCONNECTED = 262146;
    public static final int GLFW_DONT_CARE = -1;
    public static final int GLFW_RED_BITS = 135169;
    public static final int GLFW_GREEN_BITS = 135170;
    public static final int GLFW_BLUE_BITS = 135171;
    public static final int GLFW_ALPHA_BITS = 135172;
    public static final int GLFW_DEPTH_BITS = 135173;
    public static final int GLFW_STENCIL_BITS = 135174;
    public static final int GLFW_ACCUM_RED_BITS = 135175;
    public static final int GLFW_ACCUM_GREEN_BITS = 135176;
    public static final int GLFW_ACCUM_BLUE_BITS = 135177;
    public static final int GLFW_ACCUM_ALPHA_BITS = 135178;
    public static final int GLFW_AUX_BUFFERS = 135179;
    public static final int GLFW_STEREO = 135180;
    public static final int GLFW_SAMPLES = 135181;
    public static final int GLFW_SRGB_CAPABLE = 135182;
    public static final int GLFW_REFRESH_RATE = 135183;
    public static final int GLFW_DOUBLE_BUFFER = 135184;
    public static final int GLFW_CLIENT_API = 139265;
    public static final int GLFW_CONTEXT_VERSION_MAJOR = 139266;
    public static final int GLFW_CONTEXT_VERSION_MINOR = 139267;
    public static final int GLFW_CONTEXT_REVISION = 139268;
    public static final int GLFW_CONTEXT_ROBUSTNESS = 139269;
    public static final int GLFW_OPENGL_FORWARD_COMPAT = 139270;
    public static final int GLFW_OPENGL_DEBUG_CONTEXT = 139271;
    public static final int GLFW_OPENGL_PROFILE = 139272;
    public static final int GLFW_CONTEXT_RELEASE_BEHAVIOR = 139273;
    public static final int GLFW_CONTEXT_NO_ERROR = 139274;
    public static final int GLFW_NO_API = 0;
    public static final int GLFW_OPENGL_API = 196609;
    public static final int GLFW_OPENGL_ES_API = 196610;
    public static final int GLFW_NO_ROBUSTNESS = 0;
    public static final int GLFW_NO_RESET_NOTIFICATION = 200705;
    public static final int GLFW_LOSE_CONTEXT_ON_RESET = 200706;
    public static final int GLFW_OPENGL_ANY_PROFILE = 0;
    public static final int GLFW_OPENGL_CORE_PROFILE = 204801;
    public static final int GLFW_OPENGL_COMPAT_PROFILE = 204802;
    public static final int GLFW_ANY_RELEASE_BEHAVIOR = 0;
    public static final int GLFW_RELEASE_BEHAVIOR_FLUSH = 217089;
    public static final int GLFW_RELEASE_BEHAVIOR_NONE = 217090;
    public final long Init;
    public final long Terminate;
    public final long GetVersion;
    public final long GetVersionString;
    public final long SetErrorCallback;
    public final long GetMonitors;
    public final long GetPrimaryMonitor;
    public final long GetMonitorPos;
    public final long GetMonitorPhysicalSize;
    public final long GetMonitorName;
    public final long SetMonitorCallback;
    public final long GetVideoModes;
    public final long GetVideoMode;
    public final long SetGamma;
    public final long GetGammaRamp;
    public final long SetGammaRamp;
    public final long DefaultWindowHints;
    public final long WindowHint;
    public final long CreateWindow;
    public final long DestroyWindow;
    public final long WindowShouldClose;
    public final long SetWindowShouldClose;
    public final long SetWindowTitle;
    public final long GetWindowPos;
    public final long SetWindowPos;
    public final long GetWindowSize;
    public final long SetWindowSizeLimits;
    public final long SetWindowAspectRatio;
    public final long SetWindowSize;
    public final long GetFramebufferSize;
    public final long GetWindowFrameSize;
    public final long IconifyWindow;
    public final long RestoreWindow;
    public final long ShowWindow;
    public final long HideWindow;
    public final long GetWindowMonitor;
    public final long GetWindowAttrib;
    public final long SetWindowUserPointer;
    public final long GetWindowUserPointer;
    public final long SetWindowPosCallback;
    public final long SetWindowSizeCallback;
    public final long SetWindowCloseCallback;
    public final long SetWindowRefreshCallback;
    public final long SetWindowFocusCallback;
    public final long SetWindowIconifyCallback;
    public final long SetFramebufferSizeCallback;
    public final long PollEvents;
    public final long WaitEvents;
    public final long PostEmptyEvent;
    public final long GetInputMode;
    public final long SetInputMode;
    public final long GetKeyName;
    public final long GetKey;
    public final long GetMouseButton;
    public final long GetCursorPos;
    public final long SetCursorPos;
    public final long CreateCursor;
    public final long CreateStandardCursor;
    public final long DestroyCursor;
    public final long SetCursor;
    public final long SetKeyCallback;
    public final long SetCharCallback;
    public final long SetCharModsCallback;
    public final long SetMouseButtonCallback;
    public final long SetCursorPosCallback;
    public final long SetCursorEnterCallback;
    public final long SetScrollCallback;
    public final long SetDropCallback;
    public final long JoystickPresent;
    public final long GetJoystickAxes;
    public final long GetJoystickButtons;
    public final long GetJoystickName;
    public final long SetClipboardString;
    public final long GetClipboardString;
    public final long GetTime;
    public final long SetTime;
    public final long MakeContextCurrent;
    public final long GetCurrentContext;
    public final long SwapBuffers;
    public final long SwapInterval;
    public final long ExtensionSupported;
    public final long GetProcAddress;
    private static final SharedLibrary GLFW = Library.loadNative(Configuration.LIBRARY_NAME_GLFW.get(Pointer.BITS64 ? "glfw" : "glfw32"));
    private static final GLFW instance = new GLFW(GLFW);

    protected GLFW() {
        throw new UnsupportedOperationException();
    }

    public GLFW(FunctionProvider provider) {
        this.Init = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwInit"));
        this.Terminate = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwTerminate"));
        this.GetVersion = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetVersion"));
        this.GetVersionString = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetVersionString"));
        this.SetErrorCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetErrorCallback"));
        this.GetMonitors = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetMonitors"));
        this.GetPrimaryMonitor = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetPrimaryMonitor"));
        this.GetMonitorPos = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetMonitorPos"));
        this.GetMonitorPhysicalSize = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetMonitorPhysicalSize"));
        this.GetMonitorName = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetMonitorName"));
        this.SetMonitorCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetMonitorCallback"));
        this.GetVideoModes = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetVideoModes"));
        this.GetVideoMode = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetVideoMode"));
        this.SetGamma = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetGamma"));
        this.GetGammaRamp = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetGammaRamp"));
        this.SetGammaRamp = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetGammaRamp"));
        this.DefaultWindowHints = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwDefaultWindowHints"));
        this.WindowHint = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwWindowHint"));
        this.CreateWindow = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwCreateWindow"));
        this.DestroyWindow = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwDestroyWindow"));
        this.WindowShouldClose = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwWindowShouldClose"));
        this.SetWindowShouldClose = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowShouldClose"));
        this.SetWindowTitle = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowTitle"));
        this.GetWindowPos = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetWindowPos"));
        this.SetWindowPos = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowPos"));
        this.GetWindowSize = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetWindowSize"));
        this.SetWindowSizeLimits = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowSizeLimits"));
        this.SetWindowAspectRatio = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowAspectRatio"));
        this.SetWindowSize = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowSize"));
        this.GetFramebufferSize = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetFramebufferSize"));
        this.GetWindowFrameSize = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetWindowFrameSize"));
        this.IconifyWindow = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwIconifyWindow"));
        this.RestoreWindow = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwRestoreWindow"));
        this.ShowWindow = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwShowWindow"));
        this.HideWindow = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwHideWindow"));
        this.GetWindowMonitor = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetWindowMonitor"));
        this.GetWindowAttrib = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetWindowAttrib"));
        this.SetWindowUserPointer = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowUserPointer"));
        this.GetWindowUserPointer = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetWindowUserPointer"));
        this.SetWindowPosCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowPosCallback"));
        this.SetWindowSizeCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowSizeCallback"));
        this.SetWindowCloseCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowCloseCallback"));
        this.SetWindowRefreshCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowRefreshCallback"));
        this.SetWindowFocusCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowFocusCallback"));
        this.SetWindowIconifyCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetWindowIconifyCallback"));
        this.SetFramebufferSizeCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetFramebufferSizeCallback"));
        this.PollEvents = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwPollEvents"));
        this.WaitEvents = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwWaitEvents"));
        this.PostEmptyEvent = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwPostEmptyEvent"));
        this.GetInputMode = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetInputMode"));
        this.SetInputMode = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetInputMode"));
        this.GetKeyName = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetKeyName"));
        this.GetKey = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetKey"));
        this.GetMouseButton = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetMouseButton"));
        this.GetCursorPos = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetCursorPos"));
        this.SetCursorPos = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetCursorPos"));
        this.CreateCursor = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwCreateCursor"));
        this.CreateStandardCursor = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwCreateStandardCursor"));
        this.DestroyCursor = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwDestroyCursor"));
        this.SetCursor = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetCursor"));
        this.SetKeyCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetKeyCallback"));
        this.SetCharCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetCharCallback"));
        this.SetCharModsCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetCharModsCallback"));
        this.SetMouseButtonCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetMouseButtonCallback"));
        this.SetCursorPosCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetCursorPosCallback"));
        this.SetCursorEnterCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetCursorEnterCallback"));
        this.SetScrollCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetScrollCallback"));
        this.SetDropCallback = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetDropCallback"));
        this.JoystickPresent = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwJoystickPresent"));
        this.GetJoystickAxes = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetJoystickAxes"));
        this.GetJoystickButtons = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetJoystickButtons"));
        this.GetJoystickName = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetJoystickName"));
        this.SetClipboardString = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetClipboardString"));
        this.GetClipboardString = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetClipboardString"));
        this.GetTime = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetTime"));
        this.SetTime = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSetTime"));
        this.MakeContextCurrent = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwMakeContextCurrent"));
        this.GetCurrentContext = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetCurrentContext"));
        this.SwapBuffers = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSwapBuffers"));
        this.SwapInterval = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwSwapInterval"));
        this.ExtensionSupported = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwExtensionSupported"));
        this.GetProcAddress = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetProcAddress"));
    }

    public static SharedLibrary getLibrary() {
        return GLFW;
    }

    public static GLFW getInstance() {
        return instance;
    }

    public static int glfwInit() {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().Init;
        return JNI.invokeI(__functionAddress);
    }

    public static void glfwTerminate() {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().Terminate;
        JNI.invokeV(__functionAddress);
    }

    public static void nglfwGetVersion(long major, long minor, long rev) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetVersion;
        JNI.invokePPPV(__functionAddress, major, minor, rev);
    }

    public static void glfwGetVersion(ByteBuffer major, ByteBuffer minor, ByteBuffer rev) {
        if (Checks.CHECKS) {
            if (major != null) {
                Checks.checkBuffer((Buffer)major, 4);
            }
            if (minor != null) {
                Checks.checkBuffer((Buffer)minor, 4);
            }
            if (rev != null) {
                Checks.checkBuffer((Buffer)rev, 4);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetVersion(MemoryUtil.memAddressSafe(major), MemoryUtil.memAddressSafe(minor), MemoryUtil.memAddressSafe(rev));
    }

    public static void glfwGetVersion(IntBuffer major, IntBuffer minor, IntBuffer rev) {
        if (Checks.CHECKS) {
            if (major != null) {
                Checks.checkBuffer((Buffer)major, 1);
            }
            if (minor != null) {
                Checks.checkBuffer((Buffer)minor, 1);
            }
            if (rev != null) {
                Checks.checkBuffer((Buffer)rev, 1);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetVersion(MemoryUtil.memAddressSafe(major), MemoryUtil.memAddressSafe(minor), MemoryUtil.memAddressSafe(rev));
    }

    public static long nglfwGetVersionString() {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetVersionString;
        return JNI.invokeP(__functionAddress);
    }

    public static String glfwGetVersionString() {
        long __result = org.lwjgl.glfw.GLFW.nglfwGetVersionString();
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static GLFWErrorCallback glfwSetErrorCallback(GLFWErrorCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetErrorCallback;
        return (GLFWErrorCallback)GLFWErrorCallback.create(JNI.invokePP(__functionAddress, cbfun == null ? 0L : cbfun.address()));
    }

    public static long nglfwGetMonitors(long count) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetMonitors;
        return JNI.invokePP(__functionAddress, count);
    }

    public static PointerBuffer glfwGetMonitors() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        long __result = org.lwjgl.glfw.GLFW.nglfwGetMonitors(__buffer.address(count));
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(count));
    }

    public static long glfwGetPrimaryMonitor() {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetPrimaryMonitor;
        return JNI.invokeP(__functionAddress);
    }

    public static void nglfwGetMonitorPos(long monitor, long xpos, long ypos) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetMonitorPos;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        JNI.invokePPPV(__functionAddress, monitor, xpos, ypos);
    }

    public static void glfwGetMonitorPos(long monitor, ByteBuffer xpos, ByteBuffer ypos) {
        if (Checks.CHECKS) {
            if (xpos != null) {
                Checks.checkBuffer((Buffer)xpos, 4);
            }
            if (ypos != null) {
                Checks.checkBuffer((Buffer)ypos, 4);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetMonitorPos(monitor, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static void glfwGetMonitorPos(long monitor, IntBuffer xpos, IntBuffer ypos) {
        if (Checks.CHECKS) {
            if (xpos != null) {
                Checks.checkBuffer((Buffer)xpos, 1);
            }
            if (ypos != null) {
                Checks.checkBuffer((Buffer)ypos, 1);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetMonitorPos(monitor, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static void nglfwGetMonitorPhysicalSize(long monitor, long widthMM, long heightMM) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetMonitorPhysicalSize;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        JNI.invokePPPV(__functionAddress, monitor, widthMM, heightMM);
    }

    public static void glfwGetMonitorPhysicalSize(long monitor, ByteBuffer widthMM, ByteBuffer heightMM) {
        if (Checks.CHECKS) {
            if (widthMM != null) {
                Checks.checkBuffer((Buffer)widthMM, 4);
            }
            if (heightMM != null) {
                Checks.checkBuffer((Buffer)heightMM, 4);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetMonitorPhysicalSize(monitor, MemoryUtil.memAddressSafe(widthMM), MemoryUtil.memAddressSafe(heightMM));
    }

    public static void glfwGetMonitorPhysicalSize(long monitor, IntBuffer widthMM, IntBuffer heightMM) {
        if (Checks.CHECKS) {
            if (widthMM != null) {
                Checks.checkBuffer((Buffer)widthMM, 1);
            }
            if (heightMM != null) {
                Checks.checkBuffer((Buffer)heightMM, 1);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetMonitorPhysicalSize(monitor, MemoryUtil.memAddressSafe(widthMM), MemoryUtil.memAddressSafe(heightMM));
    }

    public static long nglfwGetMonitorName(long monitor) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetMonitorName;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        return JNI.invokePP(__functionAddress, monitor);
    }

    public static String glfwGetMonitorName(long monitor) {
        long __result = org.lwjgl.glfw.GLFW.nglfwGetMonitorName(monitor);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static GLFWMonitorCallback glfwSetMonitorCallback(GLFWMonitorCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetMonitorCallback;
        return (GLFWMonitorCallback)GLFWMonitorCallback.create(JNI.invokePP(__functionAddress, cbfun == null ? 0L : cbfun.address()));
    }

    public static long nglfwGetVideoModes(long monitor, long count) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetVideoModes;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        return JNI.invokePPP(__functionAddress, monitor, count);
    }

    public static GLFWVidMode.Buffer glfwGetVideoModes(long monitor) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        long __result = org.lwjgl.glfw.GLFW.nglfwGetVideoModes(monitor, __buffer.address(count));
        return new GLFWVidMode.Buffer(MemoryUtil.memByteBuffer(__result, __buffer.intValue(count) * GLFWVidMode.SIZEOF));
    }

    public static long nglfwGetVideoMode(long monitor) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetVideoMode;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        return JNI.invokePP(__functionAddress, monitor);
    }

    public static GLFWVidMode glfwGetVideoMode(long monitor) {
        long __result = org.lwjgl.glfw.GLFW.nglfwGetVideoMode(monitor);
        return new GLFWVidMode(__result);
    }

    public static void glfwSetGamma(long monitor, float gamma) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetGamma;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        JNI.invokePFV(__functionAddress, monitor, gamma);
    }

    public static long nglfwGetGammaRamp(long monitor) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetGammaRamp;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        return JNI.invokePP(__functionAddress, monitor);
    }

    public static GLFWGammaRamp glfwGetGammaRamp(long monitor) {
        long __result = org.lwjgl.glfw.GLFW.nglfwGetGammaRamp(monitor);
        return new GLFWGammaRamp(__result);
    }

    public static void nglfwSetGammaRamp(long monitor, long ramp) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetGammaRamp;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        JNI.invokePPV(__functionAddress, monitor, ramp);
    }

    public static void glfwSetGammaRamp(long monitor, GLFWGammaRamp ramp) {
        org.lwjgl.glfw.GLFW.nglfwSetGammaRamp(monitor, ramp.address());
    }

    public static void glfwDefaultWindowHints() {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().DefaultWindowHints;
        JNI.invokeV(__functionAddress);
    }

    public static void glfwWindowHint(int target, int hint) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().WindowHint;
        JNI.invokeIIV(__functionAddress, target, hint);
    }

    public static long nglfwCreateWindow(int width, int height, long title, long monitor, long share) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().CreateWindow;
        return JNI.invokeIIPPPP(__functionAddress, width, height, title, monitor, share);
    }

    public static long glfwCreateWindow(int width, int height, ByteBuffer title, long monitor, long share) {
        EventLoop.OffScreen.check();
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        return org.lwjgl.glfw.GLFW.nglfwCreateWindow(width, height, MemoryUtil.memAddress(title), monitor, share);
    }

    public static long glfwCreateWindow(int width, int height, CharSequence title, long monitor, long share) {
        EventLoop.OffScreen.check();
        APIBuffer __buffer = APIUtil.apiBuffer();
        int titleEncoded = __buffer.stringParamUTF8(title, true);
        return org.lwjgl.glfw.GLFW.nglfwCreateWindow(width, height, __buffer.address(titleEncoded), monitor, share);
    }

    public static void glfwDestroyWindow(long window) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().DestroyWindow;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePV(__functionAddress, window);
    }

    public static int glfwWindowShouldClose(long window) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().WindowShouldClose;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePI(__functionAddress, window);
    }

    public static void glfwSetWindowShouldClose(long window, int value) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowShouldClose;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePIV(__functionAddress, window, value);
    }

    public static void nglfwSetWindowTitle(long window, long title) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowTitle;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePPV(__functionAddress, window, title);
    }

    public static void glfwSetWindowTitle(long window, ByteBuffer title) {
        if (Checks.CHECKS) {
            Checks.checkNT1(title);
        }
        org.lwjgl.glfw.GLFW.nglfwSetWindowTitle(window, MemoryUtil.memAddress(title));
    }

    public static void glfwSetWindowTitle(long window, CharSequence title) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int titleEncoded = __buffer.stringParamUTF8(title, true);
        org.lwjgl.glfw.GLFW.nglfwSetWindowTitle(window, __buffer.address(titleEncoded));
    }

    public static void nglfwGetWindowPos(long window, long xpos, long ypos) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetWindowPos;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePPPV(__functionAddress, window, xpos, ypos);
    }

    public static void glfwGetWindowPos(long window, ByteBuffer xpos, ByteBuffer ypos) {
        if (Checks.CHECKS) {
            if (xpos != null) {
                Checks.checkBuffer((Buffer)xpos, 4);
            }
            if (ypos != null) {
                Checks.checkBuffer((Buffer)ypos, 4);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetWindowPos(window, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static void glfwGetWindowPos(long window, IntBuffer xpos, IntBuffer ypos) {
        if (Checks.CHECKS) {
            if (xpos != null) {
                Checks.checkBuffer((Buffer)xpos, 1);
            }
            if (ypos != null) {
                Checks.checkBuffer((Buffer)ypos, 1);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetWindowPos(window, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static void glfwSetWindowPos(long window, int xpos, int ypos) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowPos;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePIIV(__functionAddress, window, xpos, ypos);
    }

    public static void nglfwGetWindowSize(long window, long width, long height) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetWindowSize;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePPPV(__functionAddress, window, width, height);
    }

    public static void glfwGetWindowSize(long window, ByteBuffer width, ByteBuffer height) {
        if (Checks.CHECKS) {
            if (width != null) {
                Checks.checkBuffer((Buffer)width, 4);
            }
            if (height != null) {
                Checks.checkBuffer((Buffer)height, 4);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetWindowSize(window, MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static void glfwGetWindowSize(long window, IntBuffer width, IntBuffer height) {
        if (Checks.CHECKS) {
            if (width != null) {
                Checks.checkBuffer((Buffer)width, 1);
            }
            if (height != null) {
                Checks.checkBuffer((Buffer)height, 1);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetWindowSize(window, MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static void glfwSetWindowSizeLimits(long window, int minwidth, int minheight, int maxwidth, int maxheight) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowSizeLimits;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePIIIIV(__functionAddress, window, minwidth, minheight, maxwidth, maxheight);
    }

    public static void glfwSetWindowAspectRatio(long window, int numer, int denom) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowAspectRatio;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePIIV(__functionAddress, window, numer, denom);
    }

    public static void glfwSetWindowSize(long window, int width, int height) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowSize;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePIIV(__functionAddress, window, width, height);
    }

    public static void nglfwGetFramebufferSize(long window, long width, long height) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetFramebufferSize;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePPPV(__functionAddress, window, width, height);
    }

    public static void glfwGetFramebufferSize(long window, ByteBuffer width, ByteBuffer height) {
        if (Checks.CHECKS) {
            if (width != null) {
                Checks.checkBuffer((Buffer)width, 4);
            }
            if (height != null) {
                Checks.checkBuffer((Buffer)height, 4);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetFramebufferSize(window, MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static void glfwGetFramebufferSize(long window, IntBuffer width, IntBuffer height) {
        if (Checks.CHECKS) {
            if (width != null) {
                Checks.checkBuffer((Buffer)width, 1);
            }
            if (height != null) {
                Checks.checkBuffer((Buffer)height, 1);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetFramebufferSize(window, MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static void nglfwGetWindowFrameSize(long window, long left, long top, long right, long bottom) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetWindowFrameSize;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePPPPPV(__functionAddress, window, left, top, right, bottom);
    }

    public static void glfwGetWindowFrameSize(long window, ByteBuffer left, ByteBuffer top, ByteBuffer right, ByteBuffer bottom) {
        if (Checks.CHECKS) {
            if (left != null) {
                Checks.checkBuffer((Buffer)left, 4);
            }
            if (top != null) {
                Checks.checkBuffer((Buffer)top, 4);
            }
            if (right != null) {
                Checks.checkBuffer((Buffer)right, 4);
            }
            if (bottom != null) {
                Checks.checkBuffer((Buffer)bottom, 4);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetWindowFrameSize(window, MemoryUtil.memAddressSafe(left), MemoryUtil.memAddressSafe(top), MemoryUtil.memAddressSafe(right), MemoryUtil.memAddressSafe(bottom));
    }

    public static void glfwGetWindowFrameSize(long window, IntBuffer left, IntBuffer top, IntBuffer right, IntBuffer bottom) {
        if (Checks.CHECKS) {
            if (left != null) {
                Checks.checkBuffer((Buffer)left, 1);
            }
            if (top != null) {
                Checks.checkBuffer((Buffer)top, 1);
            }
            if (right != null) {
                Checks.checkBuffer((Buffer)right, 1);
            }
            if (bottom != null) {
                Checks.checkBuffer((Buffer)bottom, 1);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetWindowFrameSize(window, MemoryUtil.memAddressSafe(left), MemoryUtil.memAddressSafe(top), MemoryUtil.memAddressSafe(right), MemoryUtil.memAddressSafe(bottom));
    }

    public static void glfwIconifyWindow(long window) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().IconifyWindow;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePV(__functionAddress, window);
    }

    public static void glfwRestoreWindow(long window) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().RestoreWindow;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePV(__functionAddress, window);
    }

    public static void glfwShowWindow(long window) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().ShowWindow;
        EventLoop.OnScreen.check();
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePV(__functionAddress, window);
    }

    public static void glfwHideWindow(long window) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().HideWindow;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePV(__functionAddress, window);
    }

    public static long glfwGetWindowMonitor(long window) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetWindowMonitor;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePP(__functionAddress, window);
    }

    public static int glfwGetWindowAttrib(long window, int attrib) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetWindowAttrib;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePII(__functionAddress, window, attrib);
    }

    public static void glfwSetWindowUserPointer(long window, long pointer) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowUserPointer;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePPV(__functionAddress, window, pointer);
    }

    public static long glfwGetWindowUserPointer(long window) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetWindowUserPointer;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePP(__functionAddress, window);
    }

    public static GLFWWindowPosCallback glfwSetWindowPosCallback(long window, GLFWWindowPosCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowPosCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWWindowPosCallback)GLFWWindowPosCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWWindowSizeCallback glfwSetWindowSizeCallback(long window, GLFWWindowSizeCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowSizeCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWWindowSizeCallback)GLFWWindowSizeCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWWindowCloseCallback glfwSetWindowCloseCallback(long window, GLFWWindowCloseCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowCloseCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWWindowCloseCallback)GLFWWindowCloseCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWWindowRefreshCallback glfwSetWindowRefreshCallback(long window, GLFWWindowRefreshCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowRefreshCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWWindowRefreshCallback)GLFWWindowRefreshCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWWindowFocusCallback glfwSetWindowFocusCallback(long window, GLFWWindowFocusCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowFocusCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWWindowFocusCallback)GLFWWindowFocusCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWWindowIconifyCallback glfwSetWindowIconifyCallback(long window, GLFWWindowIconifyCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetWindowIconifyCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWWindowIconifyCallback)GLFWWindowIconifyCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWFramebufferSizeCallback glfwSetFramebufferSizeCallback(long window, GLFWFramebufferSizeCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetFramebufferSizeCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWFramebufferSizeCallback)GLFWFramebufferSizeCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static void glfwPollEvents() {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().PollEvents;
        EventLoop.OnScreen.check();
        JNI.invokeV(__functionAddress);
    }

    public static void glfwWaitEvents() {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().WaitEvents;
        EventLoop.OnScreen.check();
        JNI.invokeV(__functionAddress);
    }

    public static void glfwPostEmptyEvent() {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().PostEmptyEvent;
        JNI.invokeV(__functionAddress);
    }

    public static int glfwGetInputMode(long window, int mode) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetInputMode;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePII(__functionAddress, window, mode);
    }

    public static void glfwSetInputMode(long window, int mode, int value) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetInputMode;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePIIV(__functionAddress, window, mode, value);
    }

    public static long nglfwGetKeyName(int key, int scancode) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetKeyName;
        return JNI.invokeIIP(__functionAddress, key, scancode);
    }

    public static String glfwGetKeyName(int key, int scancode) {
        long __result = org.lwjgl.glfw.GLFW.nglfwGetKeyName(key, scancode);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static int glfwGetKey(long window, int key) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetKey;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePII(__functionAddress, window, key);
    }

    public static int glfwGetMouseButton(long window, int button) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetMouseButton;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePII(__functionAddress, window, button);
    }

    public static void nglfwGetCursorPos(long window, long xpos, long ypos) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetCursorPos;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePPPV(__functionAddress, window, xpos, ypos);
    }

    public static void glfwGetCursorPos(long window, ByteBuffer xpos, ByteBuffer ypos) {
        if (Checks.CHECKS) {
            if (xpos != null) {
                Checks.checkBuffer((Buffer)xpos, 8);
            }
            if (ypos != null) {
                Checks.checkBuffer((Buffer)ypos, 8);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetCursorPos(window, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static void glfwGetCursorPos(long window, DoubleBuffer xpos, DoubleBuffer ypos) {
        if (Checks.CHECKS) {
            if (xpos != null) {
                Checks.checkBuffer((Buffer)xpos, 1);
            }
            if (ypos != null) {
                Checks.checkBuffer((Buffer)ypos, 1);
            }
        }
        org.lwjgl.glfw.GLFW.nglfwGetCursorPos(window, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static void glfwSetCursorPos(long window, double xpos, double ypos) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetCursorPos;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePDDV(__functionAddress, window, xpos, ypos);
    }

    public static long nglfwCreateCursor(long image, int xhot, int yhot) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().CreateCursor;
        return JNI.invokePIIP(__functionAddress, image, xhot, yhot);
    }

    public static long glfwCreateCursor(GLFWImage image, int xhot, int yhot) {
        return org.lwjgl.glfw.GLFW.nglfwCreateCursor(image.address(), xhot, yhot);
    }

    public static long glfwCreateStandardCursor(int shape) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().CreateStandardCursor;
        return JNI.invokeIP(__functionAddress, shape);
    }

    public static void glfwDestroyCursor(long cursor) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().DestroyCursor;
        if (Checks.CHECKS) {
            Checks.checkPointer(cursor);
        }
        JNI.invokePV(__functionAddress, cursor);
    }

    public static void glfwSetCursor(long window, long cursor) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetCursor;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePPV(__functionAddress, window, cursor);
    }

    public static GLFWKeyCallback glfwSetKeyCallback(long window, GLFWKeyCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetKeyCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWKeyCallback)GLFWKeyCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWCharCallback glfwSetCharCallback(long window, GLFWCharCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetCharCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWCharCallback)GLFWCharCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWCharModsCallback glfwSetCharModsCallback(long window, GLFWCharModsCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetCharModsCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWCharModsCallback)GLFWCharModsCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWMouseButtonCallback glfwSetMouseButtonCallback(long window, GLFWMouseButtonCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetMouseButtonCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWMouseButtonCallback)GLFWMouseButtonCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWCursorPosCallback glfwSetCursorPosCallback(long window, GLFWCursorPosCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetCursorPosCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWCursorPosCallback)GLFWCursorPosCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWCursorEnterCallback glfwSetCursorEnterCallback(long window, GLFWCursorEnterCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetCursorEnterCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWCursorEnterCallback)GLFWCursorEnterCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWScrollCallback glfwSetScrollCallback(long window, GLFWScrollCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetScrollCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWScrollCallback)GLFWScrollCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static GLFWDropCallback glfwSetDropCallback(long window, GLFWDropCallback cbfun) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetDropCallback;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return (GLFWDropCallback)GLFWDropCallback.create(JNI.invokePPP(__functionAddress, window, cbfun == null ? 0L : cbfun.address()));
    }

    public static int glfwJoystickPresent(int joy) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().JoystickPresent;
        return JNI.invokeII(__functionAddress, joy);
    }

    public static long nglfwGetJoystickAxes(int joy, long count) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetJoystickAxes;
        return JNI.invokeIPP(__functionAddress, joy, count);
    }

    public static FloatBuffer glfwGetJoystickAxes(int joy) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        long __result = org.lwjgl.glfw.GLFW.nglfwGetJoystickAxes(joy, __buffer.address(count));
        return MemoryUtil.memFloatBuffer(__result, __buffer.intValue(count));
    }

    public static long nglfwGetJoystickButtons(int joy, long count) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetJoystickButtons;
        return JNI.invokeIPP(__functionAddress, joy, count);
    }

    public static ByteBuffer glfwGetJoystickButtons(int joy) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        long __result = org.lwjgl.glfw.GLFW.nglfwGetJoystickButtons(joy, __buffer.address(count));
        return MemoryUtil.memByteBuffer(__result, __buffer.intValue(count));
    }

    public static long nglfwGetJoystickName(int joy) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetJoystickName;
        return JNI.invokeIP(__functionAddress, joy);
    }

    public static String glfwGetJoystickName(int joy) {
        long __result = org.lwjgl.glfw.GLFW.nglfwGetJoystickName(joy);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static void nglfwSetClipboardString(long window, long string) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetClipboardString;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePPV(__functionAddress, window, string);
    }

    public static void glfwSetClipboardString(long window, ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.checkNT1(string);
        }
        org.lwjgl.glfw.GLFW.nglfwSetClipboardString(window, MemoryUtil.memAddress(string));
    }

    public static void glfwSetClipboardString(long window, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringEncoded = __buffer.stringParamUTF8(string, true);
        org.lwjgl.glfw.GLFW.nglfwSetClipboardString(window, __buffer.address(stringEncoded));
    }

    public static long nglfwGetClipboardString(long window) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetClipboardString;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePP(__functionAddress, window);
    }

    public static String glfwGetClipboardString(long window) {
        long __result = org.lwjgl.glfw.GLFW.nglfwGetClipboardString(window);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static double glfwGetTime() {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetTime;
        return JNI.invokeD(__functionAddress);
    }

    public static void glfwSetTime(double time) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SetTime;
        JNI.invokeDV(__functionAddress, time);
    }

    public static void glfwMakeContextCurrent(long window) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().MakeContextCurrent;
        JNI.invokePV(__functionAddress, window);
    }

    public static long glfwGetCurrentContext() {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetCurrentContext;
        return JNI.invokeP(__functionAddress);
    }

    public static void glfwSwapBuffers(long window) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SwapBuffers;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        JNI.invokePV(__functionAddress, window);
    }

    public static void glfwSwapInterval(int interval) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().SwapInterval;
        JNI.invokeIV(__functionAddress, interval);
    }

    public static int nglfwExtensionSupported(long extension) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().ExtensionSupported;
        return JNI.invokePI(__functionAddress, extension);
    }

    public static int glfwExtensionSupported(ByteBuffer extension) {
        if (Checks.CHECKS) {
            Checks.checkNT1(extension);
        }
        return org.lwjgl.glfw.GLFW.nglfwExtensionSupported(MemoryUtil.memAddress(extension));
    }

    public static int glfwExtensionSupported(CharSequence extension) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int extensionEncoded = __buffer.stringParamASCII(extension, true);
        return org.lwjgl.glfw.GLFW.nglfwExtensionSupported(__buffer.address(extensionEncoded));
    }

    public static long nglfwGetProcAddress(long procname) {
        long __functionAddress = org.lwjgl.glfw.GLFW.getInstance().GetProcAddress;
        return JNI.invokePP(__functionAddress, procname);
    }

    public static long glfwGetProcAddress(ByteBuffer procname) {
        if (Checks.CHECKS) {
            Checks.checkNT1(procname);
        }
        return org.lwjgl.glfw.GLFW.nglfwGetProcAddress(MemoryUtil.memAddress(procname));
    }

    public static long glfwGetProcAddress(CharSequence procname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int procnameEncoded = __buffer.stringParamASCII(procname, true);
        return org.lwjgl.glfw.GLFW.nglfwGetProcAddress(__buffer.address(procnameEncoded));
    }
}

