/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Map;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libffi.Closure;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.LibFFI;

public abstract class GLFWErrorCallback
extends Closure.Void {
    private static final FFICIF CIF = GLFWErrorCallback.staticAllocCIF();
    private static final PointerBuffer ARGS = GLFWErrorCallback.staticAllocPointer(2);
    private static final long CLASSPATH = GLFWErrorCallback.staticAllocText("org.lwjgl.glfw.GLFWErrorCallback");

    protected GLFWErrorCallback() {
        super(CIF, CLASSPATH);
    }

    @Override
    protected void callback(long args) {
        this.invoke(MemoryUtil.memGetInt(MemoryUtil.memGetAddress((long)(POINTER_SIZE * 0) + args)), MemoryUtil.memGetAddress(MemoryUtil.memGetAddress((long)(POINTER_SIZE * 1) + args)));
    }

    public abstract void invoke(int var1, long var2);

    public static GLFWErrorCallback create(final SAM sam) {
        return new GLFWErrorCallback(){

            @Override
            public void invoke(int error, long description) {
                sam.invoke(error, description);
            }
        };
    }

    public static String getDescription(long description) {
        return MemoryUtil.memDecodeUTF8(description);
    }

    public static GLFWErrorCallback createString(final SAMString sam) {
        return new GLFWErrorCallback(){

            @Override
            public void invoke(int error, long description) {
                sam.invoke(error, 2.getDescription(description));
            }
        };
    }

    public static GLFWErrorCallback createPrint() {
        return GLFWErrorCallback.createPrint(APIUtil.DEBUG_STREAM);
    }

    public static GLFWErrorCallback createPrint(final PrintStream stream) {
        return new GLFWErrorCallback(){
            private final Map<Integer, String> ERROR_CODES = APIUtil.apiClassTokens(new APIUtil.TokenFilter(){

                @Override
                public boolean accept(Field field, int value) {
                    return 65536 < value && value < 131072;
                }
            }, null, GLFW.class);

            @Override
            public void invoke(int error, long description) {
                String msg = MemoryUtil.memDecodeUTF8(description);
                stream.printf("[LWJGL] %s error\n", this.ERROR_CODES.get(error));
                stream.println("\tDescription : " + msg);
                stream.println("\tStacktrace  :");
                StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                for (int i = 4; i < stack.length; ++i) {
                    stream.print("\t\t");
                    stream.println(stack[i].toString());
                }
            }
        };
    }

    public static GLFWErrorCallback createThrow() {
        return new GLFWErrorCallback(){

            @Override
            public void invoke(int error, long description) {
                throw new IllegalStateException(String.format("GLFW error [0x%X]: %s", error, MemoryUtil.memDecodeUTF8(description)));
            }
        };
    }

    public GLFWErrorCallback set() {
        GLFW.glfwSetErrorCallback(this);
        return this;
    }

    static {
        GLFWErrorCallback.prepareCIF(CALL_CONVENTION_DEFAULT, CIF, LibFFI.ffi_type_void, ARGS, LibFFI.ffi_type_sint32, LibFFI.ffi_type_pointer);
    }

    public static interface SAMString {
        public void invoke(int var1, String var2);
    }

    public static interface SAM {
        public void invoke(int var1, long var2);
    }
}

