/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.SharedLibrary;

public class GLFWNativeWin32 {
    public final long GetWin32Adapter;
    public final long GetWin32Monitor;
    public final long GetWin32Window;
    private static final GLFWNativeWin32 instance = new GLFWNativeWin32(GLFWNativeWin32.getLibrary());

    protected GLFWNativeWin32() {
        throw new UnsupportedOperationException();
    }

    public GLFWNativeWin32(FunctionProvider provider) {
        this.GetWin32Adapter = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetWin32Adapter"));
        this.GetWin32Monitor = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetWin32Monitor"));
        this.GetWin32Window = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetWin32Window"));
    }

    public static SharedLibrary getLibrary() {
        return GLFW.getLibrary();
    }

    public static GLFWNativeWin32 getInstance() {
        return instance;
    }

    public static long nglfwGetWin32Adapter(long monitor) {
        long __functionAddress = GLFWNativeWin32.getInstance().GetWin32Adapter;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        return JNI.invokePP(__functionAddress, monitor);
    }

    public static String glfwGetWin32Adapter(long monitor) {
        long __result = GLFWNativeWin32.nglfwGetWin32Adapter(monitor);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static long nglfwGetWin32Monitor(long monitor) {
        long __functionAddress = GLFWNativeWin32.getInstance().GetWin32Monitor;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        return JNI.invokePP(__functionAddress, monitor);
    }

    public static String glfwGetWin32Monitor(long monitor) {
        long __result = GLFWNativeWin32.nglfwGetWin32Monitor(monitor);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static long glfwGetWin32Window(long window) {
        long __functionAddress = GLFWNativeWin32.getInstance().GetWin32Window;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePP(__functionAddress, window);
    }
}

