/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.SharedLibrary;

public class GLFWNativeX11 {
    public final long GetX11Display;
    public final long GetX11Adapter;
    public final long GetX11Monitor;
    public final long GetX11Window;
    private static final GLFWNativeX11 instance = new GLFWNativeX11(GLFWNativeX11.getLibrary());

    protected GLFWNativeX11() {
        throw new UnsupportedOperationException();
    }

    public GLFWNativeX11(FunctionProvider provider) {
        this.GetX11Display = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetX11Display"));
        this.GetX11Adapter = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetX11Adapter"));
        this.GetX11Monitor = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetX11Monitor"));
        this.GetX11Window = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetX11Window"));
    }

    public static SharedLibrary getLibrary() {
        return GLFW.getLibrary();
    }

    public static GLFWNativeX11 getInstance() {
        return instance;
    }

    public static long glfwGetX11Display() {
        long __functionAddress = GLFWNativeX11.getInstance().GetX11Display;
        return JNI.invokeP(__functionAddress);
    }

    public static long glfwGetX11Adapter(long monitor) {
        long __functionAddress = GLFWNativeX11.getInstance().GetX11Adapter;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        return JNI.invokePP(__functionAddress, monitor);
    }

    public static long glfwGetX11Monitor(long monitor) {
        long __functionAddress = GLFWNativeX11.getInstance().GetX11Monitor;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        return JNI.invokePP(__functionAddress, monitor);
    }

    public static long glfwGetX11Window(long window) {
        long __functionAddress = GLFWNativeX11.getInstance().GetX11Window;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePP(__functionAddress, window);
    }
}

