/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.IntBuffer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.ALDevice;
import org.lwjgl.openal.EXTThreadLocalContext;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.PointerWrapper;

public class ALContext
extends PointerWrapper {
    private final ALDevice device;
    private final ALCapabilities capabilities;

    public ALContext(ALDevice device, long handle) {
        super(handle);
        this.device = device;
        this.makeCurrent();
        if (device.address() != ALC10.alcGetContextsDevice(handle)) {
            throw new IllegalArgumentException("The specified device does not match with the context device.");
        }
        this.capabilities = AL.createCapabilities(device.address());
    }

    public ALDevice getDevice() {
        return this.device;
    }

    public ALCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void makeCurrent() {
        if (!ALC10.alcMakeContextCurrent(this.address())) {
            throw new RuntimeException("Failed to make AL context current in process.");
        }
        AL.setCurrentProcess(this);
    }

    public void makeCurrentThread() {
        if (!EXTThreadLocalContext.alcSetThreadContext(this.address())) {
            throw new RuntimeException("Failed to make AL context current in thread.");
        }
        AL.setCurrentThread(this);
    }

    public boolean isCurrent() {
        if (this.device.getCapabilities().ALC_EXT_thread_local_context && EXTThreadLocalContext.alcGetThreadContext() == this.address()) {
            return true;
        }
        return ALC10.alcGetCurrentContext() == this.address();
    }

    public void destroy() {
        if (this.isCurrent()) {
            ALC10.alcMakeContextCurrent(0L);
        }
        ALC10.alcDestroyContext(this.address());
    }

    public static ALContext create() {
        return ALContext.create(ALDevice.create(null), 0, 0, false);
    }

    public static ALContext create(ALDevice device) {
        return ALContext.create(device, 0, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ALContext create(ALDevice device, int frequency, int refresh, boolean sync) {
        IntBuffer attribs = MemoryUtil.memAllocInt(8);
        try {
            if (frequency != 0) {
                attribs.put(4103);
                attribs.put(frequency);
            }
            if (refresh != 0) {
                attribs.put(4104);
                attribs.put(refresh);
            }
            attribs.put(4105);
            attribs.put(sync ? 1 : 0);
            attribs.put(0);
            attribs.flip();
            ALContext aLContext = ALContext.create(device, attribs);
            return aLContext;
        }
        finally {
            MemoryUtil.memFree(attribs);
        }
    }

    public static ALContext create(ALDevice device, IntBuffer attributes) {
        long contextHandle = ALC10.alcCreateContext(device.address(), attributes);
        return new ALContext(device, contextHandle);
    }
}

