/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.PointerWrapper;

public class ALDevice
extends PointerWrapper {
    static ALDevice lastDevice;
    private final ALCCapabilities capabilities;

    public ALDevice(long device) {
        super(device);
        this.capabilities = ALC.createCapabilities(device);
        lastDevice = this;
    }

    public static ALDevice getLastDevice() {
        return lastDevice;
    }

    public ALCCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void destroy() {
        ALC10.alcCloseDevice(this.address());
        if (lastDevice == this) {
            lastDevice = null;
        }
    }

    public static ALDevice create() {
        return ALDevice.create(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ALDevice create(String deviceName) {
        long alcOpenDevice = ALC.getFunctionProvider().getFunctionAddress("alcOpenDevice");
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(alcOpenDevice);
        }
        ByteBuffer nameBuffer = deviceName == null ? null : MemoryUtil.memEncodeUTF8((CharSequence)deviceName, MemoryUtil.BufferAllocator.MALLOC);
        try {
            long device = JNI.invokePP(alcOpenDevice, MemoryUtil.memAddressSafe(nameBuffer));
            if (device == 0L) {
                throw new RuntimeException("Failed to open the device.");
            }
            ALDevice aLDevice = new ALDevice(device);
            return aLDevice;
        }
        finally {
            MemoryUtil.memFree(nameBuffer);
        }
    }
}

