/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL11;
import org.lwjgl.opencl.CL12;
import org.lwjgl.opencl.CL20;
import org.lwjgl.opencl.INTELAccelerator;
import org.lwjgl.opencl.KHRICD;
import org.lwjgl.opencl.OpenCLException;
import org.lwjgl.system.APIUtil;

public final class CLUtil {
    private static final Map<Integer, String> CL_ERROR_TOKENS = APIUtil.apiClassTokens(new APIUtil.TokenFilter(){
        private final List<String> EXCLUDE = Arrays.asList("CL_DEVICE_TYPE_ALL", "CL_BUILD_NONE", "CL_BUILD_ERROR", "CL_BUILD_IN_PROGRESS");

        @Override
        public boolean accept(Field field, int value) {
            return value < 0 && !this.EXCLUDE.contains(field.getName());
        }
    }, null, CL10.class, APIUtil.apiOptionalClass("org.lwjgl.opencl.CL10GL"), CL11.class, CL12.class, CL20.class, APIUtil.apiOptionalClass("org.lwjgl.opencl.APPLEGLSharing"), INTELAccelerator.class, APIUtil.apiOptionalClass("org.lwjgl.opencl.KHRGLSharing"), APIUtil.apiOptionalClass("org.lwjgl.opencl.KHREGLEvent"), APIUtil.apiOptionalClass("org.lwjgl.opencl.KHREGLImage"), KHRICD.class);

    private CLUtil() {
    }

    public static void checkCLError(ByteBuffer errcode_ret) {
        CLUtil.checkCLError(errcode_ret.getInt(errcode_ret.position()));
    }

    public static void checkCLError(IntBuffer errcode_ret) {
        CLUtil.checkCLError(errcode_ret.get(errcode_ret.position()));
    }

    public static void checkCLError(int errcode) {
        if (errcode != 0) {
            throw new OpenCLException(CLUtil.getErrcodeName(errcode));
        }
    }

    public static String getErrcodeName(int errcode) {
        String errname = CL_ERROR_TOKENS.get(errcode);
        if (errname == null) {
            errname = APIUtil.apiUnknownToken(errcode);
        }
        return errname;
    }
}

