/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class KHREGLImage {
    public static final int CL_EGL_RESOURCE_NOT_ACQUIRED_KHR = -1092;
    public static final int CL_INVALID_EGL_OBJECT_KHR = -1093;
    public static final int CL_COMMAND_ACQUIRE_EGL_OBJECTS_KHR = 8237;
    public static final int CL_COMMAND_RELEASE_EGL_OBJECTS_KHR = 8238;
    public final long CreateFromEGLImageKHR;
    public final long EnqueueAcquireEGLObjectsKHR;
    public final long EnqueueReleaseEGLObjectsKHR;

    protected KHREGLImage() {
        throw new UnsupportedOperationException();
    }

    public KHREGLImage(FunctionProvider provider) {
        this.CreateFromEGLImageKHR = provider.getFunctionAddress("clCreateFromEGLImageKHR");
        this.EnqueueAcquireEGLObjectsKHR = provider.getFunctionAddress("clEnqueueAcquireEGLObjectsKHR");
        this.EnqueueReleaseEGLObjectsKHR = provider.getFunctionAddress("clEnqueueReleaseEGLObjectsKHR");
    }

    public static KHREGLImage getInstance() {
        return KHREGLImage.getInstance(CL.getICD());
    }

    public static KHREGLImage getInstance(CLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHREGLImage);
    }

    static KHREGLImage create(FunctionProvider provider) {
        KHREGLImage funcs = new KHREGLImage(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateFromEGLImageKHR, funcs.EnqueueAcquireEGLObjectsKHR, funcs.EnqueueReleaseEGLObjectsKHR);
        return supported ? funcs : null;
    }

    public static long nclCreateFromEGLImageKHR(long context, long display, long image, long flags, long properties, long errcode_ret) {
        long __functionAddress = KHREGLImage.getInstance().CreateFromEGLImageKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
            Checks.checkPointer(display);
            Checks.checkPointer(image);
        }
        return JNI.callPPPJPPP(__functionAddress, context, display, image, flags, properties, errcode_ret);
    }

    public static long clCreateFromEGLImageKHR(long context, long display, long image, long flags, ByteBuffer properties, ByteBuffer errcode_ret) {
        if (Checks.CHECKS) {
            if (properties != null) {
                Checks.checkNTP(properties);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return KHREGLImage.nclCreateFromEGLImageKHR(context, display, image, flags, MemoryUtil.memAddressSafe(properties), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateFromEGLImageKHR(long context, long display, long image, long flags, PointerBuffer properties, IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            if (properties != null) {
                Checks.checkNT(properties);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return KHREGLImage.nclCreateFromEGLImageKHR(context, display, image, flags, MemoryUtil.memAddressSafe(properties), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclEnqueueAcquireEGLObjectsKHR(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = KHREGLImage.getInstance().EnqueueAcquireEGLObjectsKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(command_queue);
        }
        return JNI.callPIPIPPI(__functionAddress, command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueAcquireEGLObjectsKHR(long command_queue, int num_objects, ByteBuffer mem_objects, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)mem_objects, num_objects << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return KHREGLImage.nclEnqueueAcquireEGLObjectsKHR(command_queue, num_objects, MemoryUtil.memAddress(mem_objects), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueAcquireEGLObjectsKHR(long command_queue, PointerBuffer mem_objects, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return KHREGLImage.nclEnqueueAcquireEGLObjectsKHR(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueReleaseEGLObjectsKHR(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = KHREGLImage.getInstance().EnqueueReleaseEGLObjectsKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(command_queue);
        }
        return JNI.callPIPIPPI(__functionAddress, command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueReleaseEGLObjectsKHR(long command_queue, int num_objects, ByteBuffer mem_objects, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (Checks.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return KHREGLImage.nclEnqueueReleaseEGLObjectsKHR(command_queue, num_objects, MemoryUtil.memAddress(mem_objects), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReleaseEGLObjectsKHR(long command_queue, int num_objects, PointerBuffer mem_objects, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return KHREGLImage.nclEnqueueReleaseEGLObjectsKHR(command_queue, num_objects, MemoryUtil.memAddress(mem_objects), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }
}

