/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class AMDDrawBuffersBlend {
    public final long BlendFuncIndexedAMD;
    public final long BlendFuncSeparateIndexedAMD;
    public final long BlendEquationIndexedAMD;
    public final long BlendEquationSeparateIndexedAMD;

    protected AMDDrawBuffersBlend() {
        throw new UnsupportedOperationException();
    }

    public AMDDrawBuffersBlend(FunctionProvider provider) {
        this.BlendFuncIndexedAMD = provider.getFunctionAddress("glBlendFuncIndexedAMD");
        this.BlendFuncSeparateIndexedAMD = provider.getFunctionAddress("glBlendFuncSeparateIndexedAMD");
        this.BlendEquationIndexedAMD = provider.getFunctionAddress("glBlendEquationIndexedAMD");
        this.BlendEquationSeparateIndexedAMD = provider.getFunctionAddress("glBlendEquationSeparateIndexedAMD");
    }

    public static AMDDrawBuffersBlend getInstance() {
        return AMDDrawBuffersBlend.getInstance(GL.getCapabilities());
    }

    public static AMDDrawBuffersBlend getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__AMDDrawBuffersBlend);
    }

    static AMDDrawBuffersBlend create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_AMD_draw_buffers_blend")) {
            return null;
        }
        AMDDrawBuffersBlend funcs = new AMDDrawBuffersBlend(provider);
        boolean supported = Checks.checkFunctions(funcs.BlendFuncIndexedAMD, funcs.BlendFuncSeparateIndexedAMD, funcs.BlendEquationIndexedAMD, funcs.BlendEquationSeparateIndexedAMD);
        return GL.checkExtension("GL_AMD_draw_buffers_blend", funcs, supported);
    }

    public static void glBlendFuncIndexedAMD(int buf, int src, int dst) {
        long __functionAddress = AMDDrawBuffersBlend.getInstance().BlendFuncIndexedAMD;
        JNI.callIIIV(__functionAddress, buf, src, dst);
    }

    public static void glBlendFuncSeparateIndexedAMD(int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        long __functionAddress = AMDDrawBuffersBlend.getInstance().BlendFuncSeparateIndexedAMD;
        JNI.callIIIIIV(__functionAddress, buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    public static void glBlendEquationIndexedAMD(int buf, int mode) {
        long __functionAddress = AMDDrawBuffersBlend.getInstance().BlendEquationIndexedAMD;
        JNI.callIIV(__functionAddress, buf, mode);
    }

    public static void glBlendEquationSeparateIndexedAMD(int buf, int modeRGB, int modeAlpha) {
        long __functionAddress = AMDDrawBuffersBlend.getInstance().BlendEquationSeparateIndexedAMD;
        JNI.callIIIV(__functionAddress, buf, modeRGB, modeAlpha);
    }
}

