/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBBindlessTexture {
    public static final int GL_UNSIGNED_INT64_ARB = 5135;
    public final long GetTextureHandleARB;
    public final long GetTextureSamplerHandleARB;
    public final long MakeTextureHandleResidentARB;
    public final long MakeTextureHandleNonResidentARB;
    public final long GetImageHandleARB;
    public final long MakeImageHandleResidentARB;
    public final long MakeImageHandleNonResidentARB;
    public final long UniformHandleui64ARB;
    public final long UniformHandleui64vARB;
    public final long ProgramUniformHandleui64ARB;
    public final long ProgramUniformHandleui64vARB;
    public final long IsTextureHandleResidentARB;
    public final long IsImageHandleResidentARB;
    public final long VertexAttribL1ui64ARB;
    public final long VertexAttribL1ui64vARB;
    public final long GetVertexAttribLui64vARB;

    protected ARBBindlessTexture() {
        throw new UnsupportedOperationException();
    }

    public ARBBindlessTexture(FunctionProvider provider) {
        this.GetTextureHandleARB = provider.getFunctionAddress("glGetTextureHandleARB");
        this.GetTextureSamplerHandleARB = provider.getFunctionAddress("glGetTextureSamplerHandleARB");
        this.MakeTextureHandleResidentARB = provider.getFunctionAddress("glMakeTextureHandleResidentARB");
        this.MakeTextureHandleNonResidentARB = provider.getFunctionAddress("glMakeTextureHandleNonResidentARB");
        this.GetImageHandleARB = provider.getFunctionAddress("glGetImageHandleARB");
        this.MakeImageHandleResidentARB = provider.getFunctionAddress("glMakeImageHandleResidentARB");
        this.MakeImageHandleNonResidentARB = provider.getFunctionAddress("glMakeImageHandleNonResidentARB");
        this.UniformHandleui64ARB = provider.getFunctionAddress("glUniformHandleui64ARB");
        this.UniformHandleui64vARB = provider.getFunctionAddress("glUniformHandleui64vARB");
        this.ProgramUniformHandleui64ARB = provider.getFunctionAddress("glProgramUniformHandleui64ARB");
        this.ProgramUniformHandleui64vARB = provider.getFunctionAddress("glProgramUniformHandleui64vARB");
        this.IsTextureHandleResidentARB = provider.getFunctionAddress("glIsTextureHandleResidentARB");
        this.IsImageHandleResidentARB = provider.getFunctionAddress("glIsImageHandleResidentARB");
        this.VertexAttribL1ui64ARB = provider.getFunctionAddress("glVertexAttribL1ui64ARB");
        this.VertexAttribL1ui64vARB = provider.getFunctionAddress("glVertexAttribL1ui64vARB");
        this.GetVertexAttribLui64vARB = provider.getFunctionAddress("glGetVertexAttribLui64vARB");
    }

    public static ARBBindlessTexture getInstance() {
        return ARBBindlessTexture.getInstance(GL.getCapabilities());
    }

    public static ARBBindlessTexture getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBBindlessTexture);
    }

    static ARBBindlessTexture create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_bindless_texture")) {
            return null;
        }
        ARBBindlessTexture funcs = new ARBBindlessTexture(provider);
        boolean supported = Checks.checkFunctions(funcs.GetTextureHandleARB, funcs.GetTextureSamplerHandleARB, funcs.MakeTextureHandleResidentARB, funcs.MakeTextureHandleNonResidentARB, funcs.GetImageHandleARB, funcs.MakeImageHandleResidentARB, funcs.MakeImageHandleNonResidentARB, funcs.UniformHandleui64ARB, funcs.UniformHandleui64vARB, funcs.ProgramUniformHandleui64ARB, funcs.ProgramUniformHandleui64vARB, funcs.IsTextureHandleResidentARB, funcs.IsImageHandleResidentARB, funcs.VertexAttribL1ui64ARB, funcs.VertexAttribL1ui64vARB, funcs.GetVertexAttribLui64vARB);
        return GL.checkExtension("GL_ARB_bindless_texture", funcs, supported);
    }

    public static long glGetTextureHandleARB(int texture) {
        long __functionAddress = ARBBindlessTexture.getInstance().GetTextureHandleARB;
        return JNI.callIJ(__functionAddress, texture);
    }

    public static long glGetTextureSamplerHandleARB(int texture, int sampler) {
        long __functionAddress = ARBBindlessTexture.getInstance().GetTextureSamplerHandleARB;
        return JNI.callIIJ(__functionAddress, texture, sampler);
    }

    public static void glMakeTextureHandleResidentARB(long handle) {
        long __functionAddress = ARBBindlessTexture.getInstance().MakeTextureHandleResidentARB;
        JNI.callJV(__functionAddress, handle);
    }

    public static void glMakeTextureHandleNonResidentARB(long handle) {
        long __functionAddress = ARBBindlessTexture.getInstance().MakeTextureHandleNonResidentARB;
        JNI.callJV(__functionAddress, handle);
    }

    public static long glGetImageHandleARB(int texture, int level, boolean layered, int layer, int format) {
        long __functionAddress = ARBBindlessTexture.getInstance().GetImageHandleARB;
        return JNI.callIIZIIJ(__functionAddress, texture, level, layered, layer, format);
    }

    public static void glMakeImageHandleResidentARB(long handle, int access) {
        long __functionAddress = ARBBindlessTexture.getInstance().MakeImageHandleResidentARB;
        JNI.callJIV(__functionAddress, handle, access);
    }

    public static void glMakeImageHandleNonResidentARB(long handle) {
        long __functionAddress = ARBBindlessTexture.getInstance().MakeImageHandleNonResidentARB;
        JNI.callJV(__functionAddress, handle);
    }

    public static void glUniformHandleui64ARB(int location, long value) {
        long __functionAddress = ARBBindlessTexture.getInstance().UniformHandleui64ARB;
        JNI.callIJV(__functionAddress, location, value);
    }

    public static void nglUniformHandleui64vARB(int location, int count, long values) {
        long __functionAddress = ARBBindlessTexture.getInstance().UniformHandleui64vARB;
        JNI.callIIPV(__functionAddress, location, count, values);
    }

    public static void glUniformHandleui64vARB(int location, int count, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, count << 3);
        }
        ARBBindlessTexture.nglUniformHandleui64vARB(location, count, MemoryUtil.memAddress(values));
    }

    public static void glUniformHandleui64vARB(int location, LongBuffer values) {
        ARBBindlessTexture.nglUniformHandleui64vARB(location, values.remaining(), MemoryUtil.memAddress(values));
    }

    public static void glProgramUniformHandleui64ARB(int program, int location, long value) {
        long __functionAddress = ARBBindlessTexture.getInstance().ProgramUniformHandleui64ARB;
        JNI.callIIJV(__functionAddress, program, location, value);
    }

    public static void nglProgramUniformHandleui64vARB(int program, int location, int count, long values) {
        long __functionAddress = ARBBindlessTexture.getInstance().ProgramUniformHandleui64vARB;
        JNI.callIIIPV(__functionAddress, program, location, count, values);
    }

    public static void glProgramUniformHandleui64vARB(int program, int location, int count, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, count << 3);
        }
        ARBBindlessTexture.nglProgramUniformHandleui64vARB(program, location, count, MemoryUtil.memAddress(values));
    }

    public static void glProgramUniformHandleui64vARB(int program, int location, LongBuffer values) {
        ARBBindlessTexture.nglProgramUniformHandleui64vARB(program, location, values.remaining(), MemoryUtil.memAddress(values));
    }

    public static boolean glIsTextureHandleResidentARB(long handle) {
        long __functionAddress = ARBBindlessTexture.getInstance().IsTextureHandleResidentARB;
        return JNI.callJZ(__functionAddress, handle);
    }

    public static boolean glIsImageHandleResidentARB(long handle) {
        long __functionAddress = ARBBindlessTexture.getInstance().IsImageHandleResidentARB;
        return JNI.callJZ(__functionAddress, handle);
    }

    public static void glVertexAttribL1ui64ARB(int index, long x) {
        long __functionAddress = ARBBindlessTexture.getInstance().VertexAttribL1ui64ARB;
        JNI.callIJV(__functionAddress, index, x);
    }

    public static void nglVertexAttribL1ui64vARB(int index, long v) {
        long __functionAddress = ARBBindlessTexture.getInstance().VertexAttribL1ui64vARB;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttribL1ui64vARB(int index, ByteBuffer v) {
        ARBBindlessTexture.nglVertexAttribL1ui64vARB(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL1ui64vARB(int index, LongBuffer v) {
        ARBBindlessTexture.nglVertexAttribL1ui64vARB(index, MemoryUtil.memAddress(v));
    }

    public static void nglGetVertexAttribLui64vARB(int index, int pname, long params) {
        long __functionAddress = ARBBindlessTexture.getInstance().GetVertexAttribLui64vARB;
        JNI.callIIPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribLui64vARB(int index, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        ARBBindlessTexture.nglGetVertexAttribLui64vARB(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribLui64vARB(int index, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBBindlessTexture.nglGetVertexAttribLui64vARB(index, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetVertexAttribLui64ARB(int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        ARBBindlessTexture.nglGetVertexAttribLui64vARB(index, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }
}

