/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBES2Compatibility {
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_FIXED = 5132;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_RGB565 = 36194;
    public final long ReleaseShaderCompiler;
    public final long ShaderBinary;
    public final long GetShaderPrecisionFormat;
    public final long DepthRangef;
    public final long ClearDepthf;

    protected ARBES2Compatibility() {
        throw new UnsupportedOperationException();
    }

    public ARBES2Compatibility(FunctionProvider provider) {
        this.ReleaseShaderCompiler = provider.getFunctionAddress("glReleaseShaderCompiler");
        this.ShaderBinary = provider.getFunctionAddress("glShaderBinary");
        this.GetShaderPrecisionFormat = provider.getFunctionAddress("glGetShaderPrecisionFormat");
        this.DepthRangef = provider.getFunctionAddress("glDepthRangef");
        this.ClearDepthf = provider.getFunctionAddress("glClearDepthf");
    }

    public static ARBES2Compatibility getInstance() {
        return ARBES2Compatibility.getInstance(GL.getCapabilities());
    }

    public static ARBES2Compatibility getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBES2Compatibility);
    }

    static ARBES2Compatibility create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_ES2_compatibility")) {
            return null;
        }
        ARBES2Compatibility funcs = new ARBES2Compatibility(provider);
        boolean supported = Checks.checkFunctions(funcs.ReleaseShaderCompiler, funcs.ShaderBinary, funcs.GetShaderPrecisionFormat, funcs.DepthRangef, funcs.ClearDepthf);
        return GL.checkExtension("GL_ARB_ES2_compatibility", funcs, supported);
    }

    public static void glReleaseShaderCompiler() {
        long __functionAddress = ARBES2Compatibility.getInstance().ReleaseShaderCompiler;
        JNI.callV(__functionAddress);
    }

    public static void nglShaderBinary(int count, long shaders, int binaryformat, long binary, int length) {
        long __functionAddress = ARBES2Compatibility.getInstance().ShaderBinary;
        JNI.callIPIPIV(__functionAddress, count, shaders, binaryformat, binary, length);
    }

    public static void glShaderBinary(int count, ByteBuffer shaders, int binaryformat, ByteBuffer binary, int length) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)shaders, count << 2);
            Checks.checkBuffer((Buffer)binary, length);
        }
        ARBES2Compatibility.nglShaderBinary(count, MemoryUtil.memAddress(shaders), binaryformat, MemoryUtil.memAddress(binary), length);
    }

    public static void glShaderBinary(IntBuffer shaders, int binaryformat, ByteBuffer binary) {
        ARBES2Compatibility.nglShaderBinary(shaders.remaining(), MemoryUtil.memAddress(shaders), binaryformat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void nglGetShaderPrecisionFormat(int shadertype, int precisiontype, long range, long precision) {
        long __functionAddress = ARBES2Compatibility.getInstance().GetShaderPrecisionFormat;
        JNI.callIIPPV(__functionAddress, shadertype, precisiontype, range, precision);
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, ByteBuffer range, ByteBuffer precision) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)range, 8);
            Checks.checkBuffer((Buffer)precision, 4);
        }
        ARBES2Compatibility.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)range, 2);
            Checks.checkBuffer((Buffer)precision, 1);
        }
        ARBES2Compatibility.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
    }

    public static int glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)range, 2);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int precision = __buffer.intParam();
        ARBES2Compatibility.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), __buffer.address(precision));
        return __buffer.intValue(precision);
    }

    public static void glDepthRangef(float zNear, float zFar) {
        long __functionAddress = ARBES2Compatibility.getInstance().DepthRangef;
        JNI.callFFV(__functionAddress, zNear, zFar);
    }

    public static void glClearDepthf(float depth) {
        long __functionAddress = ARBES2Compatibility.getInstance().ClearDepthf;
        JNI.callFV(__functionAddress, depth);
    }
}

