/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBMapBufferRange {
    public static final int GL_MAP_READ_BIT = 1;
    public static final int GL_MAP_WRITE_BIT = 2;
    public static final int GL_MAP_INVALIDATE_RANGE_BIT = 4;
    public static final int GL_MAP_INVALIDATE_BUFFER_BIT = 8;
    public static final int GL_MAP_FLUSH_EXPLICIT_BIT = 16;
    public static final int GL_MAP_UNSYNCHRONIZED_BIT = 32;
    public final long MapBufferRange;
    public final long FlushMappedBufferRange;

    protected ARBMapBufferRange() {
        throw new UnsupportedOperationException();
    }

    public ARBMapBufferRange(FunctionProvider provider) {
        this.MapBufferRange = provider.getFunctionAddress("glMapBufferRange");
        this.FlushMappedBufferRange = provider.getFunctionAddress("glFlushMappedBufferRange");
    }

    public static ARBMapBufferRange getInstance() {
        return ARBMapBufferRange.getInstance(GL.getCapabilities());
    }

    public static ARBMapBufferRange getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBMapBufferRange);
    }

    static ARBMapBufferRange create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_map_buffer_range")) {
            return null;
        }
        ARBMapBufferRange funcs = new ARBMapBufferRange(provider);
        boolean supported = Checks.checkFunctions(funcs.MapBufferRange, funcs.FlushMappedBufferRange);
        return GL.checkExtension("GL_ARB_map_buffer_range", funcs, supported);
    }

    public static long nglMapBufferRange(int target, long offset, long length, int access) {
        long __functionAddress = ARBMapBufferRange.getInstance().MapBufferRange;
        return JNI.callIPPIP(__functionAddress, target, offset, length, access);
    }

    public static ByteBuffer glMapBufferRange(int target, long offset, long length, int access) {
        long __result = ARBMapBufferRange.nglMapBufferRange(target, offset, length, access);
        return MemoryUtil.memByteBuffer(__result, (int)length);
    }

    public static ByteBuffer glMapBufferRange(int target, long offset, long length, int access, ByteBuffer old_buffer) {
        long __result = ARBMapBufferRange.nglMapBufferRange(target, offset, length, access);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }

    public static void glFlushMappedBufferRange(int target, long offset, long length) {
        long __functionAddress = ARBMapBufferRange.getInstance().FlushMappedBufferRange;
        JNI.callIPPV(__functionAddress, target, offset, length);
    }
}

