/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBMatrixPalette {
    public static final int GL_MATRIX_PALETTE_ARB = 34880;
    public static final int GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = 34881;
    public static final int GL_MAX_PALETTE_MATRICES_ARB = 34882;
    public static final int GL_CURRENT_PALETTE_MATRIX_ARB = 34883;
    public static final int GL_MATRIX_INDEX_ARRAY_ARB = 34884;
    public static final int GL_CURRENT_MATRIX_INDEX_ARB = 34885;
    public static final int GL_MATRIX_INDEX_ARRAY_SIZE_ARB = 34886;
    public static final int GL_MATRIX_INDEX_ARRAY_TYPE_ARB = 34887;
    public static final int GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = 34888;
    public static final int GL_MATRIX_INDEX_ARRAY_POINTER_ARB = 34889;
    public final long CurrentPaletteMatrixARB;
    public final long MatrixIndexuivARB;
    public final long MatrixIndexubvARB;
    public final long MatrixIndexusvARB;
    public final long MatrixIndexPointerARB;

    protected ARBMatrixPalette() {
        throw new UnsupportedOperationException();
    }

    public ARBMatrixPalette(FunctionProvider provider) {
        this.CurrentPaletteMatrixARB = provider.getFunctionAddress("glCurrentPaletteMatrixARB");
        this.MatrixIndexuivARB = provider.getFunctionAddress("glMatrixIndexuivARB");
        this.MatrixIndexubvARB = provider.getFunctionAddress("glMatrixIndexubvARB");
        this.MatrixIndexusvARB = provider.getFunctionAddress("glMatrixIndexusvARB");
        this.MatrixIndexPointerARB = provider.getFunctionAddress("glMatrixIndexPointerARB");
    }

    public static ARBMatrixPalette getInstance() {
        return ARBMatrixPalette.getInstance(GL.getCapabilities());
    }

    public static ARBMatrixPalette getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBMatrixPalette);
    }

    static ARBMatrixPalette create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_matrix_palette")) {
            return null;
        }
        ARBMatrixPalette funcs = new ARBMatrixPalette(provider);
        boolean supported = Checks.checkFunctions(funcs.CurrentPaletteMatrixARB, funcs.MatrixIndexuivARB, funcs.MatrixIndexubvARB, funcs.MatrixIndexusvARB, funcs.MatrixIndexPointerARB);
        return GL.checkExtension("GL_ARB_matrix_palette", funcs, supported);
    }

    public static void glCurrentPaletteMatrixARB(int index) {
        long __functionAddress = ARBMatrixPalette.getInstance().CurrentPaletteMatrixARB;
        JNI.callIV(__functionAddress, index);
    }

    public static void nglMatrixIndexuivARB(int size, long indices) {
        long __functionAddress = ARBMatrixPalette.getInstance().MatrixIndexuivARB;
        JNI.callIPV(__functionAddress, size, indices);
    }

    public static void glMatrixIndexuivARB(int size, ByteBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, size << 2);
        }
        ARBMatrixPalette.nglMatrixIndexuivARB(size, MemoryUtil.memAddress(indices));
    }

    public static void glMatrixIndexuivARB(IntBuffer indices) {
        ARBMatrixPalette.nglMatrixIndexuivARB(indices.remaining(), MemoryUtil.memAddress(indices));
    }

    public static void nglMatrixIndexubvARB(int size, long indices) {
        long __functionAddress = ARBMatrixPalette.getInstance().MatrixIndexubvARB;
        JNI.callIPV(__functionAddress, size, indices);
    }

    public static void glMatrixIndexubvARB(int size, ByteBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, size);
        }
        ARBMatrixPalette.nglMatrixIndexubvARB(size, MemoryUtil.memAddress(indices));
    }

    public static void glMatrixIndexubvARB(ByteBuffer indices) {
        ARBMatrixPalette.nglMatrixIndexubvARB(indices.remaining(), MemoryUtil.memAddress(indices));
    }

    public static void nglMatrixIndexusvARB(int size, long indices) {
        long __functionAddress = ARBMatrixPalette.getInstance().MatrixIndexusvARB;
        JNI.callIPV(__functionAddress, size, indices);
    }

    public static void glMatrixIndexusvARB(int size, ByteBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, size << 1);
        }
        ARBMatrixPalette.nglMatrixIndexusvARB(size, MemoryUtil.memAddress(indices));
    }

    public static void glMatrixIndexusvARB(ShortBuffer indices) {
        ARBMatrixPalette.nglMatrixIndexusvARB(indices.remaining(), MemoryUtil.memAddress(indices));
    }

    public static void nglMatrixIndexPointerARB(int size, int type, int stride, long pointer) {
        long __functionAddress = ARBMatrixPalette.getInstance().MatrixIndexPointerARB;
        JNI.callIIIPV(__functionAddress, size, type, stride, pointer);
    }

    public static void glMatrixIndexPointerARB(int size, int type, int stride, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glMatrixIndexPointerARB(int size, int type, int stride, long pointerOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, true);
        }
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, type, stride, pointerOffset);
    }

    public static void glMatrixIndexPointerARB(int size, int stride, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, 5121, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glMatrixIndexPointerARB(int size, int stride, ShortBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, 5123, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glMatrixIndexPointerARB(int size, int stride, IntBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, 5125, stride, MemoryUtil.memAddress(pointer));
    }
}

