/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBPointParameters {
    public static final int GL_POINT_SIZE_MIN_ARB = 33062;
    public static final int GL_POINT_SIZE_MAX_ARB = 33063;
    public static final int GL_POINT_FADE_THRESHOLD_SIZE_ARB = 33064;
    public static final int GL_POINT_DISTANCE_ATTENUATION_ARB = 33065;
    public final long PointParameterfARB;
    public final long PointParameterfvARB;

    protected ARBPointParameters() {
        throw new UnsupportedOperationException();
    }

    public ARBPointParameters(FunctionProvider provider) {
        this.PointParameterfARB = provider.getFunctionAddress("glPointParameterfARB");
        this.PointParameterfvARB = provider.getFunctionAddress("glPointParameterfvARB");
    }

    public static ARBPointParameters getInstance() {
        return ARBPointParameters.getInstance(GL.getCapabilities());
    }

    public static ARBPointParameters getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBPointParameters);
    }

    static ARBPointParameters create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_point_parameters")) {
            return null;
        }
        ARBPointParameters funcs = new ARBPointParameters(provider);
        boolean supported = Checks.checkFunctions(funcs.PointParameterfARB, funcs.PointParameterfvARB);
        return GL.checkExtension("GL_ARB_point_parameters", funcs, supported);
    }

    public static void glPointParameterfARB(int pname, float param) {
        long __functionAddress = ARBPointParameters.getInstance().PointParameterfARB;
        JNI.callIFV(__functionAddress, pname, param);
    }

    public static void nglPointParameterfvARB(int pname, long params) {
        long __functionAddress = ARBPointParameters.getInstance().PointParameterfvARB;
        JNI.callIPV(__functionAddress, pname, params);
    }

    public static void glPointParameterfvARB(int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 12);
        }
        ARBPointParameters.nglPointParameterfvARB(pname, MemoryUtil.memAddress(params));
    }

    public static void glPointParameterfvARB(int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 3);
        }
        ARBPointParameters.nglPointParameterfvARB(pname, MemoryUtil.memAddress(params));
    }
}

