/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBShaderSubroutine {
    public static final int GL_ACTIVE_SUBROUTINES = 36325;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORMS = 36326;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 36423;
    public static final int GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 36424;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 36425;
    public static final int GL_MAX_SUBROUTINES = 36327;
    public static final int GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 36328;
    public static final int GL_NUM_COMPATIBLE_SUBROUTINES = 36426;
    public static final int GL_COMPATIBLE_SUBROUTINES = 36427;
    public final long GetSubroutineUniformLocation;
    public final long GetSubroutineIndex;
    public final long GetActiveSubroutineUniformiv;
    public final long GetActiveSubroutineUniformName;
    public final long GetActiveSubroutineName;
    public final long UniformSubroutinesuiv;
    public final long GetUniformSubroutineuiv;
    public final long GetProgramStageiv;

    protected ARBShaderSubroutine() {
        throw new UnsupportedOperationException();
    }

    public ARBShaderSubroutine(FunctionProvider provider) {
        this.GetSubroutineUniformLocation = provider.getFunctionAddress("glGetSubroutineUniformLocation");
        this.GetSubroutineIndex = provider.getFunctionAddress("glGetSubroutineIndex");
        this.GetActiveSubroutineUniformiv = provider.getFunctionAddress("glGetActiveSubroutineUniformiv");
        this.GetActiveSubroutineUniformName = provider.getFunctionAddress("glGetActiveSubroutineUniformName");
        this.GetActiveSubroutineName = provider.getFunctionAddress("glGetActiveSubroutineName");
        this.UniformSubroutinesuiv = provider.getFunctionAddress("glUniformSubroutinesuiv");
        this.GetUniformSubroutineuiv = provider.getFunctionAddress("glGetUniformSubroutineuiv");
        this.GetProgramStageiv = provider.getFunctionAddress("glGetProgramStageiv");
    }

    public static ARBShaderSubroutine getInstance() {
        return ARBShaderSubroutine.getInstance(GL.getCapabilities());
    }

    public static ARBShaderSubroutine getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBShaderSubroutine);
    }

    static ARBShaderSubroutine create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_shader_subroutine")) {
            return null;
        }
        ARBShaderSubroutine funcs = new ARBShaderSubroutine(provider);
        boolean supported = Checks.checkFunctions(funcs.GetSubroutineUniformLocation, funcs.GetSubroutineIndex, funcs.GetActiveSubroutineUniformiv, funcs.GetActiveSubroutineUniformName, funcs.GetActiveSubroutineName, funcs.UniformSubroutinesuiv, funcs.GetUniformSubroutineuiv, funcs.GetProgramStageiv);
        return GL.checkExtension("GL_ARB_shader_subroutine", funcs, supported);
    }

    public static int nglGetSubroutineUniformLocation(int program, int shadertype, long name) {
        long __functionAddress = ARBShaderSubroutine.getInstance().GetSubroutineUniformLocation;
        return JNI.callIIPI(__functionAddress, program, shadertype, name);
    }

    public static int glGetSubroutineUniformLocation(int program, int shadertype, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBShaderSubroutine.nglGetSubroutineUniformLocation(program, shadertype, MemoryUtil.memAddress(name));
    }

    public static int glGetSubroutineUniformLocation(int program, int shadertype, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return ARBShaderSubroutine.nglGetSubroutineUniformLocation(program, shadertype, __buffer.address(nameEncoded));
    }

    public static int nglGetSubroutineIndex(int program, int shadertype, long name) {
        long __functionAddress = ARBShaderSubroutine.getInstance().GetSubroutineIndex;
        return JNI.callIIPI(__functionAddress, program, shadertype, name);
    }

    public static int glGetSubroutineIndex(int program, int shadertype, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBShaderSubroutine.nglGetSubroutineIndex(program, shadertype, MemoryUtil.memAddress(name));
    }

    public static int glGetSubroutineIndex(int program, int shadertype, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return ARBShaderSubroutine.nglGetSubroutineIndex(program, shadertype, __buffer.address(nameEncoded));
    }

    public static void nglGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, long values) {
        long __functionAddress = ARBShaderSubroutine.getInstance().GetActiveSubroutineUniformiv;
        JNI.callIIIIPV(__functionAddress, program, shadertype, index, pname, values);
    }

    public static void glGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        ARBShaderSubroutine.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.memAddress(values));
    }

    public static void glGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        ARBShaderSubroutine.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.memAddress(values));
    }

    public static int glGetActiveSubroutineUniformi(int program, int shadertype, int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int values = __buffer.intParam();
        ARBShaderSubroutine.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, __buffer.address(values));
        return __buffer.intValue(values);
    }

    public static void nglGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize, long length, long name) {
        long __functionAddress = ARBShaderSubroutine.getInstance().GetActiveSubroutineUniformName;
        JNI.callIIIIPPV(__functionAddress, program, shadertype, index, bufsize, length, name);
    }

    public static void glGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize, ByteBuffer length, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufsize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ARBShaderSubroutine.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveSubroutineUniformName(int program, int shadertype, int index, IntBuffer length, ByteBuffer name) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBShaderSubroutine.nglGetActiveSubroutineUniformName(program, shadertype, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static String glGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufsize);
        ARBShaderSubroutine.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetActiveSubroutineUniformName(int program, int shadertype, int index) {
        int bufsize = ARBShaderSubroutine.glGetActiveSubroutineUniformi(program, shadertype, index, 35385);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufsize);
        ARBShaderSubroutine.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglGetActiveSubroutineName(int program, int shadertype, int index, int bufsize, long length, long name) {
        long __functionAddress = ARBShaderSubroutine.getInstance().GetActiveSubroutineName;
        JNI.callIIIIPPV(__functionAddress, program, shadertype, index, bufsize, length, name);
    }

    public static void glGetActiveSubroutineName(int program, int shadertype, int index, int bufsize, ByteBuffer length, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufsize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ARBShaderSubroutine.nglGetActiveSubroutineName(program, shadertype, index, bufsize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveSubroutineName(int program, int shadertype, int index, IntBuffer length, ByteBuffer name) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBShaderSubroutine.nglGetActiveSubroutineName(program, shadertype, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static String glGetActiveSubroutineName(int program, int shadertype, int index, int bufsize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufsize);
        ARBShaderSubroutine.nglGetActiveSubroutineName(program, shadertype, index, bufsize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetActiveSubroutineName(int program, int shadertype, int index) {
        int bufsize = ARBShaderSubroutine.glGetProgramStagei(program, shadertype, 36424);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufsize);
        ARBShaderSubroutine.nglGetActiveSubroutineName(program, shadertype, index, bufsize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglUniformSubroutinesuiv(int shadertype, int count, long indices) {
        long __functionAddress = ARBShaderSubroutine.getInstance().UniformSubroutinesuiv;
        JNI.callIIPV(__functionAddress, shadertype, count, indices);
    }

    public static void glUniformSubroutinesuiv(int shadertype, int count, ByteBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << 2);
        }
        ARBShaderSubroutine.nglUniformSubroutinesuiv(shadertype, count, MemoryUtil.memAddress(indices));
    }

    public static void glUniformSubroutinesuiv(int shadertype, IntBuffer indices) {
        ARBShaderSubroutine.nglUniformSubroutinesuiv(shadertype, indices.remaining(), MemoryUtil.memAddress(indices));
    }

    public static void glUniformSubroutinesui(int shadertype, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int indices = __buffer.intParam(index);
        ARBShaderSubroutine.nglUniformSubroutinesuiv(shadertype, 1, __buffer.address(indices));
    }

    public static void nglGetUniformSubroutineuiv(int shadertype, int location, long params) {
        long __functionAddress = ARBShaderSubroutine.getInstance().GetUniformSubroutineuiv;
        JNI.callIIPV(__functionAddress, shadertype, location, params);
    }

    public static void glGetUniformSubroutineuiv(int shadertype, int location, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBShaderSubroutine.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformSubroutineuiv(int shadertype, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderSubroutine.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.memAddress(params));
    }

    public static int glGetUniformSubroutineui(int shadertype, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBShaderSubroutine.nglGetUniformSubroutineuiv(shadertype, location, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetProgramStageiv(int program, int shadertype, int pname, long values) {
        long __functionAddress = ARBShaderSubroutine.getInstance().GetProgramStageiv;
        JNI.callIIIPV(__functionAddress, program, shadertype, pname, values);
    }

    public static void glGetProgramStageiv(int program, int shadertype, int pname, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        ARBShaderSubroutine.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.memAddress(values));
    }

    public static void glGetProgramStageiv(int program, int shadertype, int pname, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        ARBShaderSubroutine.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.memAddress(values));
    }

    public static int glGetProgramStagei(int program, int shadertype, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int values = __buffer.intParam();
        ARBShaderSubroutine.nglGetProgramStageiv(program, shadertype, pname, __buffer.address(values));
        return __buffer.intValue(values);
    }
}

