/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class ARBShadingLanguageInclude {
    public static final int GL_SHADER_INCLUDE_ARB = 36270;
    public static final int GL_NAMED_STRING_LENGTH_ARB = 36329;
    public static final int GL_NAMED_STRING_TYPE_ARB = 36330;
    public final long NamedStringARB;
    public final long DeleteNamedStringARB;
    public final long CompileShaderIncludeARB;
    public final long IsNamedStringARB;
    public final long GetNamedStringARB;
    public final long GetNamedStringivARB;

    protected ARBShadingLanguageInclude() {
        throw new UnsupportedOperationException();
    }

    public ARBShadingLanguageInclude(FunctionProvider provider) {
        this.NamedStringARB = provider.getFunctionAddress("glNamedStringARB");
        this.DeleteNamedStringARB = provider.getFunctionAddress("glDeleteNamedStringARB");
        this.CompileShaderIncludeARB = provider.getFunctionAddress("glCompileShaderIncludeARB");
        this.IsNamedStringARB = provider.getFunctionAddress("glIsNamedStringARB");
        this.GetNamedStringARB = provider.getFunctionAddress("glGetNamedStringARB");
        this.GetNamedStringivARB = provider.getFunctionAddress("glGetNamedStringivARB");
    }

    public static ARBShadingLanguageInclude getInstance() {
        return ARBShadingLanguageInclude.getInstance(GL.getCapabilities());
    }

    public static ARBShadingLanguageInclude getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBShadingLanguageInclude);
    }

    static ARBShadingLanguageInclude create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_shading_language_include")) {
            return null;
        }
        ARBShadingLanguageInclude funcs = new ARBShadingLanguageInclude(provider);
        boolean supported = Checks.checkFunctions(funcs.NamedStringARB, funcs.DeleteNamedStringARB, funcs.CompileShaderIncludeARB, funcs.IsNamedStringARB, funcs.GetNamedStringARB, funcs.GetNamedStringivARB);
        return GL.checkExtension("GL_ARB_shading_language_include", funcs, supported);
    }

    public static void nglNamedStringARB(int type, int namelen, long name, int stringlen, long string) {
        long __functionAddress = ARBShadingLanguageInclude.getInstance().NamedStringARB;
        JNI.callIIPIPV(__functionAddress, type, namelen, name, stringlen, string);
    }

    public static void glNamedStringARB(int type, int namelen, ByteBuffer name, int stringlen, ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, namelen);
            Checks.checkBuffer((Buffer)string, stringlen);
        }
        ARBShadingLanguageInclude.nglNamedStringARB(type, namelen, MemoryUtil.memAddress(name), stringlen, MemoryUtil.memAddress(string));
    }

    public static void glNamedStringARB(int type, ByteBuffer name, ByteBuffer string) {
        ARBShadingLanguageInclude.nglNamedStringARB(type, name.remaining(), MemoryUtil.memAddress(name), string.remaining(), MemoryUtil.memAddress(string));
    }

    public static void glNamedStringARB(int type, CharSequence name, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        int stringEncoded = __buffer.stringParamUTF8(string, false);
        int stringEncodedLen = __buffer.getOffset() - stringEncoded;
        ARBShadingLanguageInclude.nglNamedStringARB(type, nameEncodedLen, __buffer.address(nameEncoded), stringEncodedLen, __buffer.address(stringEncoded));
    }

    public static void nglDeleteNamedStringARB(int namelen, long name) {
        long __functionAddress = ARBShadingLanguageInclude.getInstance().DeleteNamedStringARB;
        JNI.callIPV(__functionAddress, namelen, name);
    }

    public static void glDeleteNamedStringARB(int namelen, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, namelen);
        }
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(namelen, MemoryUtil.memAddress(name));
    }

    public static void glDeleteNamedStringARB(ByteBuffer name) {
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(name.remaining(), MemoryUtil.memAddress(name));
    }

    public static void glDeleteNamedStringARB(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        ARBShadingLanguageInclude.nglDeleteNamedStringARB(nameEncodedLen, __buffer.address(nameEncoded));
    }

    public static void nglCompileShaderIncludeARB(int shader, int count, long path, long length) {
        long __functionAddress = ARBShadingLanguageInclude.getInstance().CompileShaderIncludeARB;
        JNI.callIIPPV(__functionAddress, shader, count, path, length);
    }

    public static void glCompileShaderIncludeARB(int shader, int count, ByteBuffer path, ByteBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)path, count << Pointer.POINTER_SHIFT);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, count << 2);
            }
        }
        ARBShadingLanguageInclude.nglCompileShaderIncludeARB(shader, count, MemoryUtil.memAddress(path), MemoryUtil.memAddressSafe(length));
    }

    public static void glCompileShaderIncludeARB(int shader, PointerBuffer path, IntBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, path.remaining());
        }
        ARBShadingLanguageInclude.nglCompileShaderIncludeARB(shader, path.remaining(), MemoryUtil.memAddress(path), MemoryUtil.memAddressSafe(length));
    }

    public static boolean nglIsNamedStringARB(int namelen, long name) {
        long __functionAddress = ARBShadingLanguageInclude.getInstance().IsNamedStringARB;
        return JNI.callIPZ(__functionAddress, namelen, name);
    }

    public static boolean glIsNamedStringARB(int namelen, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, namelen);
        }
        return ARBShadingLanguageInclude.nglIsNamedStringARB(namelen, MemoryUtil.memAddress(name));
    }

    public static boolean glIsNamedStringARB(ByteBuffer name) {
        return ARBShadingLanguageInclude.nglIsNamedStringARB(name.remaining(), MemoryUtil.memAddress(name));
    }

    public static boolean glIsNamedStringARB(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        return ARBShadingLanguageInclude.nglIsNamedStringARB(nameEncodedLen, __buffer.address(nameEncoded));
    }

    public static void nglGetNamedStringARB(int namelen, long name, int bufSize, long stringlen, long string) {
        long __functionAddress = ARBShadingLanguageInclude.getInstance().GetNamedStringARB;
        JNI.callIPIPPV(__functionAddress, namelen, name, bufSize, stringlen, string);
    }

    public static void glGetNamedStringARB(int namelen, ByteBuffer name, int bufSize, ByteBuffer stringlen, ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, namelen);
            Checks.checkBuffer((Buffer)string, bufSize);
            if (stringlen != null) {
                Checks.checkBuffer((Buffer)stringlen, 4);
            }
        }
        ARBShadingLanguageInclude.nglGetNamedStringARB(namelen, MemoryUtil.memAddress(name), bufSize, MemoryUtil.memAddressSafe(stringlen), MemoryUtil.memAddress(string));
    }

    public static void glGetNamedStringARB(ByteBuffer name, IntBuffer stringlen, ByteBuffer string) {
        if (Checks.CHECKS && stringlen != null) {
            Checks.checkBuffer((Buffer)stringlen, 1);
        }
        ARBShadingLanguageInclude.nglGetNamedStringARB(name.remaining(), MemoryUtil.memAddress(name), string.remaining(), MemoryUtil.memAddressSafe(stringlen), MemoryUtil.memAddress(string));
    }

    public static void glGetNamedStringARB(CharSequence name, IntBuffer stringlen, ByteBuffer string) {
        if (Checks.CHECKS && stringlen != null) {
            Checks.checkBuffer((Buffer)stringlen, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        ARBShadingLanguageInclude.nglGetNamedStringARB(nameEncodedLen, __buffer.address(nameEncoded), string.remaining(), MemoryUtil.memAddressSafe(stringlen), MemoryUtil.memAddress(string));
    }

    public static String glGetNamedStringARB(CharSequence name, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        int stringlen = __buffer.intParam();
        int string = __buffer.bufferParam(bufSize);
        ARBShadingLanguageInclude.nglGetNamedStringARB(nameEncodedLen, __buffer.address(nameEncoded), bufSize, __buffer.address(stringlen), __buffer.address(string));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(stringlen), string);
    }

    public static String glGetNamedStringARB(CharSequence name) {
        int bufSize = ARBShadingLanguageInclude.glGetNamedStringiARB(name, 36329);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        int stringlen = __buffer.intParam();
        int string = __buffer.bufferParam(bufSize);
        ARBShadingLanguageInclude.nglGetNamedStringARB(nameEncodedLen, __buffer.address(nameEncoded), bufSize, __buffer.address(stringlen), __buffer.address(string));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(stringlen), string);
    }

    public static void nglGetNamedStringivARB(int namelen, long name, int pname, long params) {
        long __functionAddress = ARBShadingLanguageInclude.getInstance().GetNamedStringivARB;
        JNI.callIPIPV(__functionAddress, namelen, name, pname, params);
    }

    public static void glGetNamedStringivARB(int namelen, ByteBuffer name, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, namelen);
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBShadingLanguageInclude.nglGetNamedStringivARB(namelen, MemoryUtil.memAddress(name), pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedStringivARB(ByteBuffer name, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShadingLanguageInclude.nglGetNamedStringivARB(name.remaining(), MemoryUtil.memAddress(name), pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedStringivARB(CharSequence name, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        ARBShadingLanguageInclude.nglGetNamedStringivARB(nameEncodedLen, __buffer.address(nameEncoded), pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedStringiARB(CharSequence name, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, false);
        int nameEncodedLen = __buffer.getOffset() - nameEncoded;
        int params = __buffer.intParam();
        ARBShadingLanguageInclude.nglGetNamedStringivARB(nameEncodedLen, __buffer.address(nameEncoded), pname, __buffer.address(params));
        return __buffer.intValue(params);
    }
}

