/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBTextureMultisample {
    public static final int GL_SAMPLE_POSITION = 36432;
    public static final int GL_SAMPLE_MASK = 36433;
    public static final int GL_SAMPLE_MASK_VALUE = 36434;
    public static final int GL_TEXTURE_2D_MULTISAMPLE = 37120;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE = 37121;
    public static final int GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 37122;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 37123;
    public static final int GL_MAX_SAMPLE_MASK_WORDS = 36441;
    public static final int GL_MAX_COLOR_TEXTURE_SAMPLES = 37134;
    public static final int GL_MAX_DEPTH_TEXTURE_SAMPLES = 37135;
    public static final int GL_MAX_INTEGER_SAMPLES = 37136;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE = 37124;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 37125;
    public static final int GL_TEXTURE_SAMPLES = 37126;
    public static final int GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 37127;
    public static final int GL_SAMPLER_2D_MULTISAMPLE = 37128;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE = 37129;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 37130;
    public static final int GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 37131;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37132;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37133;
    public final long TexImage2DMultisample;
    public final long TexImage3DMultisample;
    public final long GetMultisamplefv;
    public final long SampleMaski;

    protected ARBTextureMultisample() {
        throw new UnsupportedOperationException();
    }

    public ARBTextureMultisample(FunctionProvider provider) {
        this.TexImage2DMultisample = provider.getFunctionAddress("glTexImage2DMultisample");
        this.TexImage3DMultisample = provider.getFunctionAddress("glTexImage3DMultisample");
        this.GetMultisamplefv = provider.getFunctionAddress("glGetMultisamplefv");
        this.SampleMaski = provider.getFunctionAddress("glSampleMaski");
    }

    public static ARBTextureMultisample getInstance() {
        return ARBTextureMultisample.getInstance(GL.getCapabilities());
    }

    public static ARBTextureMultisample getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBTextureMultisample);
    }

    static ARBTextureMultisample create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_texture_multisample")) {
            return null;
        }
        ARBTextureMultisample funcs = new ARBTextureMultisample(provider);
        boolean supported = Checks.checkFunctions(funcs.TexImage2DMultisample, funcs.TexImage3DMultisample, funcs.GetMultisamplefv, funcs.SampleMaski);
        return GL.checkExtension("GL_ARB_texture_multisample", funcs, supported);
    }

    public static void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        long __functionAddress = ARBTextureMultisample.getInstance().TexImage2DMultisample;
        JNI.callIIIIIZV(__functionAddress, target, samples, internalformat, width, height, fixedsamplelocations);
    }

    public static void glTexImage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations) {
        long __functionAddress = ARBTextureMultisample.getInstance().TexImage3DMultisample;
        JNI.callIIIIIIZV(__functionAddress, target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }

    public static void nglGetMultisamplefv(int pname, int index, long val) {
        long __functionAddress = ARBTextureMultisample.getInstance().GetMultisamplefv;
        JNI.callIIPV(__functionAddress, pname, index, val);
    }

    public static void glGetMultisamplefv(int pname, int index, ByteBuffer val) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)val, 4);
        }
        ARBTextureMultisample.nglGetMultisamplefv(pname, index, MemoryUtil.memAddress(val));
    }

    public static void glGetMultisamplefv(int pname, int index, FloatBuffer val) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)val, 1);
        }
        ARBTextureMultisample.nglGetMultisamplefv(pname, index, MemoryUtil.memAddress(val));
    }

    public static float glGetMultisamplef(int pname, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int val = __buffer.floatParam();
        ARBTextureMultisample.nglGetMultisamplefv(pname, index, __buffer.address(val));
        return __buffer.floatValue(val);
    }

    public static void glSampleMaski(int index, int mask) {
        long __functionAddress = ARBTextureMultisample.getInstance().SampleMaski;
        JNI.callIIV(__functionAddress, index, mask);
    }
}

