/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBViewportArray {
    public static final int GL_MAX_VIEWPORTS = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE = 33373;
    public static final int GL_LAYER_PROVOKING_VERTEX = 33374;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX = 33375;
    public static final int GL_UNDEFINED_VERTEX = 33376;
    public final long ViewportArrayv;
    public final long ViewportIndexedf;
    public final long ViewportIndexedfv;
    public final long ScissorArrayv;
    public final long ScissorIndexed;
    public final long ScissorIndexedv;
    public final long DepthRangeArrayv;
    public final long DepthRangeIndexed;
    public final long GetFloati_v;
    public final long GetDoublei_v;

    protected ARBViewportArray() {
        throw new UnsupportedOperationException();
    }

    public ARBViewportArray(FunctionProvider provider) {
        this.ViewportArrayv = provider.getFunctionAddress("glViewportArrayv");
        this.ViewportIndexedf = provider.getFunctionAddress("glViewportIndexedf");
        this.ViewportIndexedfv = provider.getFunctionAddress("glViewportIndexedfv");
        this.ScissorArrayv = provider.getFunctionAddress("glScissorArrayv");
        this.ScissorIndexed = provider.getFunctionAddress("glScissorIndexed");
        this.ScissorIndexedv = provider.getFunctionAddress("glScissorIndexedv");
        this.DepthRangeArrayv = provider.getFunctionAddress("glDepthRangeArrayv");
        this.DepthRangeIndexed = provider.getFunctionAddress("glDepthRangeIndexed");
        this.GetFloati_v = provider.getFunctionAddress("glGetFloati_v");
        this.GetDoublei_v = provider.getFunctionAddress("glGetDoublei_v");
    }

    public static ARBViewportArray getInstance() {
        return ARBViewportArray.getInstance(GL.getCapabilities());
    }

    public static ARBViewportArray getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBViewportArray);
    }

    static ARBViewportArray create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_viewport_array")) {
            return null;
        }
        ARBViewportArray funcs = new ARBViewportArray(provider);
        boolean supported = Checks.checkFunctions(funcs.ViewportArrayv, funcs.ViewportIndexedf, funcs.ViewportIndexedfv, funcs.ScissorArrayv, funcs.ScissorIndexed, funcs.ScissorIndexedv, funcs.DepthRangeArrayv, funcs.DepthRangeIndexed, funcs.GetFloati_v, funcs.GetDoublei_v);
        return GL.checkExtension("GL_ARB_viewport_array", funcs, supported);
    }

    public static void nglViewportArrayv(int first, int count, long v) {
        long __functionAddress = ARBViewportArray.getInstance().ViewportArrayv;
        JNI.callIIPV(__functionAddress, first, count, v);
    }

    public static void glViewportArrayv(int first, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 2 << 2);
        }
        ARBViewportArray.nglViewportArrayv(first, count, MemoryUtil.memAddress(v));
    }

    public static void glViewportArrayv(int first, FloatBuffer v) {
        ARBViewportArray.nglViewportArrayv(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static void glViewportIndexedf(int index, float x, float y, float w, float h) {
        long __functionAddress = ARBViewportArray.getInstance().ViewportIndexedf;
        JNI.callIFFFFV(__functionAddress, index, x, y, w, h);
    }

    public static void nglViewportIndexedfv(int index, long v) {
        long __functionAddress = ARBViewportArray.getInstance().ViewportIndexedfv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glViewportIndexedfv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        ARBViewportArray.nglViewportIndexedfv(index, MemoryUtil.memAddress(v));
    }

    public static void glViewportIndexedfv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        ARBViewportArray.nglViewportIndexedfv(index, MemoryUtil.memAddress(v));
    }

    public static void nglScissorArrayv(int first, int count, long v) {
        long __functionAddress = ARBViewportArray.getInstance().ScissorArrayv;
        JNI.callIIPV(__functionAddress, first, count, v);
    }

    public static void glScissorArrayv(int first, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 2 << 2);
        }
        ARBViewportArray.nglScissorArrayv(first, count, MemoryUtil.memAddress(v));
    }

    public static void glScissorArrayv(int first, IntBuffer v) {
        ARBViewportArray.nglScissorArrayv(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static void glScissorIndexed(int index, int left, int bottom, int width, int height) {
        long __functionAddress = ARBViewportArray.getInstance().ScissorIndexed;
        JNI.callIIIIIV(__functionAddress, index, left, bottom, width, height);
    }

    public static void nglScissorIndexedv(int index, long v) {
        long __functionAddress = ARBViewportArray.getInstance().ScissorIndexedv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glScissorIndexedv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        ARBViewportArray.nglScissorIndexedv(index, MemoryUtil.memAddress(v));
    }

    public static void glScissorIndexedv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        ARBViewportArray.nglScissorIndexedv(index, MemoryUtil.memAddress(v));
    }

    public static void nglDepthRangeArrayv(int first, int count, long v) {
        long __functionAddress = ARBViewportArray.getInstance().DepthRangeArrayv;
        JNI.callIIPV(__functionAddress, first, count, v);
    }

    public static void glDepthRangeArrayv(int first, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 1 << 3);
        }
        ARBViewportArray.nglDepthRangeArrayv(first, count, MemoryUtil.memAddress(v));
    }

    public static void glDepthRangeArrayv(int first, DoubleBuffer v) {
        ARBViewportArray.nglDepthRangeArrayv(first, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static void glDepthRangeIndexed(int index, double zNear, double zFar) {
        long __functionAddress = ARBViewportArray.getInstance().DepthRangeIndexed;
        JNI.callIDDV(__functionAddress, index, zNear, zFar);
    }

    public static void nglGetFloati_v(int target, int index, long data) {
        long __functionAddress = ARBViewportArray.getInstance().GetFloati_v;
        JNI.callIIPV(__functionAddress, target, index, data);
    }

    public static void glGetFloati_v(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 4);
        }
        ARBViewportArray.nglGetFloati_v(target, index, MemoryUtil.memAddress(data));
    }

    public static void glGetFloati_v(int target, int index, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        ARBViewportArray.nglGetFloati_v(target, index, MemoryUtil.memAddress(data));
    }

    public static float glGetFloati(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.floatParam();
        ARBViewportArray.nglGetFloati_v(target, index, __buffer.address(data));
        return __buffer.floatValue(data);
    }

    public static void nglGetDoublei_v(int target, int index, long data) {
        long __functionAddress = ARBViewportArray.getInstance().GetDoublei_v;
        JNI.callIIPV(__functionAddress, target, index, data);
    }

    public static void glGetDoublei_v(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 8);
        }
        ARBViewportArray.nglGetDoublei_v(target, index, MemoryUtil.memAddress(data));
    }

    public static void glGetDoublei_v(int target, int index, DoubleBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        ARBViewportArray.nglGetDoublei_v(target, index, MemoryUtil.memAddress(data));
    }

    public static double glGetDoublei(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.doubleParam();
        ARBViewportArray.nglGetDoublei_v(target, index, __buffer.address(data));
        return __buffer.doubleValue(data);
    }
}

