/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBWindowPos {
    public final long WindowPos2iARB;
    public final long WindowPos2sARB;
    public final long WindowPos2fARB;
    public final long WindowPos2dARB;
    public final long WindowPos2ivARB;
    public final long WindowPos2svARB;
    public final long WindowPos2fvARB;
    public final long WindowPos2dvARB;
    public final long WindowPos3iARB;
    public final long WindowPos3sARB;
    public final long WindowPos3fARB;
    public final long WindowPos3dARB;
    public final long WindowPos3ivARB;
    public final long WindowPos3svARB;
    public final long WindowPos3fvARB;
    public final long WindowPos3dvARB;

    protected ARBWindowPos() {
        throw new UnsupportedOperationException();
    }

    public ARBWindowPos(FunctionProvider provider) {
        this.WindowPos2iARB = provider.getFunctionAddress("glWindowPos2iARB");
        this.WindowPos2sARB = provider.getFunctionAddress("glWindowPos2sARB");
        this.WindowPos2fARB = provider.getFunctionAddress("glWindowPos2fARB");
        this.WindowPos2dARB = provider.getFunctionAddress("glWindowPos2dARB");
        this.WindowPos2ivARB = provider.getFunctionAddress("glWindowPos2ivARB");
        this.WindowPos2svARB = provider.getFunctionAddress("glWindowPos2svARB");
        this.WindowPos2fvARB = provider.getFunctionAddress("glWindowPos2fvARB");
        this.WindowPos2dvARB = provider.getFunctionAddress("glWindowPos2dvARB");
        this.WindowPos3iARB = provider.getFunctionAddress("glWindowPos3iARB");
        this.WindowPos3sARB = provider.getFunctionAddress("glWindowPos3sARB");
        this.WindowPos3fARB = provider.getFunctionAddress("glWindowPos3fARB");
        this.WindowPos3dARB = provider.getFunctionAddress("glWindowPos3dARB");
        this.WindowPos3ivARB = provider.getFunctionAddress("glWindowPos3ivARB");
        this.WindowPos3svARB = provider.getFunctionAddress("glWindowPos3svARB");
        this.WindowPos3fvARB = provider.getFunctionAddress("glWindowPos3fvARB");
        this.WindowPos3dvARB = provider.getFunctionAddress("glWindowPos3dvARB");
    }

    public static ARBWindowPos getInstance() {
        return ARBWindowPos.getInstance(GL.getCapabilities());
    }

    public static ARBWindowPos getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBWindowPos);
    }

    static ARBWindowPos create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_window_pos")) {
            return null;
        }
        ARBWindowPos funcs = new ARBWindowPos(provider);
        boolean supported = Checks.checkFunctions(funcs.WindowPos2iARB, funcs.WindowPos2sARB, funcs.WindowPos2fARB, funcs.WindowPos2dARB, funcs.WindowPos2ivARB, funcs.WindowPos2svARB, funcs.WindowPos2fvARB, funcs.WindowPos2dvARB, funcs.WindowPos3iARB, funcs.WindowPos3sARB, funcs.WindowPos3fARB, funcs.WindowPos3dARB, funcs.WindowPos3ivARB, funcs.WindowPos3svARB, funcs.WindowPos3fvARB, funcs.WindowPos3dvARB);
        return GL.checkExtension("GL_ARB_window_pos", funcs, supported);
    }

    public static void glWindowPos2iARB(int x, int y) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2iARB;
        JNI.callIIV(__functionAddress, x, y);
    }

    public static void glWindowPos2sARB(short x, short y) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2sARB;
        JNI.callSSV(__functionAddress, x, y);
    }

    public static void glWindowPos2fARB(float x, float y) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2fARB;
        JNI.callFFV(__functionAddress, x, y);
    }

    public static void glWindowPos2dARB(double x, double y) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2dARB;
        JNI.callDDV(__functionAddress, x, y);
    }

    public static void nglWindowPos2ivARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2ivARB;
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos2ivARB(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 8);
        }
        ARBWindowPos.nglWindowPos2ivARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos2ivARB(IntBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 2);
        }
        ARBWindowPos.nglWindowPos2ivARB(MemoryUtil.memAddress(p));
    }

    public static void nglWindowPos2svARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2svARB;
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos2svARB(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 4);
        }
        ARBWindowPos.nglWindowPos2svARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos2svARB(ShortBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 2);
        }
        ARBWindowPos.nglWindowPos2svARB(MemoryUtil.memAddress(p));
    }

    public static void nglWindowPos2fvARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2fvARB;
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos2fvARB(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 8);
        }
        ARBWindowPos.nglWindowPos2fvARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos2fvARB(FloatBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 2);
        }
        ARBWindowPos.nglWindowPos2fvARB(MemoryUtil.memAddress(p));
    }

    public static void nglWindowPos2dvARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2dvARB;
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos2dvARB(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 16);
        }
        ARBWindowPos.nglWindowPos2dvARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos2dvARB(DoubleBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 2);
        }
        ARBWindowPos.nglWindowPos2dvARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3iARB(int x, int y, int z) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3iARB;
        JNI.callIIIV(__functionAddress, x, y, z);
    }

    public static void glWindowPos3sARB(short x, short y, short z) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3sARB;
        JNI.callSSSV(__functionAddress, x, y, z);
    }

    public static void glWindowPos3fARB(float x, float y, float z) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3fARB;
        JNI.callFFFV(__functionAddress, x, y, z);
    }

    public static void glWindowPos3dARB(double x, double y, double z) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3dARB;
        JNI.callDDDV(__functionAddress, x, y, z);
    }

    public static void nglWindowPos3ivARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3ivARB;
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos3ivARB(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 12);
        }
        ARBWindowPos.nglWindowPos3ivARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3ivARB(IntBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 3);
        }
        ARBWindowPos.nglWindowPos3ivARB(MemoryUtil.memAddress(p));
    }

    public static void nglWindowPos3svARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3svARB;
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos3svARB(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 6);
        }
        ARBWindowPos.nglWindowPos3svARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3svARB(ShortBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 3);
        }
        ARBWindowPos.nglWindowPos3svARB(MemoryUtil.memAddress(p));
    }

    public static void nglWindowPos3fvARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3fvARB;
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos3fvARB(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 12);
        }
        ARBWindowPos.nglWindowPos3fvARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3fvARB(FloatBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 3);
        }
        ARBWindowPos.nglWindowPos3fvARB(MemoryUtil.memAddress(p));
    }

    public static void nglWindowPos3dvARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3dvARB;
        JNI.callPV(__functionAddress, p);
    }

    public static void glWindowPos3dvARB(ByteBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 24);
        }
        ARBWindowPos.nglWindowPos3dvARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3dvARB(DoubleBuffer p) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)p, 3);
        }
        ARBWindowPos.nglWindowPos3dvARB(MemoryUtil.memAddress(p));
    }
}

