/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDrawBuffers2 {
    public final long ColorMaskIndexedEXT;
    public final long GetBooleanIndexedvEXT;
    public final long GetIntegerIndexedvEXT;
    public final long EnableIndexedEXT;
    public final long DisableIndexedEXT;
    public final long IsEnabledIndexedEXT;

    protected EXTDrawBuffers2() {
        throw new UnsupportedOperationException();
    }

    public EXTDrawBuffers2(FunctionProvider provider) {
        this.ColorMaskIndexedEXT = provider.getFunctionAddress("glColorMaskIndexedEXT");
        this.GetBooleanIndexedvEXT = provider.getFunctionAddress("glGetBooleanIndexedvEXT");
        this.GetIntegerIndexedvEXT = provider.getFunctionAddress("glGetIntegerIndexedvEXT");
        this.EnableIndexedEXT = provider.getFunctionAddress("glEnableIndexedEXT");
        this.DisableIndexedEXT = provider.getFunctionAddress("glDisableIndexedEXT");
        this.IsEnabledIndexedEXT = provider.getFunctionAddress("glIsEnabledIndexedEXT");
    }

    public static EXTDrawBuffers2 getInstance() {
        return EXTDrawBuffers2.getInstance(GL.getCapabilities());
    }

    public static EXTDrawBuffers2 getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTDrawBuffers2);
    }

    static EXTDrawBuffers2 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_draw_buffers2")) {
            return null;
        }
        EXTDrawBuffers2 funcs = new EXTDrawBuffers2(provider);
        boolean supported = Checks.checkFunctions(funcs.ColorMaskIndexedEXT, funcs.GetBooleanIndexedvEXT, funcs.GetIntegerIndexedvEXT, funcs.EnableIndexedEXT, funcs.DisableIndexedEXT, funcs.IsEnabledIndexedEXT);
        return GL.checkExtension("GL_EXT_draw_buffers2", funcs, supported);
    }

    public static void glColorMaskIndexedEXT(int index, boolean r, boolean g, boolean b, boolean a) {
        long __functionAddress = EXTDrawBuffers2.getInstance().ColorMaskIndexedEXT;
        JNI.callIZZZZV(__functionAddress, index, r, g, b, a);
    }

    public static void nglGetBooleanIndexedvEXT(int target, int index, long data) {
        long __functionAddress = EXTDrawBuffers2.getInstance().GetBooleanIndexedvEXT;
        JNI.callIIPV(__functionAddress, target, index, data);
    }

    public static void glGetBooleanIndexedvEXT(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        EXTDrawBuffers2.nglGetBooleanIndexedvEXT(target, index, MemoryUtil.memAddress(data));
    }

    public static boolean glGetBooleanIndexedEXT(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.booleanParam();
        EXTDrawBuffers2.nglGetBooleanIndexedvEXT(target, index, __buffer.address(data));
        return __buffer.booleanValue(data);
    }

    public static void nglGetIntegerIndexedvEXT(int target, int index, long data) {
        long __functionAddress = EXTDrawBuffers2.getInstance().GetIntegerIndexedvEXT;
        JNI.callIIPV(__functionAddress, target, index, data);
    }

    public static void glGetIntegerIndexedvEXT(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 4);
        }
        EXTDrawBuffers2.nglGetIntegerIndexedvEXT(target, index, MemoryUtil.memAddress(data));
    }

    public static void glGetIntegerIndexedvEXT(int target, int index, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        EXTDrawBuffers2.nglGetIntegerIndexedvEXT(target, index, MemoryUtil.memAddress(data));
    }

    public static int glGetIntegerIndexedEXT(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.intParam();
        EXTDrawBuffers2.nglGetIntegerIndexedvEXT(target, index, __buffer.address(data));
        return __buffer.intValue(data);
    }

    public static void glEnableIndexedEXT(int target, int index) {
        long __functionAddress = EXTDrawBuffers2.getInstance().EnableIndexedEXT;
        JNI.callIIV(__functionAddress, target, index);
    }

    public static void glDisableIndexedEXT(int target, int index) {
        long __functionAddress = EXTDrawBuffers2.getInstance().DisableIndexedEXT;
        JNI.callIIV(__functionAddress, target, index);
    }

    public static boolean glIsEnabledIndexedEXT(int target, int index) {
        long __functionAddress = EXTDrawBuffers2.getInstance().IsEnabledIndexedEXT;
        return JNI.callIIZ(__functionAddress, target, index);
    }
}

