/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GL45 {
    public static final int GL_NEGATIVE_ONE_TO_ONE = 37726;
    public static final int GL_ZERO_TO_ONE = 37727;
    public static final int GL_CLIP_ORIGIN = 37724;
    public static final int GL_CLIP_DEPTH_MODE = 37725;
    public static final int GL_QUERY_WAIT_INVERTED = 36375;
    public static final int GL_QUERY_NO_WAIT_INVERTED = 36376;
    public static final int GL_QUERY_BY_REGION_WAIT_INVERTED = 36377;
    public static final int GL_QUERY_BY_REGION_NO_WAIT_INVERTED = 36378;
    public static final int GL_MAX_CULL_DISTANCES = 33529;
    public static final int GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES = 33530;
    public static final int GL_TEXTURE_TARGET = 4102;
    public static final int GL_QUERY_TARGET = 33514;
    public static final int GL_CONTEXT_RELEASE_BEHAVIOR = 33531;
    public static final int GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = 33532;
    public static final int GL_GUILTY_CONTEXT_RESET = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET = 33365;
    public static final int GL_RESET_NOTIFICATION_STRATEGY = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET = 33362;
    public static final int GL_NO_RESET_NOTIFICATION = 33377;
    public static final int GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT = 4;
    public static final int GL_CONTEXT_LOST = 1287;
    public final long ClipControl;
    public final long CreateTransformFeedbacks;
    public final long TransformFeedbackBufferBase;
    public final long TransformFeedbackBufferRange;
    public final long GetTransformFeedbackiv;
    public final long GetTransformFeedbacki_v;
    public final long GetTransformFeedbacki64_v;
    public final long CreateBuffers;
    public final long NamedBufferStorage;
    public final long NamedBufferData;
    public final long NamedBufferSubData;
    public final long CopyNamedBufferSubData;
    public final long ClearNamedBufferData;
    public final long ClearNamedBufferSubData;
    public final long MapNamedBuffer;
    public final long MapNamedBufferRange;
    public final long UnmapNamedBuffer;
    public final long FlushMappedNamedBufferRange;
    public final long GetNamedBufferParameteriv;
    public final long GetNamedBufferParameteri64v;
    public final long GetNamedBufferPointerv;
    public final long GetNamedBufferSubData;
    public final long CreateFramebuffers;
    public final long NamedFramebufferRenderbuffer;
    public final long NamedFramebufferParameteri;
    public final long NamedFramebufferTexture;
    public final long NamedFramebufferTextureLayer;
    public final long NamedFramebufferDrawBuffer;
    public final long NamedFramebufferDrawBuffers;
    public final long NamedFramebufferReadBuffer;
    public final long InvalidateNamedFramebufferData;
    public final long InvalidateNamedFramebufferSubData;
    public final long ClearNamedFramebufferiv;
    public final long ClearNamedFramebufferuiv;
    public final long ClearNamedFramebufferfv;
    public final long ClearNamedFramebufferfi;
    public final long BlitNamedFramebuffer;
    public final long CheckNamedFramebufferStatus;
    public final long GetNamedFramebufferParameteriv;
    public final long GetNamedFramebufferAttachmentParameteriv;
    public final long CreateRenderbuffers;
    public final long NamedRenderbufferStorage;
    public final long NamedRenderbufferStorageMultisample;
    public final long GetNamedRenderbufferParameteriv;
    public final long CreateTextures;
    public final long TextureBuffer;
    public final long TextureBufferRange;
    public final long TextureStorage1D;
    public final long TextureStorage2D;
    public final long TextureStorage3D;
    public final long TextureStorage2DMultisample;
    public final long TextureStorage3DMultisample;
    public final long TextureSubImage1D;
    public final long TextureSubImage2D;
    public final long TextureSubImage3D;
    public final long CompressedTextureSubImage1D;
    public final long CompressedTextureSubImage2D;
    public final long CompressedTextureSubImage3D;
    public final long CopyTextureSubImage1D;
    public final long CopyTextureSubImage2D;
    public final long CopyTextureSubImage3D;
    public final long TextureParameterf;
    public final long TextureParameterfv;
    public final long TextureParameteri;
    public final long TextureParameterIiv;
    public final long TextureParameterIuiv;
    public final long TextureParameteriv;
    public final long GenerateTextureMipmap;
    public final long BindTextureUnit;
    public final long GetTextureImage;
    public final long GetCompressedTextureImage;
    public final long GetTextureLevelParameterfv;
    public final long GetTextureLevelParameteriv;
    public final long GetTextureParameterfv;
    public final long GetTextureParameterIiv;
    public final long GetTextureParameterIuiv;
    public final long GetTextureParameteriv;
    public final long CreateVertexArrays;
    public final long DisableVertexArrayAttrib;
    public final long EnableVertexArrayAttrib;
    public final long VertexArrayElementBuffer;
    public final long VertexArrayVertexBuffer;
    public final long VertexArrayVertexBuffers;
    public final long VertexArrayAttribFormat;
    public final long VertexArrayAttribIFormat;
    public final long VertexArrayAttribLFormat;
    public final long VertexArrayAttribBinding;
    public final long VertexArrayBindingDivisor;
    public final long GetVertexArrayiv;
    public final long GetVertexArrayIndexediv;
    public final long GetVertexArrayIndexed64iv;
    public final long CreateSamplers;
    public final long CreateProgramPipelines;
    public final long CreateQueries;
    public final long GetQueryBufferObjectiv;
    public final long GetQueryBufferObjectuiv;
    public final long GetQueryBufferObjecti64v;
    public final long GetQueryBufferObjectui64v;
    public final long MemoryBarrierByRegion;
    public final long GetTextureSubImage;
    public final long GetCompressedTextureSubImage;
    public final long TextureBarrier;
    public final long GetGraphicsResetStatus;
    public final long GetnMapdv;
    public final long GetnMapfv;
    public final long GetnMapiv;
    public final long GetnPixelMapfv;
    public final long GetnPixelMapuiv;
    public final long GetnPixelMapusv;
    public final long GetnPolygonStipple;
    public final long GetnTexImage;
    public final long ReadnPixels;
    public final long GetnColorTable;
    public final long GetnConvolutionFilter;
    public final long GetnSeparableFilter;
    public final long GetnHistogram;
    public final long GetnMinmax;
    public final long GetnCompressedTexImage;
    public final long GetnUniformfv;
    public final long GetnUniformdv;
    public final long GetnUniformiv;
    public final long GetnUniformuiv;

    protected GL45() {
        throw new UnsupportedOperationException();
    }

    public GL45(FunctionProvider provider) {
        this.ClipControl = provider.getFunctionAddress("glClipControl");
        this.CreateTransformFeedbacks = provider.getFunctionAddress("glCreateTransformFeedbacks");
        this.TransformFeedbackBufferBase = provider.getFunctionAddress("glTransformFeedbackBufferBase");
        this.TransformFeedbackBufferRange = provider.getFunctionAddress("glTransformFeedbackBufferRange");
        this.GetTransformFeedbackiv = provider.getFunctionAddress("glGetTransformFeedbackiv");
        this.GetTransformFeedbacki_v = provider.getFunctionAddress("glGetTransformFeedbacki_v");
        this.GetTransformFeedbacki64_v = provider.getFunctionAddress("glGetTransformFeedbacki64_v");
        this.CreateBuffers = provider.getFunctionAddress("glCreateBuffers");
        this.NamedBufferStorage = provider.getFunctionAddress("glNamedBufferStorage");
        this.NamedBufferData = provider.getFunctionAddress("glNamedBufferData");
        this.NamedBufferSubData = provider.getFunctionAddress("glNamedBufferSubData");
        this.CopyNamedBufferSubData = provider.getFunctionAddress("glCopyNamedBufferSubData");
        this.ClearNamedBufferData = provider.getFunctionAddress("glClearNamedBufferData");
        this.ClearNamedBufferSubData = provider.getFunctionAddress("glClearNamedBufferSubData");
        this.MapNamedBuffer = provider.getFunctionAddress("glMapNamedBuffer");
        this.MapNamedBufferRange = provider.getFunctionAddress("glMapNamedBufferRange");
        this.UnmapNamedBuffer = provider.getFunctionAddress("glUnmapNamedBuffer");
        this.FlushMappedNamedBufferRange = provider.getFunctionAddress("glFlushMappedNamedBufferRange");
        this.GetNamedBufferParameteriv = provider.getFunctionAddress("glGetNamedBufferParameteriv");
        this.GetNamedBufferParameteri64v = provider.getFunctionAddress("glGetNamedBufferParameteri64v");
        this.GetNamedBufferPointerv = provider.getFunctionAddress("glGetNamedBufferPointerv");
        this.GetNamedBufferSubData = provider.getFunctionAddress("glGetNamedBufferSubData");
        this.CreateFramebuffers = provider.getFunctionAddress("glCreateFramebuffers");
        this.NamedFramebufferRenderbuffer = provider.getFunctionAddress("glNamedFramebufferRenderbuffer");
        this.NamedFramebufferParameteri = provider.getFunctionAddress("glNamedFramebufferParameteri");
        this.NamedFramebufferTexture = provider.getFunctionAddress("glNamedFramebufferTexture");
        this.NamedFramebufferTextureLayer = provider.getFunctionAddress("glNamedFramebufferTextureLayer");
        this.NamedFramebufferDrawBuffer = provider.getFunctionAddress("glNamedFramebufferDrawBuffer");
        this.NamedFramebufferDrawBuffers = provider.getFunctionAddress("glNamedFramebufferDrawBuffers");
        this.NamedFramebufferReadBuffer = provider.getFunctionAddress("glNamedFramebufferReadBuffer");
        this.InvalidateNamedFramebufferData = provider.getFunctionAddress("glInvalidateNamedFramebufferData");
        this.InvalidateNamedFramebufferSubData = provider.getFunctionAddress("glInvalidateNamedFramebufferSubData");
        this.ClearNamedFramebufferiv = provider.getFunctionAddress("glClearNamedFramebufferiv");
        this.ClearNamedFramebufferuiv = provider.getFunctionAddress("glClearNamedFramebufferuiv");
        this.ClearNamedFramebufferfv = provider.getFunctionAddress("glClearNamedFramebufferfv");
        this.ClearNamedFramebufferfi = provider.getFunctionAddress("glClearNamedFramebufferfi");
        this.BlitNamedFramebuffer = provider.getFunctionAddress("glBlitNamedFramebuffer");
        this.CheckNamedFramebufferStatus = provider.getFunctionAddress("glCheckNamedFramebufferStatus");
        this.GetNamedFramebufferParameteriv = provider.getFunctionAddress("glGetNamedFramebufferParameteriv");
        this.GetNamedFramebufferAttachmentParameteriv = provider.getFunctionAddress("glGetNamedFramebufferAttachmentParameteriv");
        this.CreateRenderbuffers = provider.getFunctionAddress("glCreateRenderbuffers");
        this.NamedRenderbufferStorage = provider.getFunctionAddress("glNamedRenderbufferStorage");
        this.NamedRenderbufferStorageMultisample = provider.getFunctionAddress("glNamedRenderbufferStorageMultisample");
        this.GetNamedRenderbufferParameteriv = provider.getFunctionAddress("glGetNamedRenderbufferParameteriv");
        this.CreateTextures = provider.getFunctionAddress("glCreateTextures");
        this.TextureBuffer = provider.getFunctionAddress("glTextureBuffer");
        this.TextureBufferRange = provider.getFunctionAddress("glTextureBufferRange");
        this.TextureStorage1D = provider.getFunctionAddress("glTextureStorage1D");
        this.TextureStorage2D = provider.getFunctionAddress("glTextureStorage2D");
        this.TextureStorage3D = provider.getFunctionAddress("glTextureStorage3D");
        this.TextureStorage2DMultisample = provider.getFunctionAddress("glTextureStorage2DMultisample");
        this.TextureStorage3DMultisample = provider.getFunctionAddress("glTextureStorage3DMultisample");
        this.TextureSubImage1D = provider.getFunctionAddress("glTextureSubImage1D");
        this.TextureSubImage2D = provider.getFunctionAddress("glTextureSubImage2D");
        this.TextureSubImage3D = provider.getFunctionAddress("glTextureSubImage3D");
        this.CompressedTextureSubImage1D = provider.getFunctionAddress("glCompressedTextureSubImage1D");
        this.CompressedTextureSubImage2D = provider.getFunctionAddress("glCompressedTextureSubImage2D");
        this.CompressedTextureSubImage3D = provider.getFunctionAddress("glCompressedTextureSubImage3D");
        this.CopyTextureSubImage1D = provider.getFunctionAddress("glCopyTextureSubImage1D");
        this.CopyTextureSubImage2D = provider.getFunctionAddress("glCopyTextureSubImage2D");
        this.CopyTextureSubImage3D = provider.getFunctionAddress("glCopyTextureSubImage3D");
        this.TextureParameterf = provider.getFunctionAddress("glTextureParameterf");
        this.TextureParameterfv = provider.getFunctionAddress("glTextureParameterfv");
        this.TextureParameteri = provider.getFunctionAddress("glTextureParameteri");
        this.TextureParameterIiv = provider.getFunctionAddress("glTextureParameterIiv");
        this.TextureParameterIuiv = provider.getFunctionAddress("glTextureParameterIuiv");
        this.TextureParameteriv = provider.getFunctionAddress("glTextureParameteriv");
        this.GenerateTextureMipmap = provider.getFunctionAddress("glGenerateTextureMipmap");
        this.BindTextureUnit = provider.getFunctionAddress("glBindTextureUnit");
        this.GetTextureImage = provider.getFunctionAddress("glGetTextureImage");
        this.GetCompressedTextureImage = provider.getFunctionAddress("glGetCompressedTextureImage");
        this.GetTextureLevelParameterfv = provider.getFunctionAddress("glGetTextureLevelParameterfv");
        this.GetTextureLevelParameteriv = provider.getFunctionAddress("glGetTextureLevelParameteriv");
        this.GetTextureParameterfv = provider.getFunctionAddress("glGetTextureParameterfv");
        this.GetTextureParameterIiv = provider.getFunctionAddress("glGetTextureParameterIiv");
        this.GetTextureParameterIuiv = provider.getFunctionAddress("glGetTextureParameterIuiv");
        this.GetTextureParameteriv = provider.getFunctionAddress("glGetTextureParameteriv");
        this.CreateVertexArrays = provider.getFunctionAddress("glCreateVertexArrays");
        this.DisableVertexArrayAttrib = provider.getFunctionAddress("glDisableVertexArrayAttrib");
        this.EnableVertexArrayAttrib = provider.getFunctionAddress("glEnableVertexArrayAttrib");
        this.VertexArrayElementBuffer = provider.getFunctionAddress("glVertexArrayElementBuffer");
        this.VertexArrayVertexBuffer = provider.getFunctionAddress("glVertexArrayVertexBuffer");
        this.VertexArrayVertexBuffers = provider.getFunctionAddress("glVertexArrayVertexBuffers");
        this.VertexArrayAttribFormat = provider.getFunctionAddress("glVertexArrayAttribFormat");
        this.VertexArrayAttribIFormat = provider.getFunctionAddress("glVertexArrayAttribIFormat");
        this.VertexArrayAttribLFormat = provider.getFunctionAddress("glVertexArrayAttribLFormat");
        this.VertexArrayAttribBinding = provider.getFunctionAddress("glVertexArrayAttribBinding");
        this.VertexArrayBindingDivisor = provider.getFunctionAddress("glVertexArrayBindingDivisor");
        this.GetVertexArrayiv = provider.getFunctionAddress("glGetVertexArrayiv");
        this.GetVertexArrayIndexediv = provider.getFunctionAddress("glGetVertexArrayIndexediv");
        this.GetVertexArrayIndexed64iv = provider.getFunctionAddress("glGetVertexArrayIndexed64iv");
        this.CreateSamplers = provider.getFunctionAddress("glCreateSamplers");
        this.CreateProgramPipelines = provider.getFunctionAddress("glCreateProgramPipelines");
        this.CreateQueries = provider.getFunctionAddress("glCreateQueries");
        this.GetQueryBufferObjectiv = provider.getFunctionAddress("glGetQueryBufferObjectiv");
        this.GetQueryBufferObjectuiv = provider.getFunctionAddress("glGetQueryBufferObjectuiv");
        this.GetQueryBufferObjecti64v = provider.getFunctionAddress("glGetQueryBufferObjecti64v");
        this.GetQueryBufferObjectui64v = provider.getFunctionAddress("glGetQueryBufferObjectui64v");
        this.MemoryBarrierByRegion = provider.getFunctionAddress("glMemoryBarrierByRegion");
        this.GetTextureSubImage = provider.getFunctionAddress("glGetTextureSubImage");
        this.GetCompressedTextureSubImage = provider.getFunctionAddress("glGetCompressedTextureSubImage");
        this.TextureBarrier = provider.getFunctionAddress("glTextureBarrier");
        this.GetGraphicsResetStatus = provider.getFunctionAddress("glGetGraphicsResetStatus");
        this.GetnMapdv = provider.getFunctionAddress("glGetnMapdv");
        this.GetnMapfv = provider.getFunctionAddress("glGetnMapfv");
        this.GetnMapiv = provider.getFunctionAddress("glGetnMapiv");
        this.GetnPixelMapfv = provider.getFunctionAddress("glGetnPixelMapfv");
        this.GetnPixelMapuiv = provider.getFunctionAddress("glGetnPixelMapuiv");
        this.GetnPixelMapusv = provider.getFunctionAddress("glGetnPixelMapusv");
        this.GetnPolygonStipple = provider.getFunctionAddress("glGetnPolygonStipple");
        this.GetnTexImage = provider.getFunctionAddress("glGetnTexImage");
        this.ReadnPixels = provider.getFunctionAddress("glReadnPixels");
        this.GetnColorTable = provider.getFunctionAddress("glGetnColorTable");
        this.GetnConvolutionFilter = provider.getFunctionAddress("glGetnConvolutionFilter");
        this.GetnSeparableFilter = provider.getFunctionAddress("glGetnSeparableFilter");
        this.GetnHistogram = provider.getFunctionAddress("glGetnHistogram");
        this.GetnMinmax = provider.getFunctionAddress("glGetnMinmax");
        this.GetnCompressedTexImage = provider.getFunctionAddress("glGetnCompressedTexImage");
        this.GetnUniformfv = provider.getFunctionAddress("glGetnUniformfv");
        this.GetnUniformdv = provider.getFunctionAddress("glGetnUniformdv");
        this.GetnUniformiv = provider.getFunctionAddress("glGetnUniformiv");
        this.GetnUniformuiv = provider.getFunctionAddress("glGetnUniformuiv");
    }

    public static GL45 getInstance() {
        return GL45.getInstance(GL.getCapabilities());
    }

    public static GL45 getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GL45);
    }

    static GL45 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL45")) {
            return null;
        }
        GL45 funcs = new GL45(provider);
        boolean supported = Checks.checkFunctions(funcs.ClipControl, funcs.CreateTransformFeedbacks, funcs.TransformFeedbackBufferBase, funcs.TransformFeedbackBufferRange, funcs.GetTransformFeedbackiv, funcs.GetTransformFeedbacki_v, funcs.GetTransformFeedbacki64_v, funcs.CreateBuffers, funcs.NamedBufferStorage, funcs.NamedBufferData, funcs.NamedBufferSubData, funcs.CopyNamedBufferSubData, funcs.ClearNamedBufferData, funcs.ClearNamedBufferSubData, funcs.MapNamedBuffer, funcs.MapNamedBufferRange, funcs.UnmapNamedBuffer, funcs.FlushMappedNamedBufferRange, funcs.GetNamedBufferParameteriv, funcs.GetNamedBufferParameteri64v, funcs.GetNamedBufferPointerv, funcs.GetNamedBufferSubData, funcs.CreateFramebuffers, funcs.NamedFramebufferRenderbuffer, funcs.NamedFramebufferParameteri, funcs.NamedFramebufferTexture, funcs.NamedFramebufferTextureLayer, funcs.NamedFramebufferDrawBuffer, funcs.NamedFramebufferDrawBuffers, funcs.NamedFramebufferReadBuffer, funcs.InvalidateNamedFramebufferData, funcs.InvalidateNamedFramebufferSubData, funcs.ClearNamedFramebufferiv, funcs.ClearNamedFramebufferuiv, funcs.ClearNamedFramebufferfv, funcs.ClearNamedFramebufferfi, funcs.BlitNamedFramebuffer, funcs.CheckNamedFramebufferStatus, funcs.GetNamedFramebufferParameteriv, funcs.GetNamedFramebufferAttachmentParameteriv, funcs.CreateRenderbuffers, funcs.NamedRenderbufferStorage, funcs.NamedRenderbufferStorageMultisample, funcs.GetNamedRenderbufferParameteriv, funcs.CreateTextures, funcs.TextureBuffer, funcs.TextureBufferRange, funcs.TextureStorage1D, funcs.TextureStorage2D, funcs.TextureStorage3D, funcs.TextureStorage2DMultisample, funcs.TextureStorage3DMultisample, funcs.TextureSubImage1D, funcs.TextureSubImage2D, funcs.TextureSubImage3D, funcs.CompressedTextureSubImage1D, funcs.CompressedTextureSubImage2D, funcs.CompressedTextureSubImage3D, funcs.CopyTextureSubImage1D, funcs.CopyTextureSubImage2D, funcs.CopyTextureSubImage3D, funcs.TextureParameterf, funcs.TextureParameterfv, funcs.TextureParameteri, funcs.TextureParameterIiv, funcs.TextureParameterIuiv, funcs.TextureParameteriv, funcs.GenerateTextureMipmap, funcs.BindTextureUnit, funcs.GetTextureImage, funcs.GetCompressedTextureImage, funcs.GetTextureLevelParameterfv, funcs.GetTextureLevelParameteriv, funcs.GetTextureParameterfv, funcs.GetTextureParameterIiv, funcs.GetTextureParameterIuiv, funcs.GetTextureParameteriv, funcs.CreateVertexArrays, funcs.DisableVertexArrayAttrib, funcs.EnableVertexArrayAttrib, funcs.VertexArrayElementBuffer, funcs.VertexArrayVertexBuffer, funcs.VertexArrayVertexBuffers, funcs.VertexArrayAttribFormat, funcs.VertexArrayAttribIFormat, funcs.VertexArrayAttribLFormat, funcs.VertexArrayAttribBinding, funcs.VertexArrayBindingDivisor, funcs.GetVertexArrayiv, funcs.GetVertexArrayIndexediv, funcs.GetVertexArrayIndexed64iv, funcs.CreateSamplers, funcs.CreateProgramPipelines, funcs.CreateQueries, funcs.GetQueryBufferObjectiv, funcs.GetQueryBufferObjectuiv, funcs.GetQueryBufferObjecti64v, funcs.GetQueryBufferObjectui64v, funcs.MemoryBarrierByRegion, funcs.GetTextureSubImage, funcs.GetCompressedTextureSubImage, funcs.TextureBarrier, funcs.GetGraphicsResetStatus, funcs.ReadnPixels, funcs.GetnUniformfv, funcs.GetnUniformiv, funcs.GetnUniformuiv);
        return GL.checkExtension("OpenGL45", funcs, supported);
    }

    public static void glClipControl(int origin, int depth) {
        long __functionAddress = GL45.getInstance().ClipControl;
        JNI.callIIV(__functionAddress, origin, depth);
    }

    public static void nglCreateTransformFeedbacks(int n, long ids) {
        long __functionAddress = GL45.getInstance().CreateTransformFeedbacks;
        JNI.callIPV(__functionAddress, n, ids);
    }

    public static void glCreateTransformFeedbacks(int n, ByteBuffer ids) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        GL45.nglCreateTransformFeedbacks(n, MemoryUtil.memAddress(ids));
    }

    public static void glCreateTransformFeedbacks(IntBuffer ids) {
        GL45.nglCreateTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static int glCreateTransformFeedbacks() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam();
        GL45.nglCreateTransformFeedbacks(1, __buffer.address(ids));
        return __buffer.intValue(ids);
    }

    public static void glTransformFeedbackBufferBase(int xfb, int index, int buffer) {
        long __functionAddress = GL45.getInstance().TransformFeedbackBufferBase;
        JNI.callIIIV(__functionAddress, xfb, index, buffer);
    }

    public static void glTransformFeedbackBufferRange(int xfb, int index, int buffer, long offset, long size) {
        long __functionAddress = GL45.getInstance().TransformFeedbackBufferRange;
        JNI.callIIIPPV(__functionAddress, xfb, index, buffer, offset, size);
    }

    public static void nglGetTransformFeedbackiv(int xfb, int pname, long param) {
        long __functionAddress = GL45.getInstance().GetTransformFeedbackiv;
        JNI.callIIPV(__functionAddress, xfb, pname, param);
    }

    public static void glGetTransformFeedbackiv(int xfb, int pname, ByteBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        GL45.nglGetTransformFeedbackiv(xfb, pname, MemoryUtil.memAddress(param));
    }

    public static void glGetTransformFeedbackiv(int xfb, int pname, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        GL45.nglGetTransformFeedbackiv(xfb, pname, MemoryUtil.memAddress(param));
    }

    public static int glGetTransformFeedbacki(int xfb, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.intParam();
        GL45.nglGetTransformFeedbackiv(xfb, pname, __buffer.address(param));
        return __buffer.intValue(param);
    }

    public static void nglGetTransformFeedbacki_v(int xfb, int pname, int index, long param) {
        long __functionAddress = GL45.getInstance().GetTransformFeedbacki_v;
        JNI.callIIIPV(__functionAddress, xfb, pname, index, param);
    }

    public static void glGetTransformFeedbacki_v(int xfb, int pname, int index, ByteBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        GL45.nglGetTransformFeedbacki_v(xfb, pname, index, MemoryUtil.memAddress(param));
    }

    public static void glGetTransformFeedbacki_v(int xfb, int pname, int index, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        GL45.nglGetTransformFeedbacki_v(xfb, pname, index, MemoryUtil.memAddress(param));
    }

    public static int glGetTransformFeedbacki(int xfb, int pname, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.intParam();
        GL45.nglGetTransformFeedbacki_v(xfb, pname, index, __buffer.address(param));
        return __buffer.intValue(param);
    }

    public static void nglGetTransformFeedbacki64_v(int xfb, int pname, int index, long param) {
        long __functionAddress = GL45.getInstance().GetTransformFeedbacki64_v;
        JNI.callIIIPV(__functionAddress, xfb, pname, index, param);
    }

    public static void glGetTransformFeedbacki64_v(int xfb, int pname, int index, ByteBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 8);
        }
        GL45.nglGetTransformFeedbacki64_v(xfb, pname, index, MemoryUtil.memAddress(param));
    }

    public static void glGetTransformFeedbacki64_v(int xfb, int pname, int index, LongBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        GL45.nglGetTransformFeedbacki64_v(xfb, pname, index, MemoryUtil.memAddress(param));
    }

    public static long glGetTransformFeedbacki64(int xfb, int pname, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.longParam();
        GL45.nglGetTransformFeedbacki64_v(xfb, pname, index, __buffer.address(param));
        return __buffer.longValue(param);
    }

    public static void nglCreateBuffers(int n, long buffers) {
        long __functionAddress = GL45.getInstance().CreateBuffers;
        JNI.callIPV(__functionAddress, n, buffers);
    }

    public static void glCreateBuffers(int n, ByteBuffer buffers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffers, n << 2);
        }
        GL45.nglCreateBuffers(n, MemoryUtil.memAddress(buffers));
    }

    public static void glCreateBuffers(IntBuffer buffers) {
        GL45.nglCreateBuffers(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    public static int glCreateBuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int buffers = __buffer.intParam();
        GL45.nglCreateBuffers(1, __buffer.address(buffers));
        return __buffer.intValue(buffers);
    }

    public static void nglNamedBufferStorage(int buffer, long size, long data, int flags) {
        long __functionAddress = GL45.getInstance().NamedBufferStorage;
        JNI.callIPPIV(__functionAddress, buffer, size, data, flags);
    }

    public static void glNamedBufferStorage(int buffer, long size, ByteBuffer data, int flags) {
        if (Checks.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GL45.nglNamedBufferStorage(buffer, size, MemoryUtil.memAddressSafe(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, long size, int flags) {
        GL45.nglNamedBufferStorage(buffer, size, 0L, flags);
    }

    public static void glNamedBufferStorage(int buffer, ByteBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining(), MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, ShortBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining() << 1, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, IntBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, FloatBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, DoubleBuffer data, int flags) {
        GL45.nglNamedBufferStorage(buffer, data.remaining() << 3, MemoryUtil.memAddress(data), flags);
    }

    public static void nglNamedBufferData(int buffer, long size, long data, int usage) {
        long __functionAddress = GL45.getInstance().NamedBufferData;
        JNI.callIPPIV(__functionAddress, buffer, size, data, usage);
    }

    public static void glNamedBufferData(int buffer, long size, ByteBuffer data, int usage) {
        if (Checks.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GL45.nglNamedBufferData(buffer, size, MemoryUtil.memAddressSafe(data), usage);
    }

    public static void glNamedBufferData(int buffer, long size, int usage) {
        GL45.nglNamedBufferData(buffer, size, 0L, usage);
    }

    public static void glNamedBufferData(int buffer, ByteBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining(), MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferData(int buffer, ShortBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining() << 1, MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferData(int buffer, IntBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferData(int buffer, FloatBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferData(int buffer, DoubleBuffer data, int usage) {
        GL45.nglNamedBufferData(buffer, data.remaining() << 3, MemoryUtil.memAddress(data), usage);
    }

    public static void nglNamedBufferSubData(int buffer, long offset, long size, long data) {
        long __functionAddress = GL45.getInstance().NamedBufferSubData;
        JNI.callIPPPV(__functionAddress, buffer, offset, size, data);
    }

    public static void glNamedBufferSubData(int buffer, long offset, long size, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GL45.nglNamedBufferSubData(buffer, offset, size, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, ByteBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, ShortBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, IntBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, FloatBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, DoubleBuffer data) {
        GL45.nglNamedBufferSubData(buffer, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static void glCopyNamedBufferSubData(int readBuffer, int writeBuffer, long readOffset, long writeOffset, long size) {
        long __functionAddress = GL45.getInstance().CopyNamedBufferSubData;
        JNI.callIIPPPV(__functionAddress, readBuffer, writeBuffer, readOffset, writeOffset, size);
    }

    public static void nglClearNamedBufferData(int buffer, int internalformat, int format, int type, long data) {
        long __functionAddress = GL45.getInstance().ClearNamedBufferData;
        JNI.callIIIIPV(__functionAddress, buffer, internalformat, format, type, data);
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, ByteBuffer data) {
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, ShortBuffer data) {
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, IntBuffer data) {
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, FloatBuffer data) {
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void nglClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, long data) {
        long __functionAddress = GL45.getInstance().ClearNamedBufferSubData;
        JNI.callIIPPIIPV(__functionAddress, buffer, internalformat, offset, size, format, type, data);
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, ByteBuffer data) {
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, ShortBuffer data) {
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, IntBuffer data) {
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, FloatBuffer data) {
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static long nglMapNamedBuffer(int buffer, int access) {
        long __functionAddress = GL45.getInstance().MapNamedBuffer;
        return JNI.callIIP(__functionAddress, buffer, access);
    }

    public static ByteBuffer glMapNamedBuffer(int buffer, int access) {
        long __result = GL45.nglMapNamedBuffer(buffer, access);
        return MemoryUtil.memByteBuffer(__result, GL45.glGetNamedBufferParameteri(buffer, 34660));
    }

    public static ByteBuffer glMapNamedBuffer(int buffer, int access, ByteBuffer old_buffer) {
        long __result = GL45.nglMapNamedBuffer(buffer, access);
        int length = GL45.glGetNamedBufferParameteri(buffer, 34660);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, length) : MemoryUtil.memSetupBuffer(old_buffer, __result, length);
    }

    public static ByteBuffer glMapNamedBuffer(int buffer, int access, long length, ByteBuffer old_buffer) {
        long __result = GL45.nglMapNamedBuffer(buffer, access);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }

    public static long nglMapNamedBufferRange(int buffer, long offset, long length, int access) {
        long __functionAddress = GL45.getInstance().MapNamedBufferRange;
        return JNI.callIPPIP(__functionAddress, buffer, offset, length, access);
    }

    public static ByteBuffer glMapNamedBufferRange(int buffer, long offset, long length, int access) {
        long __result = GL45.nglMapNamedBufferRange(buffer, offset, length, access);
        return MemoryUtil.memByteBuffer(__result, (int)length);
    }

    public static ByteBuffer glMapNamedBufferRange(int buffer, long offset, long length, int access, ByteBuffer old_buffer) {
        long __result = GL45.nglMapNamedBufferRange(buffer, offset, length, access);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }

    public static boolean glUnmapNamedBuffer(int buffer) {
        long __functionAddress = GL45.getInstance().UnmapNamedBuffer;
        return JNI.callIZ(__functionAddress, buffer);
    }

    public static void glFlushMappedNamedBufferRange(int buffer, long offset, long length) {
        long __functionAddress = GL45.getInstance().FlushMappedNamedBufferRange;
        JNI.callIPPV(__functionAddress, buffer, offset, length);
    }

    public static void nglGetNamedBufferParameteriv(int buffer, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetNamedBufferParameteriv;
        JNI.callIIPV(__functionAddress, buffer, pname, params);
    }

    public static void glGetNamedBufferParameteriv(int buffer, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetNamedBufferParameteriv(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedBufferParameteriv(int buffer, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetNamedBufferParameteriv(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedBufferParameteri(int buffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetNamedBufferParameteriv(buffer, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetNamedBufferParameteri64v(int buffer, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetNamedBufferParameteri64v;
        JNI.callIIPV(__functionAddress, buffer, pname, params);
    }

    public static void glGetNamedBufferParameteri64v(int buffer, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        GL45.nglGetNamedBufferParameteri64v(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedBufferParameteri64v(int buffer, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetNamedBufferParameteri64v(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetNamedBufferParameteri64(int buffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        GL45.nglGetNamedBufferParameteri64v(buffer, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static void nglGetNamedBufferPointerv(int buffer, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetNamedBufferPointerv;
        JNI.callIIPV(__functionAddress, buffer, pname, params);
    }

    public static void glGetNamedBufferPointerv(int buffer, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1 << Pointer.POINTER_SHIFT);
        }
        GL45.nglGetNamedBufferPointerv(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedBufferPointerv(int buffer, int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        GL45.nglGetNamedBufferPointerv(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetNamedBufferPointer(int buffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.pointerParam();
        GL45.nglGetNamedBufferPointerv(buffer, pname, __buffer.address(params));
        return __buffer.pointerValue(params);
    }

    public static void nglGetNamedBufferSubData(int buffer, long offset, long size, long data) {
        long __functionAddress = GL45.getInstance().GetNamedBufferSubData;
        JNI.callIPPPV(__functionAddress, buffer, offset, size, data);
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, long size, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GL45.nglGetNamedBufferSubData(buffer, offset, size, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, ByteBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, ShortBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, IntBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, FloatBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, DoubleBuffer data) {
        GL45.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static void nglCreateFramebuffers(int n, long framebuffers) {
        long __functionAddress = GL45.getInstance().CreateFramebuffers;
        JNI.callIPV(__functionAddress, n, framebuffers);
    }

    public static void glCreateFramebuffers(int n, ByteBuffer framebuffers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)framebuffers, n << 2);
        }
        GL45.nglCreateFramebuffers(n, MemoryUtil.memAddress(framebuffers));
    }

    public static void glCreateFramebuffers(IntBuffer framebuffers) {
        GL45.nglCreateFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress(framebuffers));
    }

    public static int glCreateFramebuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int framebuffers = __buffer.intParam();
        GL45.nglCreateFramebuffers(1, __buffer.address(framebuffers));
        return __buffer.intValue(framebuffers);
    }

    public static void glNamedFramebufferRenderbuffer(int framebuffer, int attachment, int renderbuffertarget, int renderbuffer) {
        long __functionAddress = GL45.getInstance().NamedFramebufferRenderbuffer;
        JNI.callIIIIV(__functionAddress, framebuffer, attachment, renderbuffertarget, renderbuffer);
    }

    public static void glNamedFramebufferParameteri(int framebuffer, int pname, int param) {
        long __functionAddress = GL45.getInstance().NamedFramebufferParameteri;
        JNI.callIIIV(__functionAddress, framebuffer, pname, param);
    }

    public static void glNamedFramebufferTexture(int framebuffer, int attachment, int texture, int level) {
        long __functionAddress = GL45.getInstance().NamedFramebufferTexture;
        JNI.callIIIIV(__functionAddress, framebuffer, attachment, texture, level);
    }

    public static void glNamedFramebufferTextureLayer(int framebuffer, int attachment, int texture, int level, int layer) {
        long __functionAddress = GL45.getInstance().NamedFramebufferTextureLayer;
        JNI.callIIIIIV(__functionAddress, framebuffer, attachment, texture, level, layer);
    }

    public static void glNamedFramebufferDrawBuffer(int framebuffer, int buf) {
        long __functionAddress = GL45.getInstance().NamedFramebufferDrawBuffer;
        JNI.callIIV(__functionAddress, framebuffer, buf);
    }

    public static void nglNamedFramebufferDrawBuffers(int framebuffer, int n, long bufs) {
        long __functionAddress = GL45.getInstance().NamedFramebufferDrawBuffers;
        JNI.callIIPV(__functionAddress, framebuffer, n, bufs);
    }

    public static void glNamedFramebufferDrawBuffers(int framebuffer, int n, ByteBuffer bufs) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)bufs, n << 2);
        }
        GL45.nglNamedFramebufferDrawBuffers(framebuffer, n, MemoryUtil.memAddress(bufs));
    }

    public static void glNamedFramebufferDrawBuffers(int framebuffer, IntBuffer bufs) {
        GL45.nglNamedFramebufferDrawBuffers(framebuffer, bufs.remaining(), MemoryUtil.memAddress(bufs));
    }

    public static void glNamedFramebufferDrawBuffers(int framebuffer, int buf) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bufs = __buffer.intParam(buf);
        GL45.nglNamedFramebufferDrawBuffers(framebuffer, 1, __buffer.address(bufs));
    }

    public static void glNamedFramebufferReadBuffer(int framebuffer, int src) {
        long __functionAddress = GL45.getInstance().NamedFramebufferReadBuffer;
        JNI.callIIV(__functionAddress, framebuffer, src);
    }

    public static void nglInvalidateNamedFramebufferData(int framebuffer, int numAttachments, long attachments) {
        long __functionAddress = GL45.getInstance().InvalidateNamedFramebufferData;
        JNI.callIIPV(__functionAddress, framebuffer, numAttachments, attachments);
    }

    public static void glInvalidateNamedFramebufferData(int framebuffer, int numAttachments, ByteBuffer attachments) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        GL45.nglInvalidateNamedFramebufferData(framebuffer, numAttachments, MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateNamedFramebufferData(int framebuffer, IntBuffer attachments) {
        GL45.nglInvalidateNamedFramebufferData(framebuffer, attachments.remaining(), MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateNamedFramebufferData(int framebuffer, int attachment) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        GL45.nglInvalidateNamedFramebufferData(framebuffer, 1, __buffer.address(attachments));
    }

    public static void nglInvalidateNamedFramebufferSubData(int framebuffer, int numAttachments, long attachments, int x, int y, int width, int height) {
        long __functionAddress = GL45.getInstance().InvalidateNamedFramebufferSubData;
        JNI.callIIPIIIIV(__functionAddress, framebuffer, numAttachments, attachments, x, y, width, height);
    }

    public static void glInvalidateNamedFramebufferSubData(int framebuffer, int numAttachments, ByteBuffer attachments, int x, int y, int width, int height) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        GL45.nglInvalidateNamedFramebufferSubData(framebuffer, numAttachments, MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateNamedFramebufferSubData(int framebuffer, IntBuffer attachments, int x, int y, int width, int height) {
        GL45.nglInvalidateNamedFramebufferSubData(framebuffer, attachments.remaining(), MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateNamedFramebufferSubData(int framebuffer, int attachment, int x, int y, int width, int height) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        GL45.nglInvalidateNamedFramebufferSubData(framebuffer, 1, __buffer.address(attachments), x, y, width, height);
    }

    public static void nglClearNamedFramebufferiv(int framebuffer, int buffer, int drawbuffer, long value) {
        long __functionAddress = GL45.getInstance().ClearNamedFramebufferiv;
        JNI.callIIIPV(__functionAddress, framebuffer, buffer, drawbuffer, value);
    }

    public static void glClearNamedFramebufferiv(int framebuffer, int buffer, int drawbuffer, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        GL45.nglClearNamedFramebufferiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearNamedFramebufferiv(int framebuffer, int buffer, int drawbuffer, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GL45.nglClearNamedFramebufferiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void nglClearNamedFramebufferuiv(int framebuffer, int buffer, int drawbuffer, long value) {
        long __functionAddress = GL45.getInstance().ClearNamedFramebufferuiv;
        JNI.callIIIPV(__functionAddress, framebuffer, buffer, drawbuffer, value);
    }

    public static void glClearNamedFramebufferuiv(int framebuffer, int buffer, int drawbuffer, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 16);
        }
        GL45.nglClearNamedFramebufferuiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearNamedFramebufferuiv(int framebuffer, int buffer, int drawbuffer, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        GL45.nglClearNamedFramebufferuiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void nglClearNamedFramebufferfv(int framebuffer, int buffer, int drawbuffer, long value) {
        long __functionAddress = GL45.getInstance().ClearNamedFramebufferfv;
        JNI.callIIIPV(__functionAddress, framebuffer, buffer, drawbuffer, value);
    }

    public static void glClearNamedFramebufferfv(int framebuffer, int buffer, int drawbuffer, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        GL45.nglClearNamedFramebufferfv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearNamedFramebufferfv(int framebuffer, int buffer, int drawbuffer, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GL45.nglClearNamedFramebufferfv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearNamedFramebufferfi(int framebuffer, int buffer, int drawbuffer, float depth, int stencil) {
        long __functionAddress = GL45.getInstance().ClearNamedFramebufferfi;
        JNI.callIIIFIV(__functionAddress, framebuffer, buffer, drawbuffer, depth, stencil);
    }

    public static void glBlitNamedFramebuffer(int readFramebuffer, int drawFramebuffer, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        long __functionAddress = GL45.getInstance().BlitNamedFramebuffer;
        JNI.callIIIIIIIIIIIIV(__functionAddress, readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }

    public static int glCheckNamedFramebufferStatus(int framebuffer, int target) {
        long __functionAddress = GL45.getInstance().CheckNamedFramebufferStatus;
        return JNI.callIII(__functionAddress, framebuffer, target);
    }

    public static void nglGetNamedFramebufferParameteriv(int framebuffer, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetNamedFramebufferParameteriv;
        JNI.callIIPV(__functionAddress, framebuffer, pname, params);
    }

    public static void glGetNamedFramebufferParameteriv(int framebuffer, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetNamedFramebufferParameteriv(framebuffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedFramebufferParameteriv(int framebuffer, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetNamedFramebufferParameteriv(framebuffer, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedFramebufferParameteri(int framebuffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetNamedFramebufferParameteriv(framebuffer, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetNamedFramebufferAttachmentParameteriv(int framebuffer, int attachment, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetNamedFramebufferAttachmentParameteriv;
        JNI.callIIIPV(__functionAddress, framebuffer, attachment, pname, params);
    }

    public static void glGetNamedFramebufferAttachmentParameteriv(int framebuffer, int attachment, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedFramebufferAttachmentParameteriv(int framebuffer, int attachment, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedFramebufferAttachmentParameteri(int framebuffer, int attachment, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglCreateRenderbuffers(int n, long renderbuffers) {
        long __functionAddress = GL45.getInstance().CreateRenderbuffers;
        JNI.callIPV(__functionAddress, n, renderbuffers);
    }

    public static void glCreateRenderbuffers(int n, ByteBuffer renderbuffers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)renderbuffers, n << 2);
        }
        GL45.nglCreateRenderbuffers(n, MemoryUtil.memAddress(renderbuffers));
    }

    public static void glCreateRenderbuffers(IntBuffer renderbuffers) {
        GL45.nglCreateRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress(renderbuffers));
    }

    public static int glCreateRenderbuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int renderbuffers = __buffer.intParam();
        GL45.nglCreateRenderbuffers(1, __buffer.address(renderbuffers));
        return __buffer.intValue(renderbuffers);
    }

    public static void glNamedRenderbufferStorage(int renderbuffer, int internalformat, int width, int height) {
        long __functionAddress = GL45.getInstance().NamedRenderbufferStorage;
        JNI.callIIIIV(__functionAddress, renderbuffer, internalformat, width, height);
    }

    public static void glNamedRenderbufferStorageMultisample(int renderbuffer, int samples, int internalformat, int width, int height) {
        long __functionAddress = GL45.getInstance().NamedRenderbufferStorageMultisample;
        JNI.callIIIIIV(__functionAddress, renderbuffer, samples, internalformat, width, height);
    }

    public static void nglGetNamedRenderbufferParameteriv(int renderbuffer, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetNamedRenderbufferParameteriv;
        JNI.callIIPV(__functionAddress, renderbuffer, pname, params);
    }

    public static void glGetNamedRenderbufferParameteriv(int renderbuffer, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedRenderbufferParameteriv(int renderbuffer, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedRenderbufferParameteri(int renderbuffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglCreateTextures(int target, int n, long textures) {
        long __functionAddress = GL45.getInstance().CreateTextures;
        JNI.callIIPV(__functionAddress, target, n, textures);
    }

    public static void glCreateTextures(int target, int n, ByteBuffer textures) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)textures, n << 2);
        }
        GL45.nglCreateTextures(target, n, MemoryUtil.memAddress(textures));
    }

    public static void glCreateTextures(int target, IntBuffer textures) {
        GL45.nglCreateTextures(target, textures.remaining(), MemoryUtil.memAddress(textures));
    }

    public static int glCreateTextures(int target) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int textures = __buffer.intParam();
        GL45.nglCreateTextures(target, 1, __buffer.address(textures));
        return __buffer.intValue(textures);
    }

    public static void glTextureBuffer(int texture, int internalformat, int buffer) {
        long __functionAddress = GL45.getInstance().TextureBuffer;
        JNI.callIIIV(__functionAddress, texture, internalformat, buffer);
    }

    public static void glTextureBufferRange(int texture, int internalformat, int buffer, long offset, long size) {
        long __functionAddress = GL45.getInstance().TextureBufferRange;
        JNI.callIIIPPV(__functionAddress, texture, internalformat, buffer, offset, size);
    }

    public static void glTextureStorage1D(int texture, int levels, int internalformat, int width) {
        long __functionAddress = GL45.getInstance().TextureStorage1D;
        JNI.callIIIIV(__functionAddress, texture, levels, internalformat, width);
    }

    public static void glTextureStorage2D(int texture, int levels, int internalformat, int width, int height) {
        long __functionAddress = GL45.getInstance().TextureStorage2D;
        JNI.callIIIIIV(__functionAddress, texture, levels, internalformat, width, height);
    }

    public static void glTextureStorage3D(int texture, int levels, int internalformat, int width, int height, int depth) {
        long __functionAddress = GL45.getInstance().TextureStorage3D;
        JNI.callIIIIIIV(__functionAddress, texture, levels, internalformat, width, height, depth);
    }

    public static void glTextureStorage2DMultisample(int texture, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        long __functionAddress = GL45.getInstance().TextureStorage2DMultisample;
        JNI.callIIIIIZV(__functionAddress, texture, samples, internalformat, width, height, fixedsamplelocations);
    }

    public static void glTextureStorage3DMultisample(int texture, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations) {
        long __functionAddress = GL45.getInstance().TextureStorage3DMultisample;
        JNI.callIIIIIIZV(__functionAddress, texture, samples, internalformat, width, height, depth, fixedsamplelocations);
    }

    public static void nglTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, long pixels) {
        long __functionAddress = GL45.getInstance().TextureSubImage1D;
        JNI.callIIIIIIPV(__functionAddress, texture, level, xoffset, width, format, type, pixels);
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, pixelsOffset);
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, DoubleBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void nglTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        long __functionAddress = GL45.getInstance().TextureSubImage2D;
        JNI.callIIIIIIIIPV(__functionAddress, texture, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, pixelsOffset);
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, DoubleBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void nglTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        long __functionAddress = GL45.getInstance().TextureSubImage3D;
        JNI.callIIIIIIIIIIPV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixelsOffset);
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void nglCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int imageSize, long data) {
        long __functionAddress = GL45.getInstance().CompressedTextureSubImage1D;
        JNI.callIIIIIIPV(__functionAddress, texture, level, xoffset, width, format, imageSize, data);
    }

    public static void glCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int imageSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int imageSize, long dataOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL45.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, imageSize, dataOffset);
    }

    public static void glCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        long __functionAddress = GL45.getInstance().CompressedTextureSubImage2D;
        JNI.callIIIIIIIIPV(__functionAddress, texture, level, xoffset, yoffset, width, height, format, imageSize, data);
    }

    public static void glCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long dataOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL45.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, imageSize, dataOffset);
    }

    public static void glCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        long __functionAddress = GL45.getInstance().CompressedTextureSubImage3D;
        JNI.callIIIIIIIIIIPV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }

    public static void glCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long dataOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL45.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, dataOffset);
    }

    public static void glCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL45.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glCopyTextureSubImage1D(int texture, int level, int xoffset, int x, int y, int width) {
        long __functionAddress = GL45.getInstance().CopyTextureSubImage1D;
        JNI.callIIIIIIV(__functionAddress, texture, level, xoffset, x, y, width);
    }

    public static void glCopyTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        long __functionAddress = GL45.getInstance().CopyTextureSubImage2D;
        JNI.callIIIIIIIIV(__functionAddress, texture, level, xoffset, yoffset, x, y, width, height);
    }

    public static void glCopyTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        long __functionAddress = GL45.getInstance().CopyTextureSubImage3D;
        JNI.callIIIIIIIIIV(__functionAddress, texture, level, xoffset, yoffset, zoffset, x, y, width, height);
    }

    public static void glTextureParameterf(int texture, int pname, float param) {
        long __functionAddress = GL45.getInstance().TextureParameterf;
        JNI.callIIFV(__functionAddress, texture, pname, param);
    }

    public static void nglTextureParameterfv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().TextureParameterfv;
        JNI.callIIPV(__functionAddress, texture, pname, params);
    }

    public static void glTextureParameterfv(int texture, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 16);
        }
        GL45.nglTextureParameterfv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterfv(int texture, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglTextureParameterfv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameteri(int texture, int pname, int param) {
        long __functionAddress = GL45.getInstance().TextureParameteri;
        JNI.callIIIV(__functionAddress, texture, pname, param);
    }

    public static void nglTextureParameterIiv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().TextureParameterIiv;
        JNI.callIIPV(__functionAddress, texture, pname, params);
    }

    public static void glTextureParameterIiv(int texture, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglTextureParameterIiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterIiv(int texture, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglTextureParameterIiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterIi(int texture, int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        GL45.nglTextureParameterIiv(texture, pname, __buffer.address(params));
    }

    public static void nglTextureParameterIuiv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().TextureParameterIuiv;
        JNI.callIIPV(__functionAddress, texture, pname, params);
    }

    public static void glTextureParameterIuiv(int texture, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglTextureParameterIuiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterIuiv(int texture, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglTextureParameterIuiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterIui(int texture, int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        GL45.nglTextureParameterIuiv(texture, pname, __buffer.address(params));
    }

    public static void nglTextureParameteriv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().TextureParameteriv;
        JNI.callIIPV(__functionAddress, texture, pname, params);
    }

    public static void glTextureParameteriv(int texture, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 16);
        }
        GL45.nglTextureParameteriv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameteriv(int texture, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglTextureParameteriv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGenerateTextureMipmap(int texture) {
        long __functionAddress = GL45.getInstance().GenerateTextureMipmap;
        JNI.callIV(__functionAddress, texture);
    }

    public static void glBindTextureUnit(int unit, int texture) {
        long __functionAddress = GL45.getInstance().BindTextureUnit;
        JNI.callIIV(__functionAddress, unit, texture);
    }

    public static void nglGetTextureImage(int texture, int level, int format, int type, int bufSize, long pixels) {
        long __functionAddress = GL45.getInstance().GetTextureImage;
        JNI.callIIIIIPV(__functionAddress, texture, level, format, type, bufSize, pixels);
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, int bufSize, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureImage(texture, level, format, type, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, int bufSize, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetTextureImage(texture, level, format, type, bufSize, pixelsOffset);
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining(), MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, DoubleBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 3, MemoryUtil.memAddress(pixels));
    }

    public static void nglGetCompressedTextureImage(int texture, int level, int bufSize, long pixels) {
        long __functionAddress = GL45.getInstance().GetCompressedTextureImage;
        JNI.callIIIPV(__functionAddress, texture, level, bufSize, pixels);
    }

    public static void glGetCompressedTextureImage(int texture, int level, int bufSize, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            if (Checks.DEBUG) {
                Checks.checkBuffer((Buffer)pixels, GL45.glGetTextureLevelParameteri(texture, level, 34464));
            }
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureImage(texture, level, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureImage(int texture, int level, int bufSize, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetCompressedTextureImage(texture, level, bufSize, pixelsOffset);
    }

    public static void glGetCompressedTextureImage(int texture, int level, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            if (Checks.DEBUG) {
                Checks.checkBuffer((Buffer)pixels, GL45.glGetTextureLevelParameteri(texture, level, 34464));
            }
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureImage(texture, level, pixels.remaining(), MemoryUtil.memAddress(pixels));
    }

    public static void nglGetTextureLevelParameterfv(int texture, int level, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetTextureLevelParameterfv;
        JNI.callIIIPV(__functionAddress, texture, level, pname, params);
    }

    public static void glGetTextureLevelParameterfv(int texture, int level, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetTextureLevelParameterfv(texture, level, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureLevelParameterfv(int texture, int level, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetTextureLevelParameterfv(texture, level, pname, MemoryUtil.memAddress(params));
    }

    public static float glGetTextureLevelParameterf(int texture, int level, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GL45.nglGetTextureLevelParameterfv(texture, level, pname, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetTextureLevelParameteriv(int texture, int level, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetTextureLevelParameteriv;
        JNI.callIIIPV(__functionAddress, texture, level, pname, params);
    }

    public static void glGetTextureLevelParameteriv(int texture, int level, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetTextureLevelParameteriv(texture, level, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureLevelParameteriv(int texture, int level, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetTextureLevelParameteriv(texture, level, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTextureLevelParameteri(int texture, int level, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetTextureLevelParameteriv(texture, level, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetTextureParameterfv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetTextureParameterfv;
        JNI.callIIPV(__functionAddress, texture, pname, params);
    }

    public static void glGetTextureParameterfv(int texture, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetTextureParameterfv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureParameterfv(int texture, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetTextureParameterfv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static float glGetTextureParameterf(int texture, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GL45.nglGetTextureParameterfv(texture, pname, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetTextureParameterIiv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetTextureParameterIiv;
        JNI.callIIPV(__functionAddress, texture, pname, params);
    }

    public static void glGetTextureParameterIiv(int texture, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetTextureParameterIiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureParameterIiv(int texture, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetTextureParameterIiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTextureParameterIi(int texture, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetTextureParameterIiv(texture, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetTextureParameterIuiv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetTextureParameterIuiv;
        JNI.callIIPV(__functionAddress, texture, pname, params);
    }

    public static void glGetTextureParameterIuiv(int texture, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetTextureParameterIuiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureParameterIuiv(int texture, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetTextureParameterIuiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTextureParameterIui(int texture, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetTextureParameterIuiv(texture, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetTextureParameteriv(int texture, int pname, long params) {
        long __functionAddress = GL45.getInstance().GetTextureParameteriv;
        JNI.callIIPV(__functionAddress, texture, pname, params);
    }

    public static void glGetTextureParameteriv(int texture, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL45.nglGetTextureParameteriv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureParameteriv(int texture, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL45.nglGetTextureParameteriv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTextureParameteri(int texture, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL45.nglGetTextureParameteriv(texture, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglCreateVertexArrays(int n, long arrays) {
        long __functionAddress = GL45.getInstance().CreateVertexArrays;
        JNI.callIPV(__functionAddress, n, arrays);
    }

    public static void glCreateVertexArrays(int n, ByteBuffer arrays) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)arrays, n << 2);
        }
        GL45.nglCreateVertexArrays(n, MemoryUtil.memAddress(arrays));
    }

    public static void glCreateVertexArrays(IntBuffer arrays) {
        GL45.nglCreateVertexArrays(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    public static int glCreateVertexArrays() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arrays = __buffer.intParam();
        GL45.nglCreateVertexArrays(1, __buffer.address(arrays));
        return __buffer.intValue(arrays);
    }

    public static void glDisableVertexArrayAttrib(int vaobj, int index) {
        long __functionAddress = GL45.getInstance().DisableVertexArrayAttrib;
        JNI.callIIV(__functionAddress, vaobj, index);
    }

    public static void glEnableVertexArrayAttrib(int vaobj, int index) {
        long __functionAddress = GL45.getInstance().EnableVertexArrayAttrib;
        JNI.callIIV(__functionAddress, vaobj, index);
    }

    public static void glVertexArrayElementBuffer(int vaobj, int buffer) {
        long __functionAddress = GL45.getInstance().VertexArrayElementBuffer;
        JNI.callIIV(__functionAddress, vaobj, buffer);
    }

    public static void glVertexArrayVertexBuffer(int vaobj, int bindingindex, int buffer, long offset, int stride) {
        long __functionAddress = GL45.getInstance().VertexArrayVertexBuffer;
        JNI.callIIIPIV(__functionAddress, vaobj, bindingindex, buffer, offset, stride);
    }

    public static void nglVertexArrayVertexBuffers(int vaobj, int first, int count, long buffers, long offsets, long strides) {
        long __functionAddress = GL45.getInstance().VertexArrayVertexBuffers;
        JNI.callIIIPPPV(__functionAddress, vaobj, first, count, buffers, offsets, strides);
    }

    public static void glVertexArrayVertexBuffers(int vaobj, int first, int count, ByteBuffer buffers, ByteBuffer offsets, ByteBuffer strides) {
        if (Checks.CHECKS) {
            if (buffers != null) {
                Checks.checkBuffer((Buffer)buffers, count << 2);
            }
            if (offsets != null) {
                Checks.checkBuffer((Buffer)offsets, count << Pointer.POINTER_SHIFT);
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, count << 2);
            }
        }
        GL45.nglVertexArrayVertexBuffers(vaobj, first, count, MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }

    public static void glVertexArrayVertexBuffers(int vaobj, int first, IntBuffer buffers, PointerBuffer offsets, IntBuffer strides) {
        if (Checks.CHECKS) {
            if (offsets != null) {
                Checks.checkBuffer(offsets, buffers.remaining());
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, buffers.remaining());
            }
        }
        GL45.nglVertexArrayVertexBuffers(vaobj, first, buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }

    public static void glVertexArrayAttribFormat(int vaobj, int attribindex, int size, int type, boolean normalized, int relativeoffset) {
        long __functionAddress = GL45.getInstance().VertexArrayAttribFormat;
        JNI.callIIIIZIV(__functionAddress, vaobj, attribindex, size, type, normalized, relativeoffset);
    }

    public static void glVertexArrayAttribIFormat(int vaobj, int attribindex, int size, int type, int relativeoffset) {
        long __functionAddress = GL45.getInstance().VertexArrayAttribIFormat;
        JNI.callIIIIIV(__functionAddress, vaobj, attribindex, size, type, relativeoffset);
    }

    public static void glVertexArrayAttribLFormat(int vaobj, int attribindex, int size, int type, int relativeoffset) {
        long __functionAddress = GL45.getInstance().VertexArrayAttribLFormat;
        JNI.callIIIIIV(__functionAddress, vaobj, attribindex, size, type, relativeoffset);
    }

    public static void glVertexArrayAttribBinding(int vaobj, int attribindex, int bindingindex) {
        long __functionAddress = GL45.getInstance().VertexArrayAttribBinding;
        JNI.callIIIV(__functionAddress, vaobj, attribindex, bindingindex);
    }

    public static void glVertexArrayBindingDivisor(int vaobj, int bindingindex, int divisor) {
        long __functionAddress = GL45.getInstance().VertexArrayBindingDivisor;
        JNI.callIIIV(__functionAddress, vaobj, bindingindex, divisor);
    }

    public static void nglGetVertexArrayiv(int vaobj, int pname, long param) {
        long __functionAddress = GL45.getInstance().GetVertexArrayiv;
        JNI.callIIPV(__functionAddress, vaobj, pname, param);
    }

    public static void glGetVertexArrayiv(int vaobj, int pname, ByteBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        GL45.nglGetVertexArrayiv(vaobj, pname, MemoryUtil.memAddress(param));
    }

    public static void glGetVertexArrayiv(int vaobj, int pname, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        GL45.nglGetVertexArrayiv(vaobj, pname, MemoryUtil.memAddress(param));
    }

    public static int glGetVertexArrayi(int vaobj, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.intParam();
        GL45.nglGetVertexArrayiv(vaobj, pname, __buffer.address(param));
        return __buffer.intValue(param);
    }

    public static void nglGetVertexArrayIndexediv(int vaobj, int index, int pname, long param) {
        long __functionAddress = GL45.getInstance().GetVertexArrayIndexediv;
        JNI.callIIIPV(__functionAddress, vaobj, index, pname, param);
    }

    public static void glGetVertexArrayIndexediv(int vaobj, int index, int pname, ByteBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        GL45.nglGetVertexArrayIndexediv(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    public static void glGetVertexArrayIndexediv(int vaobj, int index, int pname, IntBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        GL45.nglGetVertexArrayIndexediv(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    public static int glGetVertexArrayIndexedi(int vaobj, int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.intParam();
        GL45.nglGetVertexArrayIndexediv(vaobj, index, pname, __buffer.address(param));
        return __buffer.intValue(param);
    }

    public static void nglGetVertexArrayIndexed64iv(int vaobj, int index, int pname, long param) {
        long __functionAddress = GL45.getInstance().GetVertexArrayIndexed64iv;
        JNI.callIIIPV(__functionAddress, vaobj, index, pname, param);
    }

    public static void glGetVertexArrayIndexed64iv(int vaobj, int index, int pname, ByteBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 8);
        }
        GL45.nglGetVertexArrayIndexed64iv(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    public static void glGetVertexArrayIndexed64iv(int vaobj, int index, int pname, LongBuffer param) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        GL45.nglGetVertexArrayIndexed64iv(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    public static long glGetVertexArrayIndexed64i(int vaobj, int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.longParam();
        GL45.nglGetVertexArrayIndexed64iv(vaobj, index, pname, __buffer.address(param));
        return __buffer.longValue(param);
    }

    public static void nglCreateSamplers(int n, long samplers) {
        long __functionAddress = GL45.getInstance().CreateSamplers;
        JNI.callIPV(__functionAddress, n, samplers);
    }

    public static void glCreateSamplers(int n, ByteBuffer samplers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)samplers, n << 2);
        }
        GL45.nglCreateSamplers(n, MemoryUtil.memAddress(samplers));
    }

    public static void glCreateSamplers(IntBuffer samplers) {
        GL45.nglCreateSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    public static int glCreateSamplers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int samplers = __buffer.intParam();
        GL45.nglCreateSamplers(1, __buffer.address(samplers));
        return __buffer.intValue(samplers);
    }

    public static void nglCreateProgramPipelines(int n, long pipelines) {
        long __functionAddress = GL45.getInstance().CreateProgramPipelines;
        JNI.callIPV(__functionAddress, n, pipelines);
    }

    public static void glCreateProgramPipelines(int n, ByteBuffer pipelines) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        GL45.nglCreateProgramPipelines(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glCreateProgramPipelines(IntBuffer pipelines) {
        GL45.nglCreateProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static int glCreateProgramPipelines() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam();
        GL45.nglCreateProgramPipelines(1, __buffer.address(pipelines));
        return __buffer.intValue(pipelines);
    }

    public static void nglCreateQueries(int target, int n, long ids) {
        long __functionAddress = GL45.getInstance().CreateQueries;
        JNI.callIIPV(__functionAddress, target, n, ids);
    }

    public static void glCreateQueries(int target, int n, ByteBuffer ids) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        GL45.nglCreateQueries(target, n, MemoryUtil.memAddress(ids));
    }

    public static void glCreateQueries(int target, IntBuffer ids) {
        GL45.nglCreateQueries(target, ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static int glCreateQueries(int target) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam();
        GL45.nglCreateQueries(target, 1, __buffer.address(ids));
        return __buffer.intValue(ids);
    }

    public static void glGetQueryBufferObjectiv(int id, int buffer, int pname, long offset) {
        long __functionAddress = GL45.getInstance().GetQueryBufferObjectiv;
        JNI.callIIIPV(__functionAddress, id, buffer, pname, offset);
    }

    public static void glGetQueryBufferObjectuiv(int id, int buffer, int pname, long offset) {
        long __functionAddress = GL45.getInstance().GetQueryBufferObjectuiv;
        JNI.callIIIPV(__functionAddress, id, buffer, pname, offset);
    }

    public static void glGetQueryBufferObjecti64v(int id, int buffer, int pname, long offset) {
        long __functionAddress = GL45.getInstance().GetQueryBufferObjecti64v;
        JNI.callIIIPV(__functionAddress, id, buffer, pname, offset);
    }

    public static void glGetQueryBufferObjectui64v(int id, int buffer, int pname, long offset) {
        long __functionAddress = GL45.getInstance().GetQueryBufferObjectui64v;
        JNI.callIIIPV(__functionAddress, id, buffer, pname, offset);
    }

    public static void glMemoryBarrierByRegion(int barriers) {
        long __functionAddress = GL45.getInstance().MemoryBarrierByRegion;
        JNI.callIV(__functionAddress, barriers);
    }

    public static void nglGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, long pixels) {
        long __functionAddress = GL45.getInstance().GetTextureSubImage;
        JNI.callIIIIIIIIIIIPV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, pixels);
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, pixelsOffset);
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining(), MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 3, MemoryUtil.memAddress(pixels));
    }

    public static void nglGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, long pixels) {
        long __functionAddress = GL45.getInstance().GetCompressedTextureSubImage;
        JNI.callIIIIIIIIIPV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels);
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixelsOffset);
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining(), MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, DoubleBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 3, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureBarrier() {
        long __functionAddress = GL45.getInstance().TextureBarrier;
        JNI.callV(__functionAddress);
    }

    public static int glGetGraphicsResetStatus() {
        long __functionAddress = GL45.getInstance().GetGraphicsResetStatus;
        return JNI.callI(__functionAddress);
    }

    public static void nglGetnMapdv(int target, int query, int bufSize, long data) {
        long __functionAddress = GL45.getInstance().GetnMapdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIPV(__functionAddress, target, query, bufSize, data);
    }

    public static void glGetnMapdv(int target, int query, int bufSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, bufSize << 3);
        }
        GL45.nglGetnMapdv(target, query, bufSize, MemoryUtil.memAddress(data));
    }

    public static void glGetnMapdv(int target, int query, DoubleBuffer data) {
        GL45.nglGetnMapdv(target, query, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static double glGetnMapd(int target, int query) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.doubleParam();
        GL45.nglGetnMapdv(target, query, 1, __buffer.address(data));
        return __buffer.doubleValue(data);
    }

    public static void nglGetnMapfv(int target, int query, int bufSize, long data) {
        long __functionAddress = GL45.getInstance().GetnMapfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIPV(__functionAddress, target, query, bufSize, data);
    }

    public static void glGetnMapfv(int target, int query, int bufSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, bufSize << 2);
        }
        GL45.nglGetnMapfv(target, query, bufSize, MemoryUtil.memAddress(data));
    }

    public static void glGetnMapfv(int target, int query, FloatBuffer data) {
        GL45.nglGetnMapfv(target, query, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static float glGetnMapf(int target, int query) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.floatParam();
        GL45.nglGetnMapfv(target, query, 1, __buffer.address(data));
        return __buffer.floatValue(data);
    }

    public static void nglGetnMapiv(int target, int query, int bufSize, long data) {
        long __functionAddress = GL45.getInstance().GetnMapiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIPV(__functionAddress, target, query, bufSize, data);
    }

    public static void glGetnMapiv(int target, int query, int bufSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, bufSize << 2);
        }
        GL45.nglGetnMapiv(target, query, bufSize, MemoryUtil.memAddress(data));
    }

    public static void glGetnMapiv(int target, int query, IntBuffer data) {
        GL45.nglGetnMapiv(target, query, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static int glGetnMapi(int target, int query) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.intParam();
        GL45.nglGetnMapiv(target, query, 1, __buffer.address(data));
        return __buffer.intValue(data);
    }

    public static void nglGetnPixelMapfv(int map, int bufSize, long data) {
        long __functionAddress = GL45.getInstance().GetnPixelMapfv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPV(__functionAddress, map, bufSize, data);
    }

    public static void glGetnPixelMapfv(int map, int bufSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, bufSize << 2);
        }
        GL45.nglGetnPixelMapfv(map, bufSize, MemoryUtil.memAddress(data));
    }

    public static void glGetnPixelMapfv(int map, FloatBuffer data) {
        GL45.nglGetnPixelMapfv(map, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglGetnPixelMapuiv(int map, int bufSize, long data) {
        long __functionAddress = GL45.getInstance().GetnPixelMapuiv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPV(__functionAddress, map, bufSize, data);
    }

    public static void glGetnPixelMapuiv(int map, int bufSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, bufSize << 2);
        }
        GL45.nglGetnPixelMapuiv(map, bufSize, MemoryUtil.memAddress(data));
    }

    public static void glGetnPixelMapuiv(int map, IntBuffer data) {
        GL45.nglGetnPixelMapuiv(map, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglGetnPixelMapusv(int map, int bufSize, long data) {
        long __functionAddress = GL45.getInstance().GetnPixelMapusv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPV(__functionAddress, map, bufSize, data);
    }

    public static void glGetnPixelMapusv(int map, int bufSize, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, bufSize << 1);
        }
        GL45.nglGetnPixelMapusv(map, bufSize, MemoryUtil.memAddress(data));
    }

    public static void glGetnPixelMapusv(int map, ShortBuffer data) {
        GL45.nglGetnPixelMapusv(map, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglGetnPolygonStipple(int bufSize, long pattern) {
        long __functionAddress = GL45.getInstance().GetnPolygonStipple;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIPV(__functionAddress, bufSize, pattern);
    }

    public static void glGetnPolygonStipple(int bufSize, ByteBuffer pattern) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pattern, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnPolygonStipple(bufSize, MemoryUtil.memAddress(pattern));
    }

    public static void glGetnPolygonStipple(int bufSize, long patternOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetnPolygonStipple(bufSize, patternOffset);
    }

    public static void glGetnPolygonStipple(ByteBuffer pattern) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnPolygonStipple(pattern.remaining(), MemoryUtil.memAddress(pattern));
    }

    public static void nglGetnTexImage(int tex, int level, int format, int type, int bufSize, long img) {
        long __functionAddress = GL45.getInstance().GetnTexImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIIPV(__functionAddress, tex, level, format, type, bufSize, img);
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, int bufSize, ByteBuffer img) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)img, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnTexImage(tex, level, format, type, bufSize, MemoryUtil.memAddress(img));
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, int bufSize, long imgOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetnTexImage(tex, level, format, type, bufSize, imgOffset);
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, ByteBuffer img) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnTexImage(tex, level, format, type, img.remaining(), MemoryUtil.memAddress(img));
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, ShortBuffer img) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnTexImage(tex, level, format, type, img.remaining() << 1, MemoryUtil.memAddress(img));
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, IntBuffer img) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnTexImage(tex, level, format, type, img.remaining() << 2, MemoryUtil.memAddress(img));
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, FloatBuffer img) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnTexImage(tex, level, format, type, img.remaining() << 2, MemoryUtil.memAddress(img));
    }

    public static void glGetnTexImage(int tex, int level, int format, int type, DoubleBuffer img) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnTexImage(tex, level, format, type, img.remaining() << 3, MemoryUtil.memAddress(img));
    }

    public static void nglReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixels) {
        long __functionAddress = GL45.getInstance().ReadnPixels;
        JNI.callIIIIIIIPV(__functionAddress, x, y, width, height, format, type, bufSize, pixels);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, bufSize, pixelsOffset);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, pixels.remaining(), MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void nglGetnColorTable(int target, int format, int type, int bufSize, long table) {
        long __functionAddress = GL45.getInstance().GetnColorTable;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIPV(__functionAddress, target, format, type, bufSize, table);
    }

    public static void glGetnColorTable(int target, int format, int type, int bufSize, ByteBuffer table) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)table, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnColorTable(target, format, type, bufSize, MemoryUtil.memAddress(table));
    }

    public static void glGetnColorTable(int target, int format, int type, int bufSize, long tableOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetnColorTable(target, format, type, bufSize, tableOffset);
    }

    public static void glGetnColorTable(int target, int format, int type, ByteBuffer table) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnColorTable(target, format, type, table.remaining(), MemoryUtil.memAddress(table));
    }

    public static void glGetnColorTable(int target, int format, int type, ShortBuffer table) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnColorTable(target, format, type, table.remaining() << 1, MemoryUtil.memAddress(table));
    }

    public static void glGetnColorTable(int target, int format, int type, IntBuffer table) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnColorTable(target, format, type, table.remaining() << 2, MemoryUtil.memAddress(table));
    }

    public static void glGetnColorTable(int target, int format, int type, FloatBuffer table) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnColorTable(target, format, type, table.remaining() << 2, MemoryUtil.memAddress(table));
    }

    public static void nglGetnConvolutionFilter(int target, int format, int type, int bufSize, long image) {
        long __functionAddress = GL45.getInstance().GetnConvolutionFilter;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIPV(__functionAddress, target, format, type, bufSize, image);
    }

    public static void glGetnConvolutionFilter(int target, int format, int type, int bufSize, ByteBuffer image) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)image, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnConvolutionFilter(target, format, type, bufSize, MemoryUtil.memAddress(image));
    }

    public static void glGetnConvolutionFilter(int target, int format, int type, int bufSize, long imageOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetnConvolutionFilter(target, format, type, bufSize, imageOffset);
    }

    public static void glGetnConvolutionFilter(int target, int format, int type, ByteBuffer image) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnConvolutionFilter(target, format, type, image.remaining(), MemoryUtil.memAddress(image));
    }

    public static void nglGetnSeparableFilter(int target, int format, int type, int rowBufSize, long row, int columnBufSize, long column, long span) {
        long __functionAddress = GL45.getInstance().GetnSeparableFilter;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIPIPPV(__functionAddress, target, format, type, rowBufSize, row, columnBufSize, column, span);
    }

    public static void glGetnSeparableFilter(int target, int format, int type, int rowBufSize, ByteBuffer row, int columnBufSize, ByteBuffer column, ByteBuffer span) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)row, rowBufSize);
            GLChecks.ensureBufferObject(35053, false);
            Checks.checkBuffer((Buffer)column, columnBufSize);
        }
        GL45.nglGetnSeparableFilter(target, format, type, rowBufSize, MemoryUtil.memAddress(row), columnBufSize, MemoryUtil.memAddress(column), MemoryUtil.memAddressSafe(span));
    }

    public static void glGetnSeparableFilter(int target, int format, int type, int rowBufSize, long rowOffset, int columnBufSize, long columnOffset, ByteBuffer span) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetnSeparableFilter(target, format, type, rowBufSize, rowOffset, columnBufSize, columnOffset, MemoryUtil.memAddressSafe(span));
    }

    public static void glGetnSeparableFilter(int target, int format, int type, ByteBuffer row, ByteBuffer column, ByteBuffer span) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnSeparableFilter(target, format, type, row.remaining(), MemoryUtil.memAddress(row), column.remaining(), MemoryUtil.memAddress(column), MemoryUtil.memAddressSafe(span));
    }

    public static void nglGetnHistogram(int target, boolean reset, int format, int type, int bufSize, long values) {
        long __functionAddress = GL45.getInstance().GetnHistogram;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIZIIIPV(__functionAddress, target, reset, format, type, bufSize, values);
    }

    public static void glGetnHistogram(int target, boolean reset, int format, int type, int bufSize, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnHistogram(target, reset, format, type, bufSize, MemoryUtil.memAddress(values));
    }

    public static void glGetnHistogram(int target, boolean reset, int format, int type, int bufSize, long valuesOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetnHistogram(target, reset, format, type, bufSize, valuesOffset);
    }

    public static void glGetnHistogram(int target, boolean reset, int format, int type, ByteBuffer values) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnHistogram(target, reset, format, type, values.remaining(), MemoryUtil.memAddress(values));
    }

    public static void nglGetnMinmax(int target, boolean reset, int format, int type, int bufSize, long values) {
        long __functionAddress = GL45.getInstance().GetnMinmax;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIZIIIPV(__functionAddress, target, reset, format, type, bufSize, values);
    }

    public static void glGetnMinmax(int target, boolean reset, int format, int type, int bufSize, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnMinmax(target, reset, format, type, bufSize, MemoryUtil.memAddress(values));
    }

    public static void glGetnMinmax(int target, boolean reset, int format, int type, int bufSize, long valuesOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetnMinmax(target, reset, format, type, bufSize, valuesOffset);
    }

    public static void glGetnMinmax(int target, boolean reset, int format, int type, ByteBuffer values) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnMinmax(target, reset, format, type, values.remaining(), MemoryUtil.memAddress(values));
    }

    public static void nglGetnCompressedTexImage(int target, int level, int bufSize, long img) {
        long __functionAddress = GL45.getInstance().GetnCompressedTexImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIPV(__functionAddress, target, level, bufSize, img);
    }

    public static void glGetnCompressedTexImage(int target, int level, int bufSize, ByteBuffer img) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)img, bufSize);
            if (Checks.DEBUG) {
                Checks.checkBuffer((Buffer)img, GL11.glGetTexLevelParameteri(target, level, 34464));
            }
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnCompressedTexImage(target, level, bufSize, MemoryUtil.memAddress(img));
    }

    public static void glGetnCompressedTexImage(int target, int level, int bufSize, long imgOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        GL45.nglGetnCompressedTexImage(target, level, bufSize, imgOffset);
    }

    public static void glGetnCompressedTexImage(int target, int level, ByteBuffer img) {
        if (Checks.CHECKS) {
            if (Checks.DEBUG) {
                Checks.checkBuffer((Buffer)img, GL11.glGetTexLevelParameteri(target, level, 34464));
            }
            GLChecks.ensureBufferObject(35053, false);
        }
        GL45.nglGetnCompressedTexImage(target, level, img.remaining(), MemoryUtil.memAddress(img));
    }

    public static void nglGetnUniformfv(int program, int location, int bufSize, long params) {
        long __functionAddress = GL45.getInstance().GetnUniformfv;
        JNI.callIIIPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformfv(int program, int location, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        GL45.nglGetnUniformfv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformfv(int program, int location, FloatBuffer params) {
        GL45.nglGetnUniformfv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static float glGetnUniformf(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GL45.nglGetnUniformfv(program, location, 1, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetnUniformdv(int program, int location, int bufSize, long params) {
        long __functionAddress = GL45.getInstance().GetnUniformdv;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformdv(int program, int location, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 3);
        }
        GL45.nglGetnUniformdv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformdv(int program, int location, DoubleBuffer params) {
        GL45.nglGetnUniformdv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static double glGetnUniformd(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.doubleParam();
        GL45.nglGetnUniformdv(program, location, 1, __buffer.address(params));
        return __buffer.doubleValue(params);
    }

    public static void nglGetnUniformiv(int program, int location, int bufSize, long params) {
        long __functionAddress = GL45.getInstance().GetnUniformiv;
        JNI.callIIIPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformiv(int program, int location, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        GL45.nglGetnUniformiv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformiv(int program, int location, FloatBuffer params) {
        GL45.nglGetnUniformiv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static float glGetnUniformi(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GL45.nglGetnUniformiv(program, location, 1, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetnUniformuiv(int program, int location, int bufSize, long params) {
        long __functionAddress = GL45.getInstance().GetnUniformuiv;
        JNI.callIIIPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformuiv(int program, int location, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        GL45.nglGetnUniformuiv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformuiv(int program, int location, FloatBuffer params) {
        GL45.nglGetnUniformuiv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static float glGetnUniformui(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GL45.nglGetnUniformuiv(program, location, 1, __buffer.address(params));
        return __buffer.floatValue(params);
    }
}

