/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.io.PrintStream;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageAMDCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libffi.Closure;

public final class GLUtil {
    private GLUtil() {
    }

    public static void checkGLError() throws OpenGLException {
        int err = GL11.glGetError();
        if (err != 0) {
            throw new OpenGLException(err);
        }
    }

    public static String getErrorString(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "No error";
            }
            case 1280: {
                return "Enum argument out of range";
            }
            case 1281: {
                return "Numeric argument out of range";
            }
            case 1282: {
                return "Operation illegal in current state";
            }
            case 1283: {
                return "Command would cause a stack overflow";
            }
            case 1284: {
                return "Command would cause a stack underflow";
            }
            case 1285: {
                return "Not enough memory left to execute command";
            }
            case 1286: {
                return "Framebuffer object is not complete";
            }
            case 32817: {
                return "The specified table is too large";
            }
        }
        return APIUtil.apiUnknownToken(errorCode);
    }

    public static Closure setupDebugMessageCallback() {
        return GLUtil.setupDebugMessageCallback(APIUtil.DEBUG_STREAM);
    }

    public static Closure setupDebugMessageCallback(PrintStream stream) {
        GLCapabilities caps = GL.getCapabilities();
        if (caps.OpenGL43) {
            APIUtil.apiLog("[GL] Using OpenGL 4.3 for error logging.");
            GLDebugMessageCallback proc = GLUtil.createDEBUGPROC(stream);
            GL43.glDebugMessageCallback(proc, 0L);
            if ((GL11.glGetInteger(33310) & 2) == 0) {
                APIUtil.apiLog("[GL] Warning: A non-debug context may not produce any debug output.");
                GL11.glEnable(37600);
            }
            return proc;
        }
        if (caps.GL_KHR_debug) {
            APIUtil.apiLog("[GL] Using KHR_debug for error logging.");
            GLDebugMessageCallback proc = GLUtil.createDEBUGPROC(stream);
            KHRDebug.glDebugMessageCallback(proc, 0L);
            if (caps.OpenGL30 && (GL11.glGetInteger(33310) & 2) == 0) {
                APIUtil.apiLog("[GL] Warning: A non-debug context may not produce any debug output.");
                GL11.glEnable(37600);
            }
            return proc;
        }
        if (caps.GL_ARB_debug_output) {
            APIUtil.apiLog("[GL] Using ARB_debug_output for error logging.");
            GLDebugMessageARBCallback proc = GLUtil.createDEBUGPROCARB(stream);
            ARBDebugOutput.glDebugMessageCallbackARB(proc, 0L);
            return proc;
        }
        if (caps.GL_AMD_debug_output) {
            APIUtil.apiLog("[GL] Using AMD_debug_output for error logging.");
            GLDebugMessageAMDCallback proc = GLUtil.createDEBUGPROCAMD(stream);
            AMDDebugOutput.glDebugMessageCallbackAMD(proc, 0L);
            return proc;
        }
        APIUtil.apiLog("[GL] No debug output implementation is available.");
        return null;
    }

    private static void printDetail(PrintStream stream, String type, String message) {
        stream.printf("\t%s: %s\n", type, message);
    }

    private static GLDebugMessageCallback createDEBUGPROC(final PrintStream stream) {
        return new GLDebugMessageCallback(){

            @Override
            public void invoke(int source, int type, int id, int severity, int length, long message, long userParam) {
                stream.println("[LWJGL] OpenGL debug message");
                GLUtil.printDetail(stream, "ID", String.format("0x%X", id));
                GLUtil.printDetail(stream, "Source", this.getSource(source));
                GLUtil.printDetail(stream, "Type", this.getType(type));
                GLUtil.printDetail(stream, "Severity", this.getSeverity(severity));
                GLUtil.printDetail(stream, "Message", MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(message, length)));
            }

            private String getSource(int source) {
                switch (source) {
                    case 33350: {
                        return "API";
                    }
                    case 33351: {
                        return "WINDOW SYSTEM";
                    }
                    case 33352: {
                        return "SHADER COMPILER";
                    }
                    case 33353: {
                        return "THIRD PARTY";
                    }
                    case 33354: {
                        return "APPLICATION";
                    }
                    case 33355: {
                        return "OTHER";
                    }
                }
                return APIUtil.apiUnknownToken(source);
            }

            private String getType(int type) {
                switch (type) {
                    case 33356: {
                        return "ERROR";
                    }
                    case 33357: {
                        return "DEPRECATED BEHAVIOR";
                    }
                    case 33358: {
                        return "UNDEFINED BEHAVIOR";
                    }
                    case 33359: {
                        return "PORTABILITY";
                    }
                    case 33360: {
                        return "PERFORMANCE";
                    }
                    case 33361: {
                        return "OTHER";
                    }
                    case 33384: {
                        return "MARKER";
                    }
                }
                return APIUtil.apiUnknownToken(type);
            }

            private String getSeverity(int severity) {
                switch (severity) {
                    case 37190: {
                        return "HIGH";
                    }
                    case 37191: {
                        return "MEDIUM";
                    }
                    case 37192: {
                        return "LOW";
                    }
                    case 33387: {
                        return "NOTIFICATION";
                    }
                }
                return APIUtil.apiUnknownToken(severity);
            }
        };
    }

    private static GLDebugMessageARBCallback createDEBUGPROCARB(final PrintStream stream) {
        return new GLDebugMessageARBCallback(){

            @Override
            public void invoke(int source, int type, int id, int severity, int length, long message, long userParam) {
                stream.println("[LWJGL] ARB_debug_output message");
                GLUtil.printDetail(stream, "ID", String.format("0x%X", id));
                GLUtil.printDetail(stream, "Source", this.getSource(source));
                GLUtil.printDetail(stream, "Type", this.getType(type));
                GLUtil.printDetail(stream, "Severity", this.getSeverity(severity));
                GLUtil.printDetail(stream, "Message", MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(message, length)));
            }

            private String getSource(int source) {
                switch (source) {
                    case 33350: {
                        return "API";
                    }
                    case 33351: {
                        return "WINDOW SYSTEM";
                    }
                    case 33352: {
                        return "SHADER COMPILER";
                    }
                    case 33353: {
                        return "THIRD PARTY";
                    }
                    case 33354: {
                        return "APPLICATION";
                    }
                    case 33355: {
                        return "OTHER";
                    }
                }
                return APIUtil.apiUnknownToken(source);
            }

            private String getType(int type) {
                switch (type) {
                    case 33356: {
                        return "ERROR";
                    }
                    case 33357: {
                        return "DEPRECATED BEHAVIOR";
                    }
                    case 33358: {
                        return "UNDEFINED BEHAVIOR";
                    }
                    case 33359: {
                        return "PORTABILITY";
                    }
                    case 33360: {
                        return "PERFORMANCE";
                    }
                    case 33361: {
                        return "OTHER";
                    }
                }
                return APIUtil.apiUnknownToken(type);
            }

            private String getSeverity(int severity) {
                switch (severity) {
                    case 37190: {
                        return "HIGH";
                    }
                    case 37191: {
                        return "MEDIUM";
                    }
                    case 37192: {
                        return "LOW";
                    }
                }
                return APIUtil.apiUnknownToken(severity);
            }
        };
    }

    private static GLDebugMessageAMDCallback createDEBUGPROCAMD(final PrintStream stream) {
        return new GLDebugMessageAMDCallback(){

            @Override
            public void invoke(int id, int category, int severity, int length, long message, long userParam) {
                stream.println("[LWJGL] AMD_debug_output message");
                GLUtil.printDetail(stream, "ID", String.format("0x%X", id));
                GLUtil.printDetail(stream, "Category", this.getCategory(category));
                GLUtil.printDetail(stream, "Severity", this.getSeverity(severity));
                GLUtil.printDetail(stream, "Message", MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(message, length)));
            }

            private String getCategory(int category) {
                switch (category) {
                    case 37193: {
                        return "API ERROR";
                    }
                    case 37194: {
                        return "WINDOW SYSTEM";
                    }
                    case 37195: {
                        return "DEPRECATION";
                    }
                    case 37196: {
                        return "UNDEFINED BEHAVIOR";
                    }
                    case 37197: {
                        return "PERFORMANCE";
                    }
                    case 37198: {
                        return "SHADER COMPILER";
                    }
                    case 37199: {
                        return "APPLICATION";
                    }
                    case 37200: {
                        return "OTHER";
                    }
                }
                return APIUtil.apiUnknownToken(category);
            }

            private String getSeverity(int severity) {
                switch (severity) {
                    case 37190: {
                        return "HIGH";
                    }
                    case 37191: {
                        return "MEDIUM";
                    }
                    case 37192: {
                        return "LOW";
                    }
                }
                return APIUtil.apiUnknownToken(severity);
            }
        };
    }
}

