/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XVisualInfo;

public class GLX {
    public static final int GLXBadContext = 0;
    public static final int GLXBadContextState = 1;
    public static final int GLXBadDrawable = 2;
    public static final int GLXBadPixmap = 3;
    public static final int GLXBadContextTag = 4;
    public static final int GLXBadCurrentWindow = 5;
    public static final int GLXBadRenderRequest = 6;
    public static final int GLXBadLargeRequest = 7;
    public static final int GLXUnsupportedPrivateRequest = 8;
    public static final int GLXBadFBConfig = 9;
    public static final int GLXBadPbuffer = 10;
    public static final int GLXBadCurrentDrawable = 11;
    public static final int GLXBadWindow = 12;
    public static final int GLX_USE_GL = 1;
    public static final int GLX_BUFFER_SIZE = 2;
    public static final int GLX_LEVEL = 3;
    public static final int GLX_RGBA = 4;
    public static final int GLX_DOUBLEBUFFER = 5;
    public static final int GLX_STEREO = 6;
    public static final int GLX_AUX_BUFFERS = 7;
    public static final int GLX_RED_SIZE = 8;
    public static final int GLX_GREEN_SIZE = 9;
    public static final int GLX_BLUE_SIZE = 10;
    public static final int GLX_ALPHA_SIZE = 11;
    public static final int GLX_DEPTH_SIZE = 12;
    public static final int GLX_STENCIL_SIZE = 13;
    public static final int GLX_ACCUM_RED_SIZE = 14;
    public static final int GLX_ACCUM_GREEN_SIZE = 15;
    public static final int GLX_ACCUM_BLUE_SIZE = 16;
    public static final int GLX_ACCUM_ALPHA_SIZE = 17;
    public static final int GLX_BAD_SCREEN = 1;
    public static final int GLX_BAD_ATTRIBUTE = 2;
    public static final int GLX_NO_EXTENSION = 3;
    public static final int GLX_BAD_VISUAL = 4;
    public static final int GLX_BAD_CONTEXT = 5;
    public static final int GLX_BAD_VALUE = 6;
    public static final int GLX_BAD_ENUM = 7;
    public final long QueryExtension;
    public final long QueryVersion;
    public final long GetConfig;
    public final long ChooseVisual;
    public final long CreateContext;
    public final long MakeCurrent;
    public final long CopyContext;
    public final long IsDirect;
    public final long DestroyContext;
    public final long GetCurrentContext;
    public final long GetCurrentDrawable;
    public final long WaitGL;
    public final long WaitX;
    public final long SwapBuffers;
    public final long UseXFont;
    public final long CreateGLXPixmap;
    public final long DestroyGLXPixmap;

    protected GLX() {
        throw new UnsupportedOperationException();
    }

    public GLX(FunctionProvider provider) {
        this.QueryExtension = provider.getFunctionAddress("glXQueryExtension");
        this.QueryVersion = provider.getFunctionAddress("glXQueryVersion");
        this.GetConfig = provider.getFunctionAddress("glXGetConfig");
        this.ChooseVisual = provider.getFunctionAddress("glXChooseVisual");
        this.CreateContext = provider.getFunctionAddress("glXCreateContext");
        this.MakeCurrent = provider.getFunctionAddress("glXMakeCurrent");
        this.CopyContext = provider.getFunctionAddress("glXCopyContext");
        this.IsDirect = provider.getFunctionAddress("glXIsDirect");
        this.DestroyContext = provider.getFunctionAddress("glXDestroyContext");
        this.GetCurrentContext = provider.getFunctionAddress("glXGetCurrentContext");
        this.GetCurrentDrawable = provider.getFunctionAddress("glXGetCurrentDrawable");
        this.WaitGL = provider.getFunctionAddress("glXWaitGL");
        this.WaitX = provider.getFunctionAddress("glXWaitX");
        this.SwapBuffers = provider.getFunctionAddress("glXSwapBuffers");
        this.UseXFont = provider.getFunctionAddress("glXUseXFont");
        this.CreateGLXPixmap = provider.getFunctionAddress("glXCreateGLXPixmap");
        this.DestroyGLXPixmap = provider.getFunctionAddress("glXDestroyGLXPixmap");
    }

    public static GLX getInstance() {
        return GLX.getInstance(GL.getCapabilities());
    }

    public static GLX getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLX);
    }

    static GLX create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX")) {
            return null;
        }
        GLX funcs = new GLX(provider);
        boolean supported = Checks.checkFunctions(funcs.QueryExtension, funcs.QueryVersion, funcs.GetConfig, funcs.ChooseVisual, funcs.CreateContext, funcs.MakeCurrent, funcs.CopyContext, funcs.IsDirect, funcs.DestroyContext, funcs.GetCurrentContext, funcs.GetCurrentDrawable, funcs.WaitGL, funcs.WaitX, funcs.SwapBuffers, funcs.UseXFont, funcs.CreateGLXPixmap, funcs.DestroyGLXPixmap);
        return GL.checkExtension("GLX", funcs, supported);
    }

    public static int nglXQueryExtension(long display, long error_base, long event_base) {
        long __functionAddress = GLX.getInstance().QueryExtension;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPPPI(__functionAddress, display, error_base, event_base);
    }

    public static int glXQueryExtension(long display, ByteBuffer error_base, ByteBuffer event_base) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)error_base, 4);
            Checks.checkBuffer((Buffer)event_base, 4);
        }
        return GLX.nglXQueryExtension(display, MemoryUtil.memAddress(error_base), MemoryUtil.memAddress(event_base));
    }

    public static int glXQueryExtension(long display, IntBuffer error_base, IntBuffer event_base) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)error_base, 1);
            Checks.checkBuffer((Buffer)event_base, 1);
        }
        return GLX.nglXQueryExtension(display, MemoryUtil.memAddress(error_base), MemoryUtil.memAddress(event_base));
    }

    public static int nglXQueryVersion(long display, long major, long minor) {
        long __functionAddress = GLX.getInstance().QueryVersion;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPPPI(__functionAddress, display, major, minor);
    }

    public static int glXQueryVersion(long display, ByteBuffer major, ByteBuffer minor) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)major, 4);
            Checks.checkBuffer((Buffer)minor, 4);
        }
        return GLX.nglXQueryVersion(display, MemoryUtil.memAddress(major), MemoryUtil.memAddress(minor));
    }

    public static int glXQueryVersion(long display, IntBuffer major, IntBuffer minor) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)major, 1);
            Checks.checkBuffer((Buffer)minor, 1);
        }
        return GLX.nglXQueryVersion(display, MemoryUtil.memAddress(major), MemoryUtil.memAddress(minor));
    }

    public static int nglXGetConfig(long display, long visual, int attribute, long value) {
        long __functionAddress = GLX.getInstance().GetConfig;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPPIPI(__functionAddress, display, visual, attribute, value);
    }

    public static int glXGetConfig(long display, XVisualInfo visual, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return GLX.nglXGetConfig(display, visual.address(), attribute, MemoryUtil.memAddress(value));
    }

    public static int glXGetConfig(long display, XVisualInfo visual, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return GLX.nglXGetConfig(display, visual.address(), attribute, MemoryUtil.memAddress(value));
    }

    public static long nglXChooseVisual(long display, int screen, long attrib_list) {
        long __functionAddress = GLX.getInstance().ChooseVisual;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPIPP(__functionAddress, display, screen, attrib_list);
    }

    public static XVisualInfo glXChooseVisual(long display, int screen, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list);
        }
        long __result = GLX.nglXChooseVisual(display, screen, MemoryUtil.memAddressSafe(attrib_list));
        return new XVisualInfo(__result);
    }

    public static XVisualInfo glXChooseVisual(long display, int screen, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list);
        }
        long __result = GLX.nglXChooseVisual(display, screen, MemoryUtil.memAddressSafe(attrib_list));
        return new XVisualInfo(__result);
    }

    public static long nglXCreateContext(long display, long visual, long share_list, int direct) {
        long __functionAddress = GLX.getInstance().CreateContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPPPIP(__functionAddress, display, visual, share_list, direct);
    }

    public static long glXCreateContext(long display, XVisualInfo visual, long share_list, int direct) {
        return GLX.nglXCreateContext(display, visual.address(), share_list, direct);
    }

    public static int glXMakeCurrent(long display, long draw, long ctx) {
        long __functionAddress = GLX.getInstance().MakeCurrent;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPPPI(__functionAddress, display, draw, ctx);
    }

    public static void glXCopyContext(long display, long source, long dest, long mask) {
        long __functionAddress = GLX.getInstance().CopyContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(source);
            Checks.checkPointer(dest);
        }
        JNI.callPPPPV(__functionAddress, display, source, dest, mask);
    }

    public static int glXIsDirect(long display, long ctx) {
        long __functionAddress = GLX.getInstance().IsDirect;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(ctx);
        }
        return JNI.callPPI(__functionAddress, display, ctx);
    }

    public static void glXDestroyContext(long display, long ctx) {
        long __functionAddress = GLX.getInstance().DestroyContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(ctx);
        }
        JNI.callPPV(__functionAddress, display, ctx);
    }

    public static long glXGetCurrentContext() {
        long __functionAddress = GLX.getInstance().GetCurrentContext;
        return JNI.callP(__functionAddress);
    }

    public static long glXGetCurrentDrawable() {
        long __functionAddress = GLX.getInstance().GetCurrentDrawable;
        return JNI.callP(__functionAddress);
    }

    public static void glXWaitGL() {
        long __functionAddress = GLX.getInstance().WaitGL;
        JNI.callV(__functionAddress);
    }

    public static void glXWaitX() {
        long __functionAddress = GLX.getInstance().WaitX;
        JNI.callV(__functionAddress);
    }

    public static void glXSwapBuffers(long display, long draw) {
        long __functionAddress = GLX.getInstance().SwapBuffers;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(draw);
        }
        JNI.callPPV(__functionAddress, display, draw);
    }

    public static void glXUseXFont(long font, int first, int count, int list_base) {
        long __functionAddress = GLX.getInstance().UseXFont;
        JNI.callPIIIV(__functionAddress, font, first, count, list_base);
    }

    public static long nglXCreateGLXPixmap(long display, long visual, long pixmap) {
        long __functionAddress = GLX.getInstance().CreateGLXPixmap;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPPPP(__functionAddress, display, visual, pixmap);
    }

    public static long glXCreateGLXPixmap(long display, XVisualInfo visual, long pixmap) {
        return GLX.nglXCreateGLXPixmap(display, visual.address(), pixmap);
    }

    public static void glXDestroyGLXPixmap(long display, long pixmap) {
        long __functionAddress = GLX.getInstance().DestroyGLXPixmap;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(pixmap);
        }
        JNI.callPPV(__functionAddress, display, pixmap);
    }
}

