/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class GLX14 {
    public static final int GLX_SAMPLE_BUFFERS = 100000;
    public static final int GLX_SAMPLES = 100001;
    public final long GetProcAddress;

    protected GLX14() {
        throw new UnsupportedOperationException();
    }

    public GLX14(FunctionProvider provider) {
        this.GetProcAddress = provider.getFunctionAddress("glXGetProcAddress");
    }

    public static GLX14 getInstance() {
        return GLX14.getInstance(GL.getCapabilities());
    }

    public static GLX14 getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLX14);
    }

    static GLX14 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX14")) {
            return null;
        }
        GLX14 funcs = new GLX14(provider);
        boolean supported = Checks.checkFunctions(funcs.GetProcAddress);
        return GL.checkExtension("GLX14", funcs, supported);
    }

    public static long nglXGetProcAddress(long procName) {
        long __functionAddress = GLX14.getInstance().GetProcAddress;
        return JNI.callPP(__functionAddress, procName);
    }

    public static long glXGetProcAddress(ByteBuffer procName) {
        return GLX14.nglXGetProcAddress(MemoryUtil.memAddress(procName));
    }
}

