/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class GLXNVSwapGroup {
    public final long JoinSwapGroupNV;
    public final long BindSwapBarrierNV;
    public final long QuerySwapGroupNV;
    public final long QueryMaxSwapGroupsNV;
    public final long QueryFrameCountNV;
    public final long ResetFrameCountNV;

    protected GLXNVSwapGroup() {
        throw new UnsupportedOperationException();
    }

    public GLXNVSwapGroup(FunctionProvider provider) {
        this.JoinSwapGroupNV = provider.getFunctionAddress("glXJoinSwapGroupNV");
        this.BindSwapBarrierNV = provider.getFunctionAddress("glXBindSwapBarrierNV");
        this.QuerySwapGroupNV = provider.getFunctionAddress("glXQuerySwapGroupNV");
        this.QueryMaxSwapGroupsNV = provider.getFunctionAddress("glXQueryMaxSwapGroupsNV");
        this.QueryFrameCountNV = provider.getFunctionAddress("glXQueryFrameCountNV");
        this.ResetFrameCountNV = provider.getFunctionAddress("glXResetFrameCountNV");
    }

    public static GLXNVSwapGroup getInstance() {
        return GLXNVSwapGroup.getInstance(GL.getCapabilities());
    }

    public static GLXNVSwapGroup getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLXNVSwapGroup);
    }

    static GLXNVSwapGroup create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_NV_swap_group")) {
            return null;
        }
        GLXNVSwapGroup funcs = new GLXNVSwapGroup(provider);
        boolean supported = Checks.checkFunctions(funcs.JoinSwapGroupNV, funcs.BindSwapBarrierNV, funcs.QuerySwapGroupNV, funcs.QueryMaxSwapGroupsNV, funcs.QueryFrameCountNV, funcs.ResetFrameCountNV);
        return GL.checkExtension("GLX_NV_swap_group", funcs, supported);
    }

    public static int glXJoinSwapGroupNV(long display, long drawable, int group) {
        long __functionAddress = GLXNVSwapGroup.getInstance().JoinSwapGroupNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(drawable);
        }
        return JNI.callPPII(__functionAddress, display, drawable, group);
    }

    public static int glXBindSwapBarrierNV(long display, int group, int barrier) {
        long __functionAddress = GLXNVSwapGroup.getInstance().BindSwapBarrierNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPIII(__functionAddress, display, group, barrier);
    }

    public static int nglXQuerySwapGroupNV(long display, long drawable, long group, long barrier) {
        long __functionAddress = GLXNVSwapGroup.getInstance().QuerySwapGroupNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(drawable);
        }
        return JNI.callPPPPI(__functionAddress, display, drawable, group, barrier);
    }

    public static int glXQuerySwapGroupNV(long display, long drawable, ByteBuffer group, ByteBuffer barrier) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)group, 4);
            Checks.checkBuffer((Buffer)barrier, 4);
        }
        return GLXNVSwapGroup.nglXQuerySwapGroupNV(display, drawable, MemoryUtil.memAddress(group), MemoryUtil.memAddress(barrier));
    }

    public static int glXQuerySwapGroupNV(long display, long drawable, IntBuffer group, IntBuffer barrier) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)group, 1);
            Checks.checkBuffer((Buffer)barrier, 1);
        }
        return GLXNVSwapGroup.nglXQuerySwapGroupNV(display, drawable, MemoryUtil.memAddress(group), MemoryUtil.memAddress(barrier));
    }

    public static int nglXQueryMaxSwapGroupsNV(long display, int screen, long maxGroups, long maxBarriers) {
        long __functionAddress = GLXNVSwapGroup.getInstance().QueryMaxSwapGroupsNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPIPPI(__functionAddress, display, screen, maxGroups, maxBarriers);
    }

    public static int glXQueryMaxSwapGroupsNV(long display, int screen, ByteBuffer maxGroups, ByteBuffer maxBarriers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)maxGroups, 4);
            Checks.checkBuffer((Buffer)maxBarriers, 4);
        }
        return GLXNVSwapGroup.nglXQueryMaxSwapGroupsNV(display, screen, MemoryUtil.memAddress(maxGroups), MemoryUtil.memAddress(maxBarriers));
    }

    public static int glXQueryMaxSwapGroupsNV(long display, int screen, IntBuffer maxGroups, IntBuffer maxBarriers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)maxGroups, 1);
            Checks.checkBuffer((Buffer)maxBarriers, 1);
        }
        return GLXNVSwapGroup.nglXQueryMaxSwapGroupsNV(display, screen, MemoryUtil.memAddress(maxGroups), MemoryUtil.memAddress(maxBarriers));
    }

    public static int nglXQueryFrameCountNV(long display, int screen, long count) {
        long __functionAddress = GLXNVSwapGroup.getInstance().QueryFrameCountNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPIPI(__functionAddress, display, screen, count);
    }

    public static int glXQueryFrameCountNV(long display, int screen, ByteBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, 4);
        }
        return GLXNVSwapGroup.nglXQueryFrameCountNV(display, screen, MemoryUtil.memAddress(count));
    }

    public static int glXQueryFrameCountNV(long display, int screen, IntBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        return GLXNVSwapGroup.nglXQueryFrameCountNV(display, screen, MemoryUtil.memAddress(count));
    }

    public static int glXResetFrameCountNV(long display, int screen) {
        long __functionAddress = GLXNVSwapGroup.getInstance().ResetFrameCountNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPII(__functionAddress, display, screen);
    }
}

